/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.util;

import com.cloudy.client.midp.ui.UIController;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;

public class MessageSender {
    private static final String PROTOCOL = "sms://";
    private static final int MAX_CHARS_PER_SMS = 456;
    private static UIController controller;

    public static void send(String mobileNo, byte[] message) {
        if (message != null) {
            try {
                MessageConnection connection = null;
                try {
                    connection = (MessageConnection)Connector.open((String)MessageSender.numberToUrl(mobileNo));
                }
                catch (Exception e) {
                    controller.showErrorAlert("Error creating conn: " + e.getMessage());
                }
                if (connection != null) {
                    String utf8Msg = new String(message, "UTF-8");
                    Vector smsVtr = MessageSender.splitToMultipleSMS(utf8Msg);
                    int i = 0;
                    while (i < smsVtr.size()) {
                        TextMessage binary = (TextMessage)connection.newMessage("text");
                        if (binary != null) {
                            binary.setAddress(MessageSender.numberToUrl(mobileNo));
                            binary.setPayloadText(new String(((String)smsVtr.elementAt(i)).getBytes(), "UTF-8"));
                            connection.send((Message)binary);
                        } else {
                            controller.showErrorAlert("text message null");
                        }
                        ++i;
                    }
                    connection.close();
                } else {
                    controller.showErrorAlert("lost connection");
                }
            }
            catch (Exception e) {
                controller.showErrorAlert("general error: " + e.getMessage());
            }
            message = null;
            mobileNo = null;
        }
    }

    public static String numberToUrl(String number) {
        return PROTOCOL + MessageSender.sanitizeNumber(number);
    }

    public static String sanitizeNumber(String number) {
        if (number != null) {
            if (number.charAt(0) == '+') {
                return number;
            }
            return "+6" + number;
        }
        return null;
    }

    public static Vector splitToMultipleSMS(String message) {
        if (message == null || message.trim().length() == 0) {
            return null;
        }
        Vector<String> smsVtr = new Vector<String>();
        int idx1 = -1;
        int idx2 = 0;
        StringBuffer tmpSB = new StringBuffer();
        String tmp = null;
        while ((idx2 = message.indexOf("\n", ++idx1)) != -1) {
            tmp = message.substring(idx1, idx2);
            System.out.println("tmp : " + tmp);
            System.out.println("tmpSB.length() : " + tmpSB.length());
            System.out.println("tmp.length() : " + tmp.length());
            System.out.println("tmpSB.length() + tmp.length() : " + (tmpSB.length() + tmp.length()));
            System.out.println("");
            if (tmpSB.length() + tmp.length() < 455) {
                tmpSB.append(tmp).append("\n");
            } else {
                smsVtr.addElement(tmpSB.toString());
                tmpSB = new StringBuffer();
                tmpSB.append(tmp).append("\n");
            }
            idx1 = idx2;
        }
        tmp = message.substring(idx1);
        System.out.println("tmp : " + tmp);
        System.out.println("tmpSB.length() : " + tmpSB.length());
        System.out.println("tmp.length() : " + tmp.length());
        System.out.println("tmpSB.length() + tmp.length() : " + (tmpSB.length() + tmp.length()));
        System.out.println("");
        if (tmpSB.length() + tmp.length() < 455) {
            tmpSB.append(tmp);
            smsVtr.addElement(tmpSB.toString());
        } else {
            smsVtr.addElement(tmpSB.toString());
            smsVtr.addElement(tmp);
        }
        System.out.println("No of SMS : " + smsVtr.size());
        int i = 0;
        while (i < smsVtr.size()) {
            System.out.println("=== Start ===" + smsVtr.elementAt(i));
            ++i;
        }
        return smsVtr;
    }
}

