/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.ui;

import com.cloudy.client.midp.ApplicationException;
import com.cloudy.client.midp.Cloudy;
import com.cloudy.client.midp.IndexedResourceBundle;
import com.cloudy.client.midp.model.ModelFacade;
import com.cloudy.client.midp.model.PrintDevice;
import com.cloudy.client.midp.model.ServerSettings;
import com.cloudy.client.midp.model.Settings;
import com.cloudy.client.midp.ui.AgentSelectionUI;
import com.cloudy.client.midp.ui.AutoUpdateStatusUI;
import com.cloudy.client.midp.ui.BalanceUI;
import com.cloudy.client.midp.ui.BetRecordsUI;
import com.cloudy.client.midp.ui.BuyInputCanvas;
import com.cloudy.client.midp.ui.BuyInputNoValidationCanvas;
import com.cloudy.client.midp.ui.ChangePasswordUI;
import com.cloudy.client.midp.ui.ChangeStandbyPasswordUI;
import com.cloudy.client.midp.ui.CurrencyCodeSelectionUI;
import com.cloudy.client.midp.ui.FightNumWinningUI;
import com.cloudy.client.midp.ui.GeneralResponseCanvasUI;
import com.cloudy.client.midp.ui.GeneralResponseFormUI;
import com.cloudy.client.midp.ui.LTTicketListUI;
import com.cloudy.client.midp.ui.LoginUI;
import com.cloudy.client.midp.ui.MainMenuUI;
import com.cloudy.client.midp.ui.MeaningUI;
import com.cloudy.client.midp.ui.OutstandingTicketUI;
import com.cloudy.client.midp.ui.ProgressObserverUI;
import com.cloudy.client.midp.ui.ReprintItemCanvas;
import com.cloudy.client.midp.ui.ReprintListUI;
import com.cloudy.client.midp.ui.ReprintUI;
import com.cloudy.client.midp.ui.ResultsUI;
import com.cloudy.client.midp.ui.SMSSetupUI;
import com.cloudy.client.midp.ui.SearchContactUI;
import com.cloudy.client.midp.ui.SettingsUI;
import com.cloudy.client.midp.ui.SetupPrinterUI;
import com.cloudy.client.midp.ui.StandbyUI;
import com.cloudy.client.midp.ui.TotalStakeUI;
import com.cloudy.client.midp.ui.WinningUI;
import com.cloudy.client.midp.util.BTPrintClient;
import com.cloudy.client.midp.util.DateUtil;
import com.cloudy.client.midp.util.MessageSender;
import com.cloudy.client.midp.util.NetworkMonitor;
import com.cloudy.client.midp.util.StandbyMonitor;
import java.util.Date;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.LocalDevice;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.midlet.MIDlet;

public class UIController
implements CommandListener {
    private static final String BASE_NAME_UI_RESOURCES = "UIResources";
    private ServerSettings serverSettings;
    private Cloudy midlet;
    private Display display;
    private ModelFacade model;
    private IndexedResourceBundle resourceBundle;
    private ProgressObserverUI progressObserverUI;
    private AgentSelectionUI agentSelectionUI;
    private CurrencyCodeSelectionUI currencyCodeSelectionUI;
    private AutoUpdateStatusUI autoUpdateStatusUI;
    private BalanceUI balanceUI;
    private BetRecordsUI betRecordsUI;
    private LoginUI loginUI;
    private MainMenuUI mainMenuUI;
    private BuyInputCanvas buyInputCanvas;
    private BuyInputNoValidationCanvas buyInputNoValidationCanvas;
    private TotalStakeUI totalStakeUI;
    private ResultsUI resultsUI;
    private WinningUI winningUI;
    private FightNumWinningUI fightNumWinningUI;
    private OutstandingTicketUI outstandingTicketUI;
    private MeaningUI meaningUI;
    private ReprintUI reprintUI;
    private ReprintListUI reprintListUI;
    private ReprintItemCanvas reprintItemCanvas;
    private StandbyUI standyUI;
    private SetupPrinterUI setupPrinterUI;
    private SettingsUI settingsUI;
    private ChangePasswordUI changePasswordUI;
    private ChangeStandbyPasswordUI changeStandbyPasswordUI;
    private GeneralResponseCanvasUI generalResponseCanvasUI;
    private GeneralResponseFormUI generalResponseFormUI;
    private SMSSetupUI smsSetupUI;
    private SearchContactUI searchContactUI;
    private LTTicketListUI longtimeTicketUI;
    private String reprintTransList;
    private String reprintAction;
    private Date reprintDrawDate;
    private String reprintFromPageNo;
    private String reprintToPageNo;
    private String reprintCurrPageNum;
    private String reprintNextPageNum;
    private String reprintPrevPageNum;
    private String reprintMobileNo;
    private String reprintBetNo;
    private String respLTTicket;
    private String announcementStr = "";
    private LocalDevice localDevice;

    public UIController(Cloudy midlet) {
        this.midlet = midlet;
    }

    public void init(ModelFacade model) {
        this.display = Display.getDisplay((MIDlet)this.midlet);
        this.model = model;
        try {
            this.resourceBundle = model.getResourceBundle(BASE_NAME_UI_RESOURCES);
            Settings s = model.getSettings();
            if (s == null) {
                s = new Settings();
                s.setStandbyTimeout(1800);
                s.setBetRows(70);
                s.setBetType("BSCA4A");
                s.setInputType(1);
                s.setScrollType(0);
                s.setDirectPrint(false);
                s.setDisplayfontSize(2);
                s.setPrintfontSize(1);
                model.setSettings(s);
            }
        }
        catch (ApplicationException e) {
            System.err.println("Exception " + e);
        }
        this.progressObserverUI = new ProgressObserverUI(this);
        model.setProgressObserver(this.progressObserverUI);
        this.loginUI = new LoginUI(this);
        this.mainMenuUI = new MainMenuUI(this);
        if (model.isLoggedIn()) {
            this.setCurrent((Displayable)this.mainMenuUI);
        } else {
            String address = null;
            boolean bNewAddress = false;
            try {
                address = model.getBluetoothAddress();
            }
            catch (ApplicationException applicationException) {
                // empty catch block
            }
            if (address == null) {
                try {
                    this.localDevice = LocalDevice.getLocalDevice();
                    address = this.localDevice.getBluetoothAddress();
                    bNewAddress = true;
                }
                catch (BluetoothStateException bluetoothStateException) {
                    // empty catch block
                }
            }
            if (address != null && bNewAddress) {
                try {
                    model.setBluetoothAddress(address);
                }
                catch (ApplicationException applicationException) {
                    // empty catch block
                }
            }
            String userId = null;
            try {
                userId = model.getUserId();
            }
            catch (ApplicationException applicationException) {
                // empty catch block
            }
            String serviceURL = null;
            try {
                serviceURL = model.getServiceURL();
            }
            catch (ApplicationException applicationException) {
                // empty catch block
            }
            int urlType = 0;
            try {
                urlType = model.getURL_Type();
            }
            catch (ApplicationException applicationException) {
                // empty catch block
            }
            this.loginUI.init(userId, urlType, serviceURL);
            this.setCurrent((Displayable)this.loginUI);
            this.loginUI.setItemToPassWordField();
        }
    }

    public void destroy() {
    }

    public Cloudy getMidlet() {
        return this.midlet;
    }

    public void commandAction(Command command, Displayable displayable) {
    }

    public void displayProgress(String title, boolean stoppable) {
        this.progressObserverUI.init(title, stoppable);
        this.setCurrent((Displayable)this.progressObserverUI);
    }

    public void setCurrentItem(Item i) {
        this.display.setCurrentItem(i);
    }

    public void setCurrent(Displayable d) {
        this.display.setCurrent(d);
    }

    public void setCurrent(Alert a, Displayable d) {
        this.display.setCurrent(a, d);
    }

    public Display getDisplay() {
        return this.display;
    }

    public String getString(int uiMessageCode) {
        return this.resourceBundle.getString(Integer.toString(uiMessageCode));
    }

    public String getAnnouncementStr() {
        return this.announcementStr;
    }

    public void showErrorAlert(Exception e) {
        this.showErrorAlert(new ApplicationException(e), (Displayable)this.mainMenuUI);
    }

    public void showErrorAlert(ApplicationException ae, Displayable d) {
        this.showErrorAlert(ae.getMessage(), d);
    }

    public void showErrorAlert(String message) {
        this.showErrorAlert(message, this.display.getCurrent());
    }

    public void showErrorAlert(String message, Displayable d) {
        Alert alert = new Alert("Error");
        alert.setType(AlertType.ERROR);
        alert.setTimeout(-2);
        alert.setString(message);
        this.display.setCurrent(alert, d);
    }

    public void showInfoAlert(String message, Displayable d) {
        this.showInfoAlert(null, message, d);
    }

    public void showInfoAlert(String title, String message, Displayable d) {
        Alert alert = new Alert(title == null ? this.getString(0) : title);
        alert.setType(AlertType.INFO);
        alert.setTimeout(-2);
        alert.setString(message);
        this.display.setCurrent(alert, d);
    }

    public void mainMenuRequested() {
        this.setCurrent((Displayable)this.mainMenuUI);
    }

    public void exitRequested() {
        new Thread(){

            public void run() {
                if (StandbyMonitor.getInstance() != null) {
                    StandbyMonitor.getInstance().stop();
                }
                if (NetworkMonitor.getInstance() != null) {
                    NetworkMonitor.getInstance().stop();
                }
                UIController.this.display.setCurrent(null);
                UIController.this.midlet.exit();
            }
        }.start();
    }

    public void handleEvent(int eventId) {
        new EventHandler(eventId, null).start();
    }

    public void handleEvent(int eventId, Object[] eventObjects) {
        new EventHandler(eventId, eventObjects).start();
    }

    class EventHandler
    extends Thread {
        private int eventId;
        private Displayable fallbackUI;
        private Object[] eventObjects;

        EventHandler(int eventId, Object[] eventObjects) {
            this.eventId = eventId;
            this.eventObjects = eventObjects;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            StandbyMonitor.reset();
            UIController uIController = UIController.this;
            synchronized (uIController) {
                this.run(this.eventId, this.eventObjects);
            }
        }

        private void run(int eventId, Object[] eventObjects) {
            try {
                switch (eventId) {
                    case 1: {
                        Settings s;
                        this.fallbackUI = UIController.this.loginUI;
                        UIController.this.displayProgress(UIController.this.getString(19), false);
                        String username = (String)eventObjects[0];
                        String password = (String)eventObjects[1];
                        String url = (String)eventObjects[2];
                        String urlhide = (String)eventObjects[3];
                        int url_tytpe = UIController.this.model.getURL_Type();
                        UIController.this.model.setUserId(username);
                        String tst = "0";
                        if (!(url != null && url.trim().length() != 0 || urlhide != null && urlhide.trim().length() != 0)) {
                            url = UIController.this.model.getServiceURL();
                            switch (url_tytpe) {
                                case 0: {
                                    urlhide = "";
                                    break;
                                }
                                case 1: {
                                    urlhide = "588";
                                    break;
                                }
                                case 2: {
                                    urlhide = "352";
                                    break;
                                }
                                case 3: {
                                    urlhide = "624";
                                }
                            }
                            tst = "1";
                        } else if (url.trim().length() > 0) {
                            UIController.this.model.setServiceURL(url);
                            UIController.this.model.setURL_Type(0);
                            urlhide = "";
                            tst = "2";
                        } else if (urlhide.trim().length() > 0) {
                            if (urlhide.startsWith("588") || urlhide.startsWith("352") || urlhide.startsWith("624")) {
                                if (urlhide.startsWith("588")) {
                                    url = UIController.this.model.getHideURL(1);
                                    UIController.this.model.setURL_Type(1);
                                    tst = "3";
                                } else if (urlhide.startsWith("352")) {
                                    url = UIController.this.model.getHideURL(2);
                                    UIController.this.model.setURL_Type(2);
                                    tst = "4";
                                } else if (urlhide.startsWith("624")) {
                                    url = UIController.this.model.getHideURL(3);
                                    UIController.this.model.setURL_Type(3);
                                    tst = "5";
                                }
                                UIController.this.model.setServiceURL(url);
                            } else {
                                url = UIController.this.model.getServiceURL();
                                tst = "6";
                            }
                        }
                        UIController.this.model.login(username, password, url);
                        UIController.this.announcementStr = UIController.this.model.announcement();
                        UIController.this.mainMenuUI.init();
                        UIController.this.setCurrent((Displayable)UIController.this.mainMenuUI);
                        if (UIController.this.model.getStandbyPassword() == null) {
                            UIController.this.model.setStandbyPassword(password);
                        }
                        if ((s = UIController.this.model.getSettings()).getStandbyTimeout() > 0) {
                            StandbyMonitor.init(UIController.this, s.getStandbyTimeout());
                        }
                        NetworkMonitor.init(UIController.this);
                        break;
                    }
                    case 2: {
                        UIController.this.model.setTerminated(true);
                        UIController.this.exitRequested();
                        break;
                    }
                    case 8: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        String userId = UIController.this.model.getUserId();
                        String buyMethod = UIController.this.model.getBuyMethod();
                        Settings s = UIController.this.model.getSettings();
                        int betRows = 40;
                        if (s != null) {
                            betRows = s.getBetRows();
                        }
                        if (1 == s.getInputType()) {
                            if (UIController.this.buyInputCanvas == null) {
                                UIController.this.buyInputCanvas = new BuyInputCanvas(UIController.this);
                            }
                            UIController.this.buyInputCanvas.init(UIController.this.getDisplay(), userId, buyMethod, betRows, false);
                            UIController.this.setCurrent((Displayable)UIController.this.buyInputCanvas);
                            break;
                        }
                        String betScreenLine2 = UIController.this.model.getBetScreenLine2();
                        String betScreenLine3 = UIController.this.model.getBetScreenLine3();
                        if (UIController.this.buyInputNoValidationCanvas == null) {
                            UIController.this.buyInputNoValidationCanvas = new BuyInputNoValidationCanvas(UIController.this);
                        }
                        UIController.this.buyInputNoValidationCanvas.init(UIController.this.getDisplay(), userId, betScreenLine2, betScreenLine3, betRows, false);
                        UIController.this.setCurrent((Displayable)UIController.this.buyInputNoValidationCanvas);
                        break;
                    }
                    case 73: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        String userId = UIController.this.model.getUserId();
                        String buyMethod = UIController.this.model.getBuyMethod();
                        Settings s = UIController.this.model.getSettings();
                        int betRows = 40;
                        if (s != null) {
                            betRows = s.getBetRows();
                        }
                        if (1 == s.getInputType()) {
                            if (UIController.this.buyInputCanvas == null) {
                                UIController.this.buyInputCanvas = new BuyInputCanvas(UIController.this);
                            }
                            UIController.this.buyInputCanvas.init(UIController.this.getDisplay(), userId, buyMethod, betRows, true);
                            UIController.this.setCurrent((Displayable)UIController.this.buyInputCanvas);
                            break;
                        }
                        String betScreenLine2 = UIController.this.model.getCommonHead();
                        if (UIController.this.buyInputNoValidationCanvas == null) {
                            UIController.this.buyInputNoValidationCanvas = new BuyInputNoValidationCanvas(UIController.this);
                        }
                        UIController.this.buyInputNoValidationCanvas.init(UIController.this.getDisplay(), userId, betScreenLine2, null, betRows, true);
                        UIController.this.setCurrent((Displayable)UIController.this.buyInputNoValidationCanvas);
                        break;
                    }
                    case 74: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        String userId = UIController.this.model.getUserId();
                        String buyMethod = UIController.this.model.getBuyMethod();
                        Settings s = UIController.this.model.getSettings();
                        int betRows = 40;
                        if (s != null) {
                            betRows = s.getBetRows();
                        }
                        if (1 == s.getInputType()) {
                            if (UIController.this.buyInputCanvas == null) {
                                UIController.this.buyInputCanvas = new BuyInputCanvas(UIController.this);
                            }
                            UIController.this.buyInputCanvas.init(UIController.this.getDisplay(), userId, buyMethod, betRows, true);
                            UIController.this.setCurrent((Displayable)UIController.this.buyInputCanvas);
                            break;
                        }
                        String betScreenLine2 = UIController.this.model.getBetScreenLine2();
                        String betScreenLine3 = UIController.this.model.getBetScreenLine3();
                        if (UIController.this.buyInputNoValidationCanvas == null) {
                            UIController.this.buyInputNoValidationCanvas = new BuyInputNoValidationCanvas(UIController.this);
                        }
                        UIController.this.buyInputNoValidationCanvas.init(UIController.this.getDisplay(), userId, betScreenLine2, betScreenLine3, betRows, true);
                        UIController.this.setCurrent((Displayable)UIController.this.buyInputNoValidationCanvas);
                        break;
                    }
                    case 9: {
                        this.fallbackUI = UIController.this.buyInputCanvas;
                        UIController.this.setCurrent((Displayable)UIController.this.mainMenuUI);
                        break;
                    }
                    case 10: {
                        UIController.this.displayProgress(UIController.this.getString(19), false);
                        Settings s = UIController.this.model.getSettings();
                        int betRows = 40;
                        if (s != null) {
                            betRows = s.getBetRows();
                        }
                        this.fallbackUI = 1 == s.getInputType() ? UIController.this.buyInputCanvas : UIController.this.buyInputNoValidationCanvas;
                        int nextRunningNum = UIController.this.model.getNextRunningNumber();
                        Vector trx = (Vector)eventObjects[0];
                        boolean special = (Boolean)eventObjects[1];
                        String currencyCode = (String)eventObjects[2];
                        String[] response = null;
                        try {
                            response = 1 == s.getInputType() && !special ? UIController.this.model.buy(trx, nextRunningNum, UIController.this.model.getLoginSequence(), false) : (1 == s.getInputType() && special ? UIController.this.model.buySpecial(trx, nextRunningNum, UIController.this.model.getLoginSequence(), false) : (1 != s.getInputType() && !special ? UIController.this.model.buy2(trx, nextRunningNum, UIController.this.model.getLoginSequence(), currencyCode, true) : UIController.this.model.buySpecial2(trx, nextRunningNum, UIController.this.model.getLoginSequence(), true)));
                        }
                        catch (ApplicationException e) {
                            UIController.this.model.deductRunningNumberByOne();
                            throw e;
                        }
                        StandbyMonitor.reset();
                        String userId = UIController.this.model.getUserId();
                        String buyMethod = UIController.this.model.getBuyMethod();
                        if (1 == s.getInputType()) {
                            if (UIController.this.buyInputCanvas == null) {
                                UIController.this.buyInputCanvas = new BuyInputCanvas(UIController.this);
                            }
                            UIController.this.buyInputCanvas.init(UIController.this.getDisplay(), userId, buyMethod, betRows, special);
                            if (UIController.this.generalResponseCanvasUI == null) {
                                UIController.this.generalResponseCanvasUI = new GeneralResponseCanvasUI(UIController.this);
                            }
                            UIController.this.generalResponseCanvasUI.init(UIController.this.getDisplay(), UIController.this.getString(1), true, true, true, true, s, s.isDirectPrint(), response[1], (Displayable)UIController.this.buyInputCanvas, 1);
                        } else {
                            String betScreenLine2 = UIController.this.model.getBetScreenLine2();
                            String betScreenLine3 = UIController.this.model.getBetScreenLine3();
                            if (UIController.this.buyInputNoValidationCanvas == null) {
                                UIController.this.buyInputNoValidationCanvas = new BuyInputNoValidationCanvas(UIController.this);
                            }
                            UIController.this.buyInputNoValidationCanvas.init(UIController.this.getDisplay(), userId, betScreenLine2, betScreenLine3, betRows, special);
                            if (UIController.this.generalResponseCanvasUI == null) {
                                UIController.this.generalResponseCanvasUI = new GeneralResponseCanvasUI(UIController.this);
                            }
                            UIController.this.generalResponseCanvasUI.init(UIController.this.getDisplay(), UIController.this.getString(1), true, true, true, true, s, s.isDirectPrint(), response[1], (Displayable)UIController.this.buyInputNoValidationCanvas, 1);
                        }
                        UIController.this.setCurrent((Displayable)UIController.this.generalResponseCanvasUI);
                        break;
                    }
                    case 60: {
                        this.fallbackUI = UIController.this.buyInputCanvas;
                        Vector trans = (Vector)eventObjects[0];
                        int errorLineNumber = (Integer)eventObjects[1];
                        UIController.this.model.sendInvalidBuyRequest(trans, errorLineNumber);
                        break;
                    }
                    case 51: {
                        Displayable buyScreen;
                        this.fallbackUI = buyScreen = (Displayable)eventObjects[0];
                        UIController.this.displayProgress(UIController.this.getString(19), false);
                        Vector agents = UIController.this.model.getSubAgents();
                        if (UIController.this.agentSelectionUI == null) {
                            UIController.this.agentSelectionUI = new AgentSelectionUI(UIController.this);
                        }
                        UIController.this.agentSelectionUI.init(agents, buyScreen);
                        UIController.this.setCurrent((Displayable)UIController.this.agentSelectionUI);
                        break;
                    }
                    case 52: {
                        this.fallbackUI = UIController.this.agentSelectionUI;
                        String agent = (String)eventObjects[0];
                        Displayable backUI = (Displayable)eventObjects[1];
                        if (backUI instanceof BuyInputCanvas) {
                            UIController.this.buyInputCanvas.changeAgent(agent);
                        } else if (backUI instanceof BuyInputNoValidationCanvas) {
                            UIController.this.buyInputNoValidationCanvas.changeAgent(agent);
                        }
                        UIController.this.setCurrent(backUI);
                        break;
                    }
                    case 53: {
                        Displayable backUI = (Displayable)eventObjects[0];
                        UIController.this.setCurrent(backUI);
                        break;
                    }
                    case 81: {
                        Displayable buyScreen;
                        this.fallbackUI = buyScreen = (Displayable)eventObjects[0];
                        UIController.this.displayProgress(UIController.this.getString(19), false);
                        Vector currencyCode = UIController.this.model.getCurrencyCode();
                        if (UIController.this.currencyCodeSelectionUI == null) {
                            UIController.this.currencyCodeSelectionUI = new CurrencyCodeSelectionUI(UIController.this);
                        }
                        UIController.this.currencyCodeSelectionUI.init(currencyCode, buyScreen);
                        UIController.this.setCurrent((Displayable)UIController.this.currencyCodeSelectionUI);
                        break;
                    }
                    case 82: {
                        this.fallbackUI = UIController.this.currencyCodeSelectionUI;
                        String currencyCode = (String)eventObjects[0];
                        Displayable backUI = (Displayable)eventObjects[1];
                        if (backUI instanceof BuyInputCanvas) {
                            UIController.this.buyInputCanvas.changeCurrencyCode(currencyCode);
                        } else if (backUI instanceof BuyInputNoValidationCanvas) {
                            UIController.this.buyInputNoValidationCanvas.changeCurrencyCode(currencyCode);
                        }
                        UIController.this.setCurrent(backUI);
                        break;
                    }
                    case 83: {
                        Displayable backUI = (Displayable)eventObjects[0];
                        UIController.this.setCurrent(backUI);
                        break;
                    }
                    case 61: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        if (UIController.this.searchContactUI == null) {
                            UIController.this.searchContactUI = new SearchContactUI(UIController.this);
                        }
                        UIController.this.searchContactUI.init();
                        UIController.this.setCurrent((Displayable)UIController.this.searchContactUI);
                        break;
                    }
                    case 62: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Settings s = UIController.this.model.getSettings();
                        if (1 == s.getInputType()) {
                            UIController.this.setCurrent((Displayable)UIController.this.buyInputCanvas);
                            break;
                        }
                        UIController.this.setCurrent((Displayable)UIController.this.buyInputNoValidationCanvas);
                        break;
                    }
                    case 63: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Settings s = UIController.this.model.getSettings();
                        String phoneNum = (String)eventObjects[0];
                        if (1 == s.getInputType()) {
                            UIController.this.buyInputCanvas.addContact(phoneNum, s.getInputType());
                            UIController.this.setCurrent((Displayable)UIController.this.buyInputCanvas);
                            break;
                        }
                        UIController.this.buyInputNoValidationCanvas.addContact(phoneNum, s.getInputType());
                        UIController.this.setCurrent((Displayable)UIController.this.buyInputNoValidationCanvas);
                        break;
                    }
                    case 71: {
                        this.fallbackUI = UIController.this.generalResponseCanvasUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Settings s = UIController.this.model.getSettings();
                        String pageNo = new Integer(UIController.this.model.getCurrentRunningNumber()).toString();
                        String transactionText = null;
                        String msg = null;
                        try {
                            Date serverTime = UIController.this.model.getServerTime();
                            transactionText = UIController.this.model.voidTransaction("3", DateUtil.getString(serverTime), pageNo);
                            msg = UIController.this.getString(77);
                            msg = String.valueOf(msg) + "\n\n" + transactionText;
                        }
                        catch (ApplicationException e) {
                            msg = UIController.this.getString(78);
                        }
                        UIController.this.generalResponseCanvasUI = new GeneralResponseCanvasUI(UIController.this);
                        UIController.this.generalResponseCanvasUI.init(UIController.this.getDisplay(), UIController.this.getString(73), true, true, false, false, s, false, msg, (Displayable)UIController.this.mainMenuUI, 73);
                        UIController.this.setCurrent((Displayable)UIController.this.generalResponseCanvasUI);
                        break;
                    }
                    case 72: {
                        this.fallbackUI = UIController.this.generalResponseCanvasUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Date serverTime = UIController.this.model.getServerTime();
                        String pageNo = new Integer(UIController.this.model.getCurrentRunningNumber()).toString();
                        String response = UIController.this.model.reprint("5", DateUtil.getString(serverTime), pageNo, null, null, null, null, null);
                        System.out.println("response : " + response);
                        int idx = response.indexOf("~");
                        String txt = response.substring(0, idx);
                        String specialStr = response.substring(idx + 1).trim();
                        boolean isSpecial = "T".equals(specialStr);
                        Settings s = UIController.this.model.getSettings();
                        String userId = UIController.this.model.getUserId();
                        String buyMethod = UIController.this.model.getBuyMethod();
                        int betRows = 40;
                        if (s != null) {
                            betRows = s.getBetRows();
                        }
                        if (1 == s.getInputType()) {
                            if (UIController.this.buyInputCanvas == null) {
                                UIController.this.buyInputCanvas = new BuyInputCanvas(UIController.this);
                            }
                            UIController.this.buyInputCanvas.init(UIController.this.getDisplay(), userId, buyMethod, betRows, txt, isSpecial);
                            UIController.this.setCurrent((Displayable)UIController.this.buyInputCanvas);
                            break;
                        }
                        if (UIController.this.buyInputNoValidationCanvas == null) {
                            UIController.this.buyInputNoValidationCanvas = new BuyInputNoValidationCanvas(UIController.this);
                        }
                        UIController.this.buyInputNoValidationCanvas.init(UIController.this.getDisplay(), userId, betRows, txt, isSpecial);
                        UIController.this.setCurrent((Displayable)UIController.this.buyInputNoValidationCanvas);
                        break;
                    }
                    case 11: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Date serverTime = UIController.this.model.getServerTime();
                        String lastPageNo = UIController.this.model.reprint("4", null, null, null, null, null, null, null);
                        if (UIController.this.reprintUI == null) {
                            UIController.this.reprintUI = new ReprintUI(UIController.this);
                        }
                        UIController.this.reprintUI.init(lastPageNo, serverTime);
                        UIController.this.setCurrent((Displayable)UIController.this.reprintUI);
                        break;
                    }
                    case 12: {
                        UIController.this.setCurrent((Displayable)UIController.this.mainMenuUI);
                        break;
                    }
                    case 13: {
                        this.fallbackUI = UIController.this.reprintUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        UIController.this.reprintAction = (String)eventObjects[0];
                        UIController.this.reprintDrawDate = (Date)eventObjects[1];
                        if ("1".equals(UIController.this.reprintAction)) {
                            UIController.this.reprintFromPageNo = (String)eventObjects[2];
                            UIController.this.reprintToPageNo = (String)eventObjects[3];
                            UIController.this.reprintCurrPageNum = (String)eventObjects[4];
                            UIController.this.reprintTransList = UIController.this.model.reprint(UIController.this.reprintAction, DateUtil.getString(UIController.this.reprintDrawDate), UIController.this.reprintFromPageNo, UIController.this.reprintToPageNo, UIController.this.reprintCurrPageNum, null, null, null);
                        } else if ("6".equals(UIController.this.reprintAction)) {
                            UIController.this.reprintMobileNo = (String)eventObjects[2];
                            UIController.this.reprintCurrPageNum = (String)eventObjects[3];
                            UIController.this.reprintTransList = UIController.this.model.reprint(UIController.this.reprintAction, DateUtil.getString(UIController.this.reprintDrawDate), null, null, UIController.this.reprintCurrPageNum, UIController.this.reprintMobileNo, null, null);
                        } else if ("7".equals(UIController.this.reprintAction)) {
                            UIController.this.reprintCurrPageNum = (String)eventObjects[2];
                            UIController.this.reprintTransList = UIController.this.model.reprint(UIController.this.reprintAction, DateUtil.getString(UIController.this.reprintDrawDate), null, null, UIController.this.reprintCurrPageNum, null, null, null);
                        } else if ("7".equals(UIController.this.reprintAction)) {
                            UIController.this.reprintCurrPageNum = (String)eventObjects[2];
                            UIController.this.reprintTransList = UIController.this.model.reprint(UIController.this.reprintAction, DateUtil.getString(UIController.this.reprintDrawDate), null, null, UIController.this.reprintCurrPageNum, null, null, null);
                        } else if ("8".equals(UIController.this.reprintAction)) {
                            UIController.this.reprintBetNo = (String)eventObjects[2];
                            UIController.this.reprintCurrPageNum = (String)eventObjects[3];
                            UIController.this.reprintTransList = UIController.this.model.reprint(UIController.this.reprintAction, DateUtil.getString(UIController.this.reprintDrawDate), null, null, UIController.this.reprintCurrPageNum, null, null, UIController.this.reprintBetNo);
                        }
                        UIController.this.reprintListUI = new ReprintListUI(UIController.this);
                        UIController.this.reprintListUI.init(UIController.this.reprintTransList);
                        UIController.this.setCurrent((Displayable)UIController.this.reprintListUI);
                        break;
                    }
                    case 65: {
                        this.fallbackUI = UIController.this.reprintUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        UIController.this.reprintCurrPageNum = (String)eventObjects[0];
                        String txt = null;
                        if ("1".equals(UIController.this.reprintAction)) {
                            txt = UIController.this.model.reprint("1", DateUtil.getString(UIController.this.reprintDrawDate), UIController.this.reprintFromPageNo, UIController.this.reprintToPageNo, UIController.this.reprintCurrPageNum, null, null, null);
                        } else if ("6".equals(UIController.this.reprintAction)) {
                            txt = UIController.this.model.reprint("6", DateUtil.getString(UIController.this.reprintDrawDate), null, null, UIController.this.reprintCurrPageNum, UIController.this.reprintMobileNo, null, null);
                        } else if ("7".equals(UIController.this.reprintAction)) {
                            txt = UIController.this.model.reprint("7", DateUtil.getString(UIController.this.reprintDrawDate), null, null, UIController.this.reprintCurrPageNum, null, null, null);
                        } else if ("8".equals(UIController.this.reprintAction)) {
                            txt = UIController.this.model.reprint("8", DateUtil.getString(UIController.this.reprintDrawDate), null, null, UIController.this.reprintCurrPageNum, null, null, UIController.this.reprintBetNo);
                        }
                        UIController.this.reprintListUI = new ReprintListUI(UIController.this);
                        UIController.this.reprintListUI.init(txt);
                        UIController.this.setCurrent((Displayable)UIController.this.reprintListUI);
                        break;
                    }
                    case 64: {
                        this.fallbackUI = UIController.this.reprintListUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        String txt = (String)eventObjects[0];
                        String curPgNum = (String)eventObjects[1];
                        String totPgNum = (String)eventObjects[2];
                        String prevPgNum = (String)eventObjects[3];
                        String nextPgNum = (String)eventObjects[4];
                        if (UIController.this.reprintItemCanvas == null) {
                            UIController.this.reprintItemCanvas = new ReprintItemCanvas(UIController.this);
                        }
                        UIController.this.reprintItemCanvas.init(txt, UIController.this.model.getSettings(), curPgNum, totPgNum, prevPgNum, nextPgNum);
                        UIController.this.setCurrent((Displayable)UIController.this.reprintItemCanvas);
                        break;
                    }
                    case 70: {
                        UIController.this.setCurrent((Displayable)UIController.this.reprintUI);
                        break;
                    }
                    case 79: {
                        this.fallbackUI = UIController.this.reprintItemCanvas;
                        UIController.this.reprintListUI.autoMoveUp();
                        UIController.this.setCurrent((Displayable)UIController.this.reprintListUI);
                        break;
                    }
                    case 80: {
                        this.fallbackUI = UIController.this.reprintItemCanvas;
                        UIController.this.reprintListUI.autoMoveDown();
                        UIController.this.setCurrent((Displayable)UIController.this.reprintListUI);
                        break;
                    }
                    case 68: {
                        this.fallbackUI = UIController.this.reprintItemCanvas;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Settings s = UIController.this.model.getSettings();
                        String selectedDate = (String)eventObjects[0];
                        String selectedPageNo = (String)eventObjects[1];
                        String transactionText = null;
                        String msg = null;
                        try {
                            transactionText = UIController.this.model.voidTransaction("3", selectedDate, selectedPageNo);
                            msg = UIController.this.getString(77);
                            msg = String.valueOf(msg) + "\n\n" + transactionText;
                        }
                        catch (ApplicationException e) {
                            msg = UIController.this.getString(78);
                        }
                        UIController.this.generalResponseCanvasUI = new GeneralResponseCanvasUI(UIController.this);
                        Vector<Object> v = new Vector<Object>();
                        v.addElement(new Integer(13));
                        if ("1".equals(UIController.this.reprintAction)) {
                            v.addElement(UIController.this.reprintAction);
                            v.addElement(UIController.this.reprintDrawDate);
                            v.addElement(UIController.this.reprintFromPageNo);
                            v.addElement(UIController.this.reprintToPageNo);
                            v.addElement(UIController.this.reprintCurrPageNum);
                        } else if ("6".equals(UIController.this.reprintAction)) {
                            v.addElement(UIController.this.reprintAction);
                            v.addElement(UIController.this.reprintDrawDate);
                            v.addElement(UIController.this.reprintMobileNo);
                            v.addElement(UIController.this.reprintCurrPageNum);
                        } else if ("7".equals(UIController.this.reprintAction)) {
                            v.addElement(UIController.this.reprintAction);
                            v.addElement(UIController.this.reprintDrawDate);
                            v.addElement(UIController.this.reprintCurrPageNum);
                        } else if ("8".equals(UIController.this.reprintAction)) {
                            v.addElement(UIController.this.reprintAction);
                            v.addElement(UIController.this.reprintDrawDate);
                            v.addElement(UIController.this.reprintBetNo);
                            v.addElement(UIController.this.reprintCurrPageNum);
                        }
                        UIController.this.generalResponseCanvasUI.init(UIController.this.getDisplay(), UIController.this.getString(2), true, true, false, false, s, false, msg, v, 2);
                        UIController.this.setCurrent((Displayable)UIController.this.generalResponseCanvasUI);
                        break;
                    }
                    case 69: {
                        boolean isSpecial;
                        this.fallbackUI = UIController.this.reprintItemCanvas;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Settings s = UIController.this.model.getSettings();
                        String userId = UIController.this.model.getUserId();
                        String buyMethod = UIController.this.model.getBuyMethod();
                        int betRows = 40;
                        if (s != null) {
                            betRows = s.getBetRows();
                        }
                        String selectedDate = (String)eventObjects[0];
                        String selectedPageNo = (String)eventObjects[1];
                        String response = UIController.this.model.reprint("5", selectedDate, selectedPageNo, null, null, null, null, null);
                        int idx = response.indexOf("~");
                        String txt = response.substring(0, idx);
                        String specialStr = response.substring(idx + 1).trim();
                        boolean bl = isSpecial = "T".equals(specialStr);
                        if (1 == s.getInputType()) {
                            if (UIController.this.buyInputCanvas == null) {
                                UIController.this.buyInputCanvas = new BuyInputCanvas(UIController.this);
                            }
                            UIController.this.buyInputCanvas.init(UIController.this.getDisplay(), userId, buyMethod, betRows, txt, isSpecial);
                            UIController.this.setCurrent((Displayable)UIController.this.buyInputCanvas);
                            break;
                        }
                        if (UIController.this.buyInputNoValidationCanvas == null) {
                            UIController.this.buyInputNoValidationCanvas = new BuyInputNoValidationCanvas(UIController.this);
                        }
                        UIController.this.buyInputNoValidationCanvas.init(UIController.this.getDisplay(), userId, betRows, txt, isSpecial);
                        UIController.this.setCurrent((Displayable)UIController.this.buyInputNoValidationCanvas);
                        break;
                    }
                    case 14: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Date serverTime = UIController.this.model.getServerTime();
                        if (UIController.this.balanceUI == null) {
                            UIController.this.balanceUI = new BalanceUI(UIController.this);
                        }
                        UIController.this.balanceUI.init(serverTime);
                        UIController.this.setCurrent((Displayable)UIController.this.balanceUI);
                        break;
                    }
                    case 15: {
                        UIController.this.setCurrent((Displayable)UIController.this.mainMenuUI);
                        break;
                    }
                    case 16: {
                        this.fallbackUI = UIController.this.balanceUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Date startDate = (Date)eventObjects[0];
                        Date endDate = (Date)eventObjects[1];
                        String drawType = (String)eventObjects[2];
                        String txt = UIController.this.model.balance(startDate, endDate, drawType);
                        Settings s = UIController.this.model.getSettings();
                        UIController.this.generalResponseCanvasUI = new GeneralResponseCanvasUI(UIController.this);
                        UIController.this.generalResponseCanvasUI.init(UIController.this.getDisplay(), UIController.this.getString(3), true, true, false, false, s, false, txt, (Displayable)UIController.this.balanceUI, 3);
                        UIController.this.setCurrent((Displayable)UIController.this.generalResponseCanvasUI);
                        break;
                    }
                    case 17: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Date serverTime = UIController.this.model.getServerTime();
                        String userId = UIController.this.model.getUserId();
                        if (UIController.this.betRecordsUI == null) {
                            UIController.this.betRecordsUI = new BetRecordsUI(UIController.this);
                        }
                        UIController.this.betRecordsUI.init(userId, serverTime);
                        UIController.this.setCurrent((Displayable)UIController.this.betRecordsUI);
                        break;
                    }
                    case 18: {
                        UIController.this.setCurrent((Displayable)UIController.this.mainMenuUI);
                        break;
                    }
                    case 19: {
                        this.fallbackUI = UIController.this.betRecordsUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        String agentId = (String)eventObjects[0];
                        String number = (String)eventObjects[1];
                        Date drawDate = (Date)eventObjects[2];
                        String action = (String)eventObjects[3];
                        String txt = UIController.this.model.betRecords(agentId, number, drawDate, action);
                        Settings s = UIController.this.model.getSettings();
                        UIController.this.generalResponseCanvasUI = new GeneralResponseCanvasUI(UIController.this);
                        UIController.this.generalResponseCanvasUI.init(UIController.this.getDisplay(), UIController.this.getString(4), true, true, false, false, s, false, txt, (Displayable)UIController.this.betRecordsUI, 4);
                        UIController.this.setCurrent((Displayable)UIController.this.generalResponseCanvasUI);
                        break;
                    }
                    case 20: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Date serverTime = UIController.this.model.getServerTime();
                        if (UIController.this.totalStakeUI == null) {
                            UIController.this.totalStakeUI = new TotalStakeUI(UIController.this);
                        }
                        UIController.this.totalStakeUI.init(serverTime);
                        UIController.this.setCurrent((Displayable)UIController.this.totalStakeUI);
                        break;
                    }
                    case 21: {
                        UIController.this.setCurrent((Displayable)UIController.this.mainMenuUI);
                        break;
                    }
                    case 22: {
                        this.fallbackUI = UIController.this.totalStakeUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Date drawDate = (Date)eventObjects[0];
                        String txt = UIController.this.model.totalStake(drawDate);
                        Settings s = UIController.this.model.getSettings();
                        UIController.this.generalResponseCanvasUI = new GeneralResponseCanvasUI(UIController.this);
                        UIController.this.generalResponseCanvasUI.init(UIController.this.getDisplay(), UIController.this.getString(5), true, true, false, false, s, false, txt, (Displayable)UIController.this.totalStakeUI, 5);
                        UIController.this.setCurrent((Displayable)UIController.this.generalResponseCanvasUI);
                        break;
                    }
                    case 23: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Date serverTime = UIController.this.model.getServerTime();
                        if (UIController.this.resultsUI == null) {
                            UIController.this.resultsUI = new ResultsUI(UIController.this);
                        }
                        UIController.this.resultsUI.init(serverTime);
                        UIController.this.setCurrent((Displayable)UIController.this.resultsUI);
                        break;
                    }
                    case 24: {
                        UIController.this.setCurrent((Displayable)UIController.this.mainMenuUI);
                        break;
                    }
                    case 25: {
                        this.fallbackUI = UIController.this.resultsUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Date drawDate = (Date)eventObjects[0];
                        String drawType = (String)eventObjects[1];
                        String txt = UIController.this.model.results(drawDate, drawType);
                        Settings s = UIController.this.model.getSettings();
                        UIController.this.generalResponseCanvasUI = new GeneralResponseCanvasUI(UIController.this);
                        UIController.this.generalResponseCanvasUI.init(UIController.this.getDisplay(), UIController.this.getString(6), true, true, false, false, s, false, txt, (Displayable)UIController.this.resultsUI, 6);
                        UIController.this.setCurrent((Displayable)UIController.this.generalResponseCanvasUI);
                        break;
                    }
                    case 29: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Date serverTime = UIController.this.model.getServerTime();
                        if (UIController.this.fightNumWinningUI == null) {
                            UIController.this.fightNumWinningUI = new FightNumWinningUI(UIController.this);
                        }
                        UIController.this.fightNumWinningUI.init(serverTime);
                        UIController.this.setCurrent((Displayable)UIController.this.fightNumWinningUI);
                        break;
                    }
                    case 30: {
                        UIController.this.setCurrent((Displayable)UIController.this.mainMenuUI);
                        break;
                    }
                    case 31: {
                        this.fallbackUI = UIController.this.fightNumWinningUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Date winningDate = (Date)eventObjects[0];
                        String txt = UIController.this.model.fightNumWinning(winningDate);
                        Settings s = UIController.this.model.getSettings();
                        UIController.this.generalResponseCanvasUI = new GeneralResponseCanvasUI(UIController.this);
                        UIController.this.generalResponseCanvasUI.init(UIController.this.getDisplay(), UIController.this.getString(8), true, true, false, false, s, false, txt, (Displayable)UIController.this.winningUI, 8);
                        UIController.this.setCurrent((Displayable)UIController.this.generalResponseCanvasUI);
                        break;
                    }
                    case 26: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Date serverTime = UIController.this.model.getServerTime();
                        if (UIController.this.winningUI == null) {
                            UIController.this.winningUI = new WinningUI(UIController.this);
                        }
                        UIController.this.winningUI.init(serverTime);
                        UIController.this.setCurrent((Displayable)UIController.this.winningUI);
                        break;
                    }
                    case 27: {
                        UIController.this.setCurrent((Displayable)UIController.this.mainMenuUI);
                        break;
                    }
                    case 28: {
                        this.fallbackUI = UIController.this.winningUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Date winningDate = (Date)eventObjects[0];
                        String txt = UIController.this.model.winning(winningDate);
                        Settings s = UIController.this.model.getSettings();
                        UIController.this.generalResponseCanvasUI = new GeneralResponseCanvasUI(UIController.this);
                        UIController.this.generalResponseCanvasUI.init(UIController.this.getDisplay(), UIController.this.getString(7), true, true, false, false, s, false, txt, (Displayable)UIController.this.winningUI, 7);
                        UIController.this.setCurrent((Displayable)UIController.this.generalResponseCanvasUI);
                        break;
                    }
                    case 32: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        if (UIController.this.meaningUI == null) {
                            UIController.this.meaningUI = new MeaningUI(UIController.this);
                        }
                        UIController.this.meaningUI.init();
                        UIController.this.setCurrent((Displayable)UIController.this.meaningUI);
                        break;
                    }
                    case 33: {
                        UIController.this.setCurrent((Displayable)UIController.this.mainMenuUI);
                        break;
                    }
                    case 34: {
                        this.fallbackUI = UIController.this.meaningUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        String type = (String)eventObjects[0];
                        String field = (String)eventObjects[1];
                        String meaningTxt = UIController.this.model.meaning(type, field);
                        Settings s = UIController.this.model.getSettings();
                        UIController.this.generalResponseCanvasUI = new GeneralResponseCanvasUI(UIController.this);
                        UIController.this.generalResponseCanvasUI.init(UIController.this.getDisplay(), UIController.this.getString(9), true, true, false, false, s, false, meaningTxt, (Displayable)UIController.this.meaningUI, 9);
                        UIController.this.setCurrent((Displayable)UIController.this.generalResponseCanvasUI);
                        break;
                    }
                    case 35: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        String txt = UIController.this.model.announcement();
                        Settings s = UIController.this.model.getSettings();
                        UIController.this.generalResponseFormUI = new GeneralResponseFormUI(UIController.this, s);
                        UIController.this.generalResponseFormUI.init(UIController.this.getString(10), false, false, txt, (Displayable)UIController.this.mainMenuUI);
                        UIController.this.setCurrent((Displayable)UIController.this.generalResponseFormUI);
                        break;
                    }
                    case 36: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        String txt = UIController.this.model.accountStat();
                        Settings s = UIController.this.model.getSettings();
                        UIController.this.generalResponseCanvasUI = new GeneralResponseCanvasUI(UIController.this);
                        UIController.this.generalResponseCanvasUI.init(UIController.this.getDisplay(), UIController.this.getString(11), true, true, false, false, s, false, txt, (Displayable)UIController.this.mainMenuUI, 11);
                        UIController.this.setCurrent((Displayable)UIController.this.generalResponseCanvasUI);
                        break;
                    }
                    case 56: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        if (UIController.this.outstandingTicketUI == null) {
                            UIController.this.outstandingTicketUI = new OutstandingTicketUI(UIController.this);
                        }
                        UIController.this.outstandingTicketUI.init();
                        UIController.this.setCurrent((Displayable)UIController.this.outstandingTicketUI);
                        break;
                    }
                    case 57: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Date date = (Date)eventObjects[0];
                        String txt = UIController.this.model.outstandingTicket(date);
                        Settings s = UIController.this.model.getSettings();
                        UIController.this.generalResponseCanvasUI = new GeneralResponseCanvasUI(UIController.this);
                        UIController.this.generalResponseCanvasUI.init(UIController.this.getDisplay(), UIController.this.getString(12), true, true, false, false, s, false, txt, (Displayable)UIController.this.mainMenuUI, 12);
                        UIController.this.setCurrent((Displayable)UIController.this.generalResponseCanvasUI);
                        break;
                    }
                    case 58: {
                        UIController.this.setCurrent((Displayable)UIController.this.mainMenuUI);
                        break;
                    }
                    case 75: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        if (UIController.this.longtimeTicketUI == null) {
                            UIController.this.longtimeTicketUI = new LTTicketListUI(UIController.this);
                        }
                        UIController.this.setCurrent((Displayable)UIController.this.longtimeTicketUI);
                        UIController.this.longtimeTicketUI.init();
                        break;
                    }
                    case 76: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        UIController.this.respLTTicket = UIController.this.model.getLongTimeTicket("1");
                        UIController.this.longtimeTicketUI.updateItems(UIController.this.respLTTicket);
                        UIController.this.setCurrent((Displayable)UIController.this.longtimeTicketUI);
                        break;
                    }
                    case 77: {
                        String delID = (String)eventObjects[0];
                        String delIndex = (String)eventObjects[1];
                        this.fallbackUI = UIController.this.longtimeTicketUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        boolean success = UIController.this.model.delLongTimeTicket("2", delID, delIndex);
                        if (success) {
                            UIController.this.showInfoAlert(UIController.this.getString(140), (Displayable)UIController.this.longtimeTicketUI);
                            UIController.this.longtimeTicketUI.delTicketResp(success, delIndex);
                            break;
                        }
                        UIController.this.showInfoAlert(UIController.this.getString(141), (Displayable)UIController.this.longtimeTicketUI);
                        break;
                    }
                    case 78: {
                        UIController.this.setCurrent((Displayable)UIController.this.mainMenuUI);
                        break;
                    }
                    case 55: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        String txt = UIController.this.model.betManual();
                        Settings s = UIController.this.model.getSettings();
                        UIController.this.generalResponseCanvasUI = new GeneralResponseCanvasUI(UIController.this);
                        UIController.this.generalResponseCanvasUI.init(UIController.this.getDisplay(), UIController.this.getString(13), false, false, false, false, s, false, txt, (Displayable)UIController.this.mainMenuUI, 13);
                        UIController.this.setCurrent((Displayable)UIController.this.generalResponseCanvasUI);
                        break;
                    }
                    case 37: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        if (UIController.this.changePasswordUI == null) {
                            UIController.this.changePasswordUI = new ChangePasswordUI(UIController.this);
                        }
                        UIController.this.changePasswordUI.init();
                        UIController.this.setCurrent((Displayable)UIController.this.changePasswordUI);
                        break;
                    }
                    case 38: {
                        UIController.this.setCurrent((Displayable)UIController.this.mainMenuUI);
                        break;
                    }
                    case 39: {
                        this.fallbackUI = UIController.this.changePasswordUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        String oldPassword = (String)eventObjects[0];
                        String newPassword = (String)eventObjects[1];
                        boolean success = UIController.this.model.changePassword(oldPassword, newPassword);
                        String msg = null;
                        msg = success ? UIController.this.getString(67) : UIController.this.getString(68);
                        UIController.this.showInfoAlert(msg, (Displayable)UIController.this.mainMenuUI);
                        break;
                    }
                    case 45: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        UIController.this.setupPrinterUI = new SetupPrinterUI(UIController.this);
                        UIController.this.setupPrinterUI.startClient(UIController.this.progressObserverUI);
                        UIController.this.setCurrent((Displayable)UIController.this.setupPrinterUI);
                        break;
                    }
                    case 46: {
                        UIController.this.setCurrent((Displayable)UIController.this.mainMenuUI);
                        break;
                    }
                    case 47: {
                        this.fallbackUI = UIController.this.setupPrinterUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        PrintDevice device = (PrintDevice)eventObjects[0];
                        UIController.this.model.setPrintDevice(device);
                        UIController.this.showInfoAlert(UIController.this.getString(117), (Displayable)UIController.this.mainMenuUI);
                        break;
                    }
                    case 48: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        boolean newVersionAvailable = UIController.this.model.checkNewVersion();
                        if (UIController.this.autoUpdateStatusUI == null) {
                            UIController.this.autoUpdateStatusUI = new AutoUpdateStatusUI(UIController.this);
                        }
                        UIController.this.autoUpdateStatusUI.init(newVersionAvailable);
                        UIController.this.setCurrent((Displayable)UIController.this.autoUpdateStatusUI);
                        break;
                    }
                    case 54: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        String downloadAppURL = UIController.this.model.getUpdateURL();
                        try {
                            UIController.this.getMidlet().platformRequest(downloadAppURL);
                            UIController.this.exitRequested();
                        }
                        catch (ConnectionNotFoundException e) {
                            System.err.println("Error when launching browser. Error : " + e.getMessage());
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 49: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Settings settings = UIController.this.model.getSettings();
                        UIController.this.serverSettings = UIController.this.model.getServerSettings();
                        if (UIController.this.settingsUI == null) {
                            UIController.this.settingsUI = new SettingsUI(UIController.this);
                        }
                        UIController.this.settingsUI.init(settings, UIController.this.serverSettings, UIController.this.model.getBuyMethod());
                        UIController.this.setCurrent((Displayable)UIController.this.settingsUI);
                        break;
                    }
                    case 50: {
                        this.fallbackUI = UIController.this.settingsUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Settings currSettings = UIController.this.model.getSettings();
                        String currBuyMethod = UIController.this.model.getBuyMethod();
                        Settings newSettings = (Settings)eventObjects[0];
                        ServerSettings newServerSettings = (ServerSettings)eventObjects[1];
                        String newBuyMethod = (String)eventObjects[2];
                        UIController.this.model.setSettings(newSettings);
                        if (!(UIController.this.serverSettings.getCurrentBetType().equals(newServerSettings.getCurrentBetType()) && UIController.this.serverSettings.getCurrentInputMethodValue().equals(newServerSettings.getCurrentInputMethodValue()) && currBuyMethod.equals(newBuyMethod))) {
                            UIController.this.model.setServerSettings(newServerSettings.getCurrentBetType(), newServerSettings.getCurrentInputMethodValue(), newBuyMethod);
                            if (!currBuyMethod.equals(newBuyMethod)) {
                                UIController.this.model.setBuyMethod(newBuyMethod);
                            }
                        }
                        if (currSettings.getStandbyTimeout() != newSettings.getStandbyTimeout()) {
                            if (StandbyMonitor.getInstance() != null) {
                                StandbyMonitor.getInstance().stop();
                            }
                            if (newSettings.getStandbyTimeout() > 0) {
                                StandbyMonitor.init(UIController.this, newSettings.getStandbyTimeout());
                            }
                        }
                        UIController.this.showInfoAlert(UIController.this.getString(115), (Displayable)UIController.this.mainMenuUI);
                        break;
                    }
                    case 3: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Displayable displayable = (Displayable)eventObjects[0];
                        String transactionText = (String)eventObjects[1];
                        String mobilNo = (String)eventObjects[2];
                        if (UIController.this.smsSetupUI == null) {
                            UIController.this.smsSetupUI = new SMSSetupUI(UIController.this);
                        }
                        UIController.this.smsSetupUI.init(displayable, transactionText, mobilNo);
                        UIController.this.setCurrent((Displayable)UIController.this.smsSetupUI);
                        break;
                    }
                    case 4: {
                        Displayable backUI = (Displayable)eventObjects[0];
                        UIController.this.setCurrent(backUI);
                        break;
                    }
                    case 5: {
                        UIController.this.setCurrent((Displayable)UIController.this.smsSetupUI);
                        UIController.this.displayProgress(UIController.this.getString(19), false);
                        Displayable backUI = (Displayable)eventObjects[0];
                        String mobileNo = (String)eventObjects[1];
                        String transactionText = (String)eventObjects[2];
                        try {
                            MessageSender.send(mobileNo, transactionText.getBytes("UTF-8"));
                            UIController.this.showInfoAlert(UIController.this.getString(121), backUI);
                        }
                        catch (Throwable e) {
                            UIController.this.showErrorAlert(e.getMessage(), backUI);
                        }
                        break;
                    }
                    case 6: {
                        this.fallbackUI = UIController.this.mainMenuUI;
                        UIController.this.displayProgress(UIController.this.getString(19), true);
                        Settings settings = UIController.this.model.getSettings();
                        Displayable backUI = (Displayable)eventObjects[0];
                        String printData = (String)eventObjects[1];
                        int titleCode = Integer.valueOf((String)eventObjects[2]);
                        PrintDevice pd = UIController.this.model.getPrintDevice();
                        if (pd == null) {
                            UIController.this.showInfoAlert(UIController.this.getString(116), backUI);
                            return;
                        }
                        BTPrintClient b = new BTPrintClient(UIController.this, backUI, pd, settings);
                        b.doPrint(printData, false, titleCode);
                        break;
                    }
                    case 7: {
                        Displayable backUI = (Displayable)eventObjects[0];
                        UIController.this.setCurrent(backUI);
                        break;
                    }
                    case 59: {
                        Displayable backUI = (Displayable)eventObjects[0];
                        String printData = (String)eventObjects[1];
                        int titleCode = Integer.valueOf((String)eventObjects[2]);
                        Settings settings = UIController.this.model.getSettings();
                        PrintDevice pd = UIController.this.model.getPrintDevice();
                        if (pd == null) {
                            UIController.this.showInfoAlert(UIController.this.getString(116), this.fallbackUI);
                            return;
                        }
                        BTPrintClient b = new BTPrintClient(UIController.this, backUI, pd, settings);
                        b.doPrint(printData, true, titleCode);
                        break;
                    }
                    case 40: {
                        UIController.this.exitRequested();
                        break;
                    }
                    case 41: {
                        UIController.this.setCurrent((Displayable)UIController.this.mainMenuUI);
                        UIController.this.displayProgress(UIController.this.getString(19), false);
                        if (UIController.this.changeStandbyPasswordUI == null) {
                            UIController.this.changeStandbyPasswordUI = new ChangeStandbyPasswordUI(UIController.this);
                        }
                        UIController.this.changeStandbyPasswordUI.init();
                        UIController.this.setCurrent((Displayable)UIController.this.changeStandbyPasswordUI);
                        break;
                    }
                    case 42: {
                        UIController.this.setCurrent((Displayable)UIController.this.mainMenuUI);
                        break;
                    }
                    case 43: {
                        UIController.this.setCurrent((Displayable)UIController.this.changeStandbyPasswordUI);
                        UIController.this.displayProgress(UIController.this.getString(19), false);
                        String newPassword = (String)eventObjects[0];
                        UIController.this.model.setStandbyPassword(newPassword);
                        UIController.this.showErrorAlert(UIController.this.getString(67), (Displayable)UIController.this.mainMenuUI);
                        break;
                    }
                }
            }
            catch (ApplicationException ae) {
                ae.printStackTrace();
                if (ae.getCode() == 1000) {
                    UIController.this.display.setCurrent(this.fallbackUI);
                } else {
                    System.err.println("ae.getCode() == " + ae.getCode());
                    UIController.this.showErrorAlert(ae.getMessage(), this.fallbackUI);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                UIController.this.showErrorAlert(e.getMessage(), this.fallbackUI);
            }
        }
    }
}

