/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.ui;

import com.cloudy.client.midp.model.ServerSettings;
import com.cloudy.client.midp.model.Settings;
import com.cloudy.client.midp.ui.UIController;
import com.cloudy.client.midp.util.StandbyMonitor;
import java.util.Vector;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.TextField;

public class SettingsUI
extends Form
implements CommandListener,
ItemStateListener {
    private static final String BUY_METHOD_DIVIDE = "/";
    private static final String BUY_METHOD_TIMES = "X";
    private UIController uiController;
    private TextField standbyTimeoutTF;
    private TextField betRowsTF;
    private ChoiceGroup betTypeCG;
    private ChoiceGroup inputMethodCG;
    private ChoiceGroup buyMethodCG;
    private ChoiceGroup scrollTypeCG;
    private ChoiceGroup directPrintCG;
    private ChoiceGroup displayFontSizeCG;
    private ChoiceGroup printFontSizeCG;
    private Command saveCommand;
    private Command backCommand;
    private Settings settings;
    private ServerSettings serverSettings;

    public SettingsUI(UIController uiController) {
        super(uiController.getString(96));
        this.uiController = uiController;
        this.standbyTimeoutTF = new TextField(uiController.getString(97), null, 12, 2);
        this.betRowsTF = new TextField(uiController.getString(16), null, 12, 2);
        this.betTypeCG = new ChoiceGroup(uiController.getString(98), 1);
        this.inputMethodCG = new ChoiceGroup(uiController.getString(99), 1);
        this.buyMethodCG = new ChoiceGroup(uiController.getString(100), 1);
        this.buyMethodCG.append(uiController.getString(101), null);
        this.buyMethodCG.append(uiController.getString(102), null);
        this.scrollTypeCG = new ChoiceGroup(uiController.getString(103), 1);
        this.scrollTypeCG.append(uiController.getString(104), null);
        this.scrollTypeCG.append(uiController.getString(105), null);
        this.directPrintCG = new ChoiceGroup(uiController.getString(106), 1);
        this.directPrintCG.append(uiController.getString(35), null);
        this.directPrintCG.append(uiController.getString(36), null);
        this.displayFontSizeCG = new ChoiceGroup(uiController.getString(107), 1);
        this.displayFontSizeCG.append(uiController.getString(109), null);
        this.displayFontSizeCG.append(uiController.getString(110), null);
        this.displayFontSizeCG.append(uiController.getString(111), null);
        this.printFontSizeCG = new ChoiceGroup(uiController.getString(108), 1);
        this.printFontSizeCG.append(uiController.getString(109), null);
        this.printFontSizeCG.append(uiController.getString(110), null);
        this.printFontSizeCG.append(uiController.getString(111), null);
        this.saveCommand = new Command(uiController.getString(33), 1, 5);
        this.backCommand = new Command(uiController.getString(26), 2, 10);
        this.append((Item)this.standbyTimeoutTF);
        this.append((Item)this.betRowsTF);
        this.append((Item)this.betTypeCG);
        this.append((Item)this.inputMethodCG);
        this.append((Item)this.buyMethodCG);
        this.append((Item)this.scrollTypeCG);
        this.append((Item)this.directPrintCG);
        this.append((Item)this.displayFontSizeCG);
        this.append((Item)this.printFontSizeCG);
        this.addCommand(this.saveCommand);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
        this.setItemStateListener(this);
    }

    public void init(Settings settings, ServerSettings serverSettings, String buyMethod) {
        this.settings = settings;
        this.serverSettings = serverSettings;
        if (settings != null) {
            this.standbyTimeoutTF.setString(Integer.toString(settings.getStandbyTimeout()));
            this.betRowsTF.setString(Integer.toString(settings.getBetRows()));
            if (settings.getBetType() == "BSAC4A") {
                this.betTypeCG.setSelectedIndex(0, true);
            } else if (settings.getBetType() == "BSCA4A") {
                this.betTypeCG.setSelectedIndex(1, true);
            } else if (settings.getBetType() == "SBAC4A") {
                this.betTypeCG.setSelectedIndex(2, true);
            } else if (settings.getBetType() == "SBCA4A") {
                this.betTypeCG.setSelectedIndex(3, true);
            }
            if (settings.getScrollType() == 0) {
                this.scrollTypeCG.setSelectedIndex(0, true);
            } else if (settings.getScrollType() == 1) {
                this.scrollTypeCG.setSelectedIndex(1, true);
            }
            if (settings.isDirectPrint()) {
                this.directPrintCG.setSelectedIndex(0, true);
            } else {
                this.directPrintCG.setSelectedIndex(1, true);
            }
            if (settings.getDisplayfontSize() == 0) {
                this.displayFontSizeCG.setSelectedIndex(0, true);
            } else if (1 == settings.getDisplayfontSize()) {
                this.displayFontSizeCG.setSelectedIndex(1, true);
            }
            if (2 == settings.getDisplayfontSize()) {
                this.displayFontSizeCG.setSelectedIndex(2, true);
            }
            if (settings.getPrintfontSize() == 0) {
                this.printFontSizeCG.setSelectedIndex(0, true);
            } else if (1 == settings.getPrintfontSize()) {
                this.printFontSizeCG.setSelectedIndex(1, true);
            }
            if (2 == settings.getPrintfontSize()) {
                this.printFontSizeCG.setSelectedIndex(2, true);
            }
        }
        if (serverSettings != null) {
            String selectedName = serverSettings.getCurrentInputMethodValue();
            Vector inputMethods = serverSettings.getInputMethods();
            this.inputMethodCG.deleteAll();
            int i = 0;
            while (i < inputMethods.size()) {
                ServerSettings.InputMethod im = (ServerSettings.InputMethod)inputMethods.elementAt(i);
                this.inputMethodCG.append(im.getName(), null);
                if (im.getValue().equals(selectedName)) {
                    this.inputMethodCG.setSelectedIndex(i, true);
                }
                ++i;
            }
            this.betTypeCG.deleteAll();
            String selectedBetType = serverSettings.getCurrentBetType();
            Vector betTypeNames = serverSettings.getBetTypeNames();
            int i2 = 0;
            while (i2 < betTypeNames.size()) {
                String betType = (String)betTypeNames.elementAt(i2);
                this.betTypeCG.append(betType, null);
                if (betType.equals(selectedBetType)) {
                    this.betTypeCG.setSelectedIndex(i2, true);
                }
                ++i2;
            }
        }
        if (buyMethod != null) {
            if (BUY_METHOD_DIVIDE.equals(buyMethod)) {
                this.buyMethodCG.setSelectedIndex(0, true);
            } else if (BUY_METHOD_TIMES.equals(buyMethod)) {
                this.buyMethodCG.setSelectedIndex(1, true);
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        StandbyMonitor.reset();
        if (command == this.backCommand) {
            this.uiController.mainMenuRequested();
        } else if (command == this.saveCommand) {
            String errMsg = this.validateForm();
            if (errMsg != null) {
                this.uiController.showErrorAlert(errMsg, (Displayable)this);
                return;
            }
            Settings s = new Settings();
            s.setStandbyTimeout(Integer.parseInt(this.standbyTimeoutTF.getString()));
            s.setBetRows(Integer.parseInt(this.betRowsTF.getString()));
            s.setBetType(this.betTypeCG.getString(this.betTypeCG.getSelectedIndex()));
            s.setScrollType(this.scrollTypeCG.getSelectedIndex());
            s.setScrollType(this.scrollTypeCG.getSelectedIndex());
            if (this.directPrintCG.getSelectedIndex() == 0) {
                s.setDirectPrint(true);
            } else {
                s.setDirectPrint(false);
            }
            s.setDisplayfontSize(this.displayFontSizeCG.getSelectedIndex());
            s.setPrintfontSize(this.printFontSizeCG.getSelectedIndex());
            ServerSettings ss = new ServerSettings();
            ss.setCurrentBetType(this.betTypeCG.getString(this.betTypeCG.getSelectedIndex()));
            String selectdInputMethodName = this.inputMethodCG.getString(this.inputMethodCG.getSelectedIndex());
            String selectdInputMethodValue = null;
            Vector inputMethods = this.serverSettings.getInputMethods();
            int i = 0;
            while (i < inputMethods.size()) {
                ServerSettings.InputMethod im = (ServerSettings.InputMethod)inputMethods.elementAt(i);
                if (im.getName().equals(selectdInputMethodName)) {
                    selectdInputMethodValue = im.getValue();
                }
                ++i;
            }
            s.setInputType(Integer.parseInt(selectdInputMethodValue));
            ss.setCurrentInputMethodValue(selectdInputMethodValue);
            String newbuyMethod = null;
            if (this.buyMethodCG.getSelectedIndex() == 0) {
                newbuyMethod = BUY_METHOD_DIVIDE;
            } else if (this.buyMethodCG.getSelectedIndex() == 1) {
                newbuyMethod = BUY_METHOD_TIMES;
            }
            this.uiController.handleEvent(50, new Object[]{s, ss, newbuyMethod});
        }
    }

    private String validateForm() {
        String st = this.standbyTimeoutTF.getString();
        if (st == null || st.trim().length() == 0) {
            return this.uiController.getString(112);
        }
        String br = this.betRowsTF.getString();
        if (br == null || br.trim().length() == 0) {
            return this.uiController.getString(113);
        }
        if (3 > Integer.parseInt(br) || 80 < Integer.parseInt(br)) {
            return this.uiController.getString(114);
        }
        return null;
    }

    public void itemStateChanged(Item item) {
        StandbyMonitor.reset();
    }
}

