/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.ui;

import com.cloudy.client.midp.ApplicationException;
import com.cloudy.client.midp.ui.UIController;
import com.cloudy.client.midp.util.StandbyMonitor;
import com.cloudy.client.midp.util.StringFormatUtil;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import net.mypapit.java.StringTokenizer1;

public class ReprintListUI
extends List
implements CommandListener {
    public static final String ACTION_CODE_LAST_PAGE_NO = "4";
    public static final int PAGE_SIZE = 10;
    private UIController uiController;
    private Command prevPageCommand;
    private Command nextPageCommand;
    private Command backCommand;
    private Vector transactions;
    private int myListSelectIndex = 0;
    private int myListSelectMax = 0;
    private int nextPageNumber = -1;
    private int prevPageNumber = -1;
    private String currentPageNumber = "1";
    private String totalPageNumber = "1";

    public ReprintListUI(UIController uiController) {
        super(uiController.getString(0), 3);
        this.uiController = uiController;
        this.setFitPolicy(1);
        this.prevPageCommand = new Command(uiController.getString(126), 1, 7);
        this.nextPageCommand = new Command(uiController.getString(127), 1, 6);
        this.backCommand = new Command(uiController.getString(26), 2, 10);
        this.addCommand(this.backCommand);
        this.myListSelectIndex = 0;
    }

    public void init(String txt) throws ApplicationException {
        int totalPageNo;
        int currPageNo;
        this.transactions = new Vector();
        StringTokenizer1 st = new StringTokenizer1(txt.trim(), "~~");
        while (st.hasMoreElements()) {
            this.transactions.addElement(st.nextElement());
        }
        if (this.transactions.size() == 0) {
            return;
        }
        String pageNo = (String)this.transactions.elementAt(0);
        int idx = pageNo.indexOf("/");
        if (idx == -1) {
            throw new ApplicationException("Invalid data received");
        }
        try {
            currPageNo = Integer.parseInt(pageNo.substring(0, idx).trim());
            totalPageNo = Integer.parseInt(pageNo.substring(idx + 1).trim());
        }
        catch (NumberFormatException nfe) {
            throw new ApplicationException("Invalid data received");
        }
        if (currPageNo < totalPageNo) {
            this.nextPageNumber = currPageNo + 1;
            this.addCommand(this.nextPageCommand);
        }
        if (currPageNo > 1) {
            this.prevPageNumber = currPageNo - 1;
            this.addCommand(this.prevPageCommand);
        }
        this.setCommandListener(this);
        this.transactions.removeElementAt(0);
        if (currPageNo <= 0) {
            currPageNo = 1;
        }
        int firstItemNum = (currPageNo - 1) * 10 + 1;
        this.deleteAll();
        int i = 0;
        while (i < this.transactions.size()) {
            this.append("(" + Integer.toString(firstItemNum++) + ") " + this.getTransactionDisplayString((String)this.transactions.elementAt(i)), null);
            ++i;
        }
        this.currentPageNumber = String.valueOf(this.myListSelectIndex + 1);
        this.totalPageNumber = String.valueOf(this.transactions.size());
        String.valueOf(totalPageNo);
        this.myListSelectMax = this.transactions.size() - 1;
        this.uiController.handleEvent(64, new Object[]{this.transactions.elementAt(this.myListSelectIndex), this.currentPageNumber, this.totalPageNumber, String.valueOf(this.prevPageNumber), String.valueOf(this.nextPageNumber)});
    }

    public void autoMoveUp() {
        this.myListSelectIndex = this.myListSelectIndex > 0 ? --this.myListSelectIndex : this.myListSelectMax;
        this.currentPageNumber = String.valueOf(this.myListSelectIndex + 1);
        this.uiController.handleEvent(64, new Object[]{this.transactions.elementAt(this.myListSelectIndex), this.currentPageNumber, this.totalPageNumber, String.valueOf(this.prevPageNumber), String.valueOf(this.nextPageNumber)});
    }

    public void autoMoveDown() {
        this.myListSelectIndex = this.myListSelectIndex < this.myListSelectMax ? ++this.myListSelectIndex : 0;
        this.currentPageNumber = String.valueOf(this.myListSelectIndex + 1);
        this.uiController.handleEvent(64, new Object[]{this.transactions.elementAt(this.myListSelectIndex), this.currentPageNumber, this.totalPageNumber, String.valueOf(this.prevPageNumber), String.valueOf(this.nextPageNumber)});
    }

    public void commandAction(Command command, Displayable displayable) {
        StandbyMonitor.reset();
        if (command == List.SELECT_COMMAND) {
            int selectedIdx = this.getSelectedIndex();
            this.uiController.handleEvent(64, new Object[]{this.transactions.elementAt(selectedIdx), this.currentPageNumber, this.totalPageNumber, String.valueOf(this.prevPageNumber), String.valueOf(this.nextPageNumber)});
        } else if (command == this.prevPageCommand) {
            this.uiController.handleEvent(65, new Object[]{Integer.toString(this.prevPageNumber)});
        } else if (command == this.nextPageCommand) {
            this.uiController.handleEvent(65, new Object[]{Integer.toString(this.nextPageNumber)});
        } else if (command == this.backCommand) {
            this.uiController.handleEvent(12);
        }
    }

    private String getTransactionDisplayString(String transaction) {
        StringBuffer displayStr = new StringBuffer();
        String row = null;
        int running = 1;
        StringTokenizer1 st = new StringTokenizer1(transaction.trim(), "\n");
        st.nextElement();
        while (st.hasMoreElements()) {
            row = (String)st.nextElement();
            if (running <= 3) {
                displayStr.append(row).append("\n");
            }
            ++running;
        }
        String str = StringFormatUtil.removeRedMarker(displayStr.toString());
        return str;
    }
}

