/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.ui;

import com.cloudy.client.midp.model.Settings;
import com.cloudy.client.midp.ui.ConfirmationCallback;
import com.cloudy.client.midp.ui.ConfirmationUI;
import com.cloudy.client.midp.ui.UIController;
import com.cloudy.client.midp.util.StandbyMonitor;
import com.cloudy.client.midp.util.StringFormatUtil;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class ReprintItemCanvas
extends Canvas
implements CommandListener {
    private static final String RED_MARKER = "|";
    private static final String PIPE = "|";
    private static int COLOR_RED = 0xFF0000;
    private static final int COLOR_FOREGROUND = 0;
    private static final int COLOR_BACKGROUND = 0xFFFFFF;
    private UIController uiController;
    private Settings settings;
    public Font INPUT_FONT = null;
    public int INPUT_FONT_HEIGHT = 0;
    public int MAX_DISPLAY_ROWS = 0;
    private int firstDisplayRow = 0;
    private int firstCharToDisplay = 0;
    private Command sendSMSCommand;
    private Command printCommand;
    private Command voidCommand;
    private Command buyCommand;
    private Command backCommand;
    private Command prevPageCommand;
    private Command nextPageCommand;
    private String transactionText;
    private String selectedPageNo;
    private String selectedDate;
    private Vector transactionTextVtr;
    private int nextPageNumber = -1;
    private int prevPageNumber = -1;
    private String mobileNo;
    private ConfirmationUI confirmationUI;

    public ReprintItemCanvas(UIController uiController) {
        this.setTitle(uiController.getString(2));
        this.uiController = uiController;
        this.setCommandListener(this);
        this.sendSMSCommand = new Command(uiController.getString(34), 1, 5);
        this.printCommand = new Command(uiController.getString(29), 1, 6);
        this.voidCommand = new Command(uiController.getString(73), 1, 7);
        this.buyCommand = new Command(uiController.getString(1), 1, 8);
        this.prevPageCommand = new Command(uiController.getString(126), 1, 9);
        this.nextPageCommand = new Command(uiController.getString(127), 1, 9);
        this.backCommand = new Command(uiController.getString(26), 2, 10);
        this.addCommand(this.sendSMSCommand);
        this.addCommand(this.printCommand);
        this.addCommand(this.voidCommand);
        this.addCommand(this.buyCommand);
        this.addCommand(this.backCommand);
        this.addCommand(this.prevPageCommand);
        this.addCommand(this.nextPageCommand);
        StandbyMonitor.reset();
    }

    /*
     * Unable to fully structure code
     */
    public void init(String transactionText, Settings settings, String curPgNum, String totPgNum, String prevPgNum, String nextPgNum) {
        Title = this.uiController.getString(2);
        spaceNum = 28 - Title.length() - curPgNum.length() - totPgNum.length() - 1;
        spaceBar = "";
        i = 0;
        while (i < spaceNum) {
            spaceBar = String.valueOf(spaceBar) + " ";
            ++i;
        }
        this.setTitle(String.valueOf(this.uiController.getString(2)) + spaceBar + curPgNum + "/" + totPgNum);
        this.prevPageNumber = Integer.parseInt(prevPgNum, 10);
        this.nextPageNumber = Integer.parseInt(nextPgNum, 10);
        this.transactionText = transactionText;
        this.settings = settings;
        this.transactionTextVtr = new Vector<E>();
        if (settings.getDisplayfontSize() == 0) {
            this.INPUT_FONT = Font.getFont((int)0, (int)1, (int)8);
        } else if (1 == settings.getDisplayfontSize()) {
            this.INPUT_FONT = Font.getFont((int)0, (int)1, (int)0);
        } else if (2 == settings.getDisplayfontSize()) {
            this.INPUT_FONT = Font.getFont((int)0, (int)1, (int)16);
        }
        this.INPUT_FONT_HEIGHT = this.INPUT_FONT.getHeight();
        this.MAX_DISPLAY_ROWS = this.getHeight() / this.INPUT_FONT_HEIGHT;
        this.firstDisplayRow = 0;
        this.firstCharToDisplay = 0;
        transactionTextTmp = new String(transactionText);
        s = null;
        isFirstRow = true;
        firstRow = null;
        idx = -1;
        if (transactionTextTmp.indexOf("\n") != -1) ** GOTO lbl41
        throw new RuntimeException();
lbl-1000:
        // 1 sources

        {
            if (isFirstRow) {
                firstRow = transactionTextTmp.substring(0, idx);
                isFirstRow = false;
            } else {
                s = transactionTextTmp.substring(0, idx);
                this.transactionTextVtr.addElement(s);
            }
            transactionTextTmp = transactionTextTmp.substring(idx + 1);
lbl41:
            // 2 sources

            ** while ((idx = transactionTextTmp.indexOf((String)"\n")) != -1)
        }
lbl42:
        // 1 sources

        this.transactionTextVtr.addElement(transactionTextTmp);
        pipeIdx = firstRow.indexOf("|");
        if (pipeIdx == -1) {
            throw new RuntimeException();
        }
        this.selectedDate = firstRow.substring(0, pipeIdx);
        this.selectedPageNo = firstRow.substring(pipeIdx + 1);
        this.repaint();
        StandbyMonitor.reset();
        this.getMobileNo(StringFormatUtil.removeRedMarker(this.transactionText));
    }

    public void commandAction(Command command, Displayable displayable) {
        StandbyMonitor.reset();
        if (command == this.sendSMSCommand) {
            this.uiController.handleEvent(3, new Object[]{this, StringFormatUtil.removeRedMarker(this.transactionText), this.mobileNo});
        } else if (command == this.printCommand) {
            this.uiController.handleEvent(6, new Object[]{this, String.valueOf(StringFormatUtil.removeRedMarker(this.transactionText)) + "\n", String.valueOf(0)});
        } else if (command == this.voidCommand) {
            if (this.confirmationUI == null) {
                this.confirmationUI = new ConfirmationUI(this.uiController, this.uiController.getString(120), new ConfirmationCallback(){

                    public void confirmNo() {
                        ReprintItemCanvas.this.uiController.setCurrent((Displayable)ReprintItemCanvas.this);
                    }

                    public void confirmYes() {
                        ReprintItemCanvas.this.uiController.handleEvent(68, new Object[]{ReprintItemCanvas.this.selectedDate, ReprintItemCanvas.this.selectedPageNo});
                    }
                });
            }
            this.uiController.setCurrent((Displayable)this.confirmationUI);
        } else if (command == this.buyCommand) {
            this.uiController.handleEvent(69, new Object[]{this.selectedDate, this.selectedPageNo});
        } else if (command == this.backCommand) {
            this.uiController.handleEvent(70);
        } else if (command == this.prevPageCommand) {
            this.uiController.handleEvent(65, new Object[]{Integer.toString(this.prevPageNumber)});
        } else if (command == this.nextPageCommand) {
            this.uiController.handleEvent(65, new Object[]{Integer.toString(this.nextPageNumber)});
        }
    }

    protected void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(0);
        this.drawText(g);
    }

    private boolean getMobileNo(String tText) {
        boolean isNo = false;
        this.mobileNo = null;
        String str1 = "";
        if (tText.indexOf("HP:") > 0) {
            str1 = tText.substring(tText.indexOf("HP:") + 3, tText.indexOf("HP:") + 13);
            if ((str1 = str1.trim()).length() > 0 && (str1.length() == 10 || str1.length() == 11)) {
                this.mobileNo = str1;
            }
            isNo = true;
        }
        return isNo;
    }

    private void drawText(Graphics g) {
        int currHeight = 0;
        int start = this.firstDisplayRow;
        int end = this.firstDisplayRow + this.MAX_DISPLAY_ROWS - 1 < this.transactionTextVtr.size() ? this.firstDisplayRow + this.MAX_DISPLAY_ROWS : this.transactionTextVtr.size();
        g.setFont(this.INPUT_FONT);
        String[] txtArr = new String[10];
        boolean txtArrIndex = false;
        g.setColor(0);
        int i = start;
        while (i < end) {
            String txt = (String)this.transactionTextVtr.elementAt(i);
            int txtlen = txt.length();
            int lenCp = 13;
            int lenClip = lenCp + 1;
            String redMark = "";
            if (txt.indexOf("|") != -1) {
                redMark = "|";
                ++lenCp;
            }
            if (txt.length() > lenCp) {
                int j;
                int txtEnd;
                int arrayNtx;
                int txtBegin = 0;
                if (redMark == "") {
                    arrayNtx = txtlen / lenClip + 1;
                    txtEnd = lenCp + 1;
                    j = 0;
                    while (j < arrayNtx) {
                        txtArr[j] = txt.substring(txtBegin, txtEnd);
                        this.write(g, currHeight, txtArr[j]);
                        currHeight += this.INPUT_FONT_HEIGHT;
                        txtBegin = txtEnd;
                        txtEnd = txtBegin + lenClip;
                        if (txtEnd > txtlen) {
                            txtEnd = txtlen;
                        }
                        ++j;
                    }
                } else {
                    arrayNtx = (txtlen - 1) / lenClip + 1;
                    txtEnd = lenClip + 1;
                    j = 0;
                    while (j < arrayNtx) {
                        txtArr[j] = j == 0 ? txt.substring(txtBegin, txtEnd) : String.valueOf(redMark) + txt.substring(txtBegin, txtEnd);
                        this.write(g, currHeight, txtArr[j]);
                        currHeight += this.INPUT_FONT_HEIGHT;
                        txtBegin = txtEnd;
                        txtEnd = txtBegin + lenClip;
                        if (txtEnd > txtlen) {
                            txtEnd = txtlen;
                        }
                        ++j;
                    }
                }
            } else {
                this.write(g, currHeight, txt);
                currHeight += this.INPUT_FONT_HEIGHT;
            }
            ++i;
        }
    }

    private void write(Graphics g, int y, String s) {
        int prevMark = -1;
        int currMark = 0;
        if (s == null) {
            return;
        }
        if (s.indexOf("|") == -1) {
            if (this.firstCharToDisplay < s.length()) {
                g.drawString(s.substring(this.firstCharToDisplay), 1, y, 20);
            } else {
                g.drawString("", 1, y, 20);
            }
            return;
        }
        Vector<String> v = new Vector<String>();
        while ((currMark = s.indexOf("|", prevMark == -1 ? 0 : prevMark + 1)) != -1) {
            v.addElement(s.substring(prevMark == -1 ? 0 : prevMark + 1, currMark));
            prevMark = currMark;
        }
        v.addElement(s.substring(prevMark + 1));
        int currX = 1;
        String vs = null;
        int cumulativeLength = 0;
        boolean first = false;
        int i = 0;
        while (i < v.size()) {
            block9: {
                String ss;
                block11: {
                    block10: {
                        vs = (String)v.elementAt(i);
                        if (vs == null || vs.trim().length() == 0) break block9;
                        if (i % 2 == 0) {
                            g.setColor(0);
                        } else {
                            g.setColor(COLOR_RED);
                        }
                        ss = new String(vs);
                        if (cumulativeLength + vs.length() > this.firstCharToDisplay) break block10;
                        if (first) break block11;
                        cumulativeLength += ss.length();
                        break block9;
                    }
                    if (cumulativeLength + vs.length() > this.firstCharToDisplay && !first) {
                        ss = ss.substring(this.firstCharToDisplay - cumulativeLength);
                        first = true;
                    }
                }
                g.drawString(ss, currX, y, 20);
                currX += this.INPUT_FONT.stringWidth(ss);
                cumulativeLength += ss.length();
            }
            ++i;
        }
        g.setColor(0);
    }

    protected void keyPressed(int keyCode) {
        StandbyMonitor.reset();
        int gameKeyCode = this.getGameAction(keyCode);
        if (gameKeyCode == 1) {
            this.cursorMoveUp();
        } else if (gameKeyCode == 6) {
            this.cursorMoveDown();
        } else if (gameKeyCode == 2) {
            this.pageMovePrev();
        } else if (gameKeyCode == 5) {
            this.pagerMoveNext();
        }
        this.repaint();
    }

    private void cursorMoveUp() {
        if (this.settings.getScrollType() == 0) {
            if (this.firstDisplayRow > 0) {
                --this.firstDisplayRow;
            }
        } else if (1 == this.settings.getScrollType() && this.firstDisplayRow > 0 && this.firstDisplayRow >= this.MAX_DISPLAY_ROWS) {
            this.firstDisplayRow -= this.MAX_DISPLAY_ROWS;
        }
    }

    private void cursorMoveDown() {
        if (this.settings.getScrollType() == 0) {
            if (this.firstDisplayRow + this.MAX_DISPLAY_ROWS <= this.transactionTextVtr.size()) {
                ++this.firstDisplayRow;
            }
        } else if (1 == this.settings.getScrollType() && this.firstDisplayRow + this.MAX_DISPLAY_ROWS <= this.transactionTextVtr.size()) {
            this.firstDisplayRow += this.MAX_DISPLAY_ROWS;
        }
    }

    private void cursorMoveLeft() {
        if (this.firstCharToDisplay > 0) {
            --this.firstCharToDisplay;
        }
    }

    private void cursorMoveRight() {
        ++this.firstCharToDisplay;
    }

    private void pageMovePrev() {
        this.uiController.handleEvent(79);
    }

    private void pagerMoveNext() {
        this.uiController.handleEvent(80);
    }
}

