/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.ui;

import com.cloudy.client.midp.model.Settings;
import com.cloudy.client.midp.ui.UIController;
import com.cloudy.client.midp.util.StandbyMonitor;
import com.cloudy.client.midp.util.StringFormatUtil;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;

public class GeneralResponseFormUI
extends Form
implements CommandListener {
    private UIController uiController;
    private Settings settings;
    private Command sendSMSCommand;
    private Command printCommand;
    private Command backCommand;
    private String transactionText;
    private Displayable backUI;
    private Vector event;
    private String mobileNo;

    public GeneralResponseFormUI(UIController uiController, Settings settings) {
        super(null);
        this.uiController = uiController;
        this.settings = settings;
        this.setCommandListener(this);
    }

    public void init(String title, boolean allowSendSMS, boolean allowPrint, String transactionText, Vector event) {
        this.transactionText = transactionText;
        this.event = event;
        if (title != null) {
            this.setTitle(title);
        }
        StringItem txt = new StringItem(null, transactionText);
        Font f = null;
        if (this.settings.getDisplayfontSize() == 0) {
            f = Font.getFont((int)0, (int)0, (int)8);
        } else if (1 == this.settings.getDisplayfontSize()) {
            f = Font.getFont((int)0, (int)0, (int)0);
        } else if (2 == this.settings.getDisplayfontSize()) {
            f = Font.getFont((int)0, (int)0, (int)16);
        }
        txt.setFont(f);
        this.append((Item)txt);
        if (allowSendSMS && this.sendSMSCommand == null) {
            this.sendSMSCommand = new Command(this.uiController.getString(34), 1, 5);
            this.addCommand(this.sendSMSCommand);
        }
        if (allowPrint && this.printCommand == null) {
            this.printCommand = new Command(this.uiController.getString(29), 1, 7);
            this.addCommand(this.printCommand);
        }
        if (this.backCommand == null) {
            this.backCommand = new Command(this.uiController.getString(26), 2, 5);
            this.addCommand(this.backCommand);
        }
        this.getMobileNo(StringFormatUtil.removeRedMarker(this.transactionText));
    }

    public void init(String title, boolean allowSendSMS, boolean allowPrint, String transactionText, Displayable backUI) {
        this.transactionText = transactionText;
        this.backUI = backUI;
        if (title != null) {
            this.setTitle(title);
        }
        StringItem txt = new StringItem(null, transactionText);
        Font f = null;
        if (this.settings.getDisplayfontSize() == 0) {
            f = Font.getFont((int)0, (int)0, (int)8);
        } else if (1 == this.settings.getDisplayfontSize()) {
            f = Font.getFont((int)0, (int)0, (int)0);
        } else if (2 == this.settings.getDisplayfontSize()) {
            f = Font.getFont((int)0, (int)0, (int)16);
        }
        txt.setFont(f);
        this.append((Item)txt);
        if (allowSendSMS && this.sendSMSCommand == null) {
            this.sendSMSCommand = new Command(this.uiController.getString(34), 1, 5);
            this.addCommand(this.sendSMSCommand);
        }
        if (allowPrint && this.printCommand == null) {
            this.printCommand = new Command(this.uiController.getString(29), 1, 7);
            this.addCommand(this.printCommand);
        }
        if (this.backCommand == null) {
            this.backCommand = new Command(this.uiController.getString(26), 2, 5);
            this.addCommand(this.backCommand);
        }
        this.getMobileNo(StringFormatUtil.removeRedMarker(this.transactionText));
    }

    private boolean getMobileNo(String tText) {
        boolean isNo = false;
        this.mobileNo = null;
        String str1 = "";
        if (tText.indexOf("HP:") > 0) {
            str1 = tText.substring(tText.indexOf("HP:") + 3, tText.indexOf("HP:") + 13);
            if ((str1 = str1.trim()).length() > 0 && (str1.length() == 10 || str1.length() == 11)) {
                this.mobileNo = str1;
            }
            isNo = true;
        }
        return isNo;
    }

    public void commandAction(Command command, Displayable displayable) {
        StandbyMonitor.reset();
        if (command == this.sendSMSCommand) {
            this.uiController.handleEvent(3, new Object[]{this, this.transactionText, this.mobileNo});
        } else if (command == this.printCommand) {
            this.uiController.handleEvent(6, new Object[]{this, this.transactionText, String.valueOf(0)});
        } else if (command == this.backCommand) {
            if (this.backUI != null) {
                this.uiController.setCurrent(this.backUI);
            } else if (this.event != null) {
                int eventId = (Integer)this.event.elementAt(0);
                this.event.removeElementAt(0);
                Object[] array = new Object[10];
                this.event.copyInto(array);
                this.uiController.handleEvent(eventId, array);
            } else {
                this.uiController.mainMenuRequested();
            }
        }
    }
}

