/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.ui;

import com.cloudy.client.midp.ui.ConfirmationUI;
import com.cloudy.client.midp.ui.UIController;
import com.cloudy.client.midp.util.StandbyMonitor;
import java.util.Date;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class BuyInputCanvas
extends Canvas
implements CommandListener {
    private static final String SYMBOL_ASTERISK = "*";
    private static final String SYMBOL_DOUBLE_ASTERISK = "**";
    private static final String SYMBOL_HASH_ASTERISK_HASH = "#*#";
    private static final String SYMBOL_PLUS = "+";
    private static final String SYMBOL_HASH = "#";
    private static final String SYMBOL_PIPE = "|";
    private static final String DATE_PREFIX = "D#";
    private static final int COLOR_FOREGROUND = 0;
    private static final int COLOR_BACKGROUND = 0xFFFFFF;
    private static final int MAX_PURCHASE_DAYS = 6;
    private final int KEY_CLEAR;
    public static Font INPUT_FONT = Font.getFont((int)0, (int)1, (int)16);
    public static int INPUT_FONT_HEIGHT = INPUT_FONT.getHeight();
    public static int INPUT_FONT_WIDTH = INPUT_FONT.stringWidth("#");
    public static int LINE_SEPARATOR_HEIGHT = 1;
    public int MAX_DISPLAY_COLS = this.getWidth() / INPUT_FONT_WIDTH;
    public int MAX_DISPLAY_ROWS = this.getHeight() / (INPUT_FONT_HEIGHT + 1);
    private UIController uiController;
    private Display display;
    private ConfirmationUI confirmationUI;
    private Command agentCommand;
    private Command currencyCodeCommand;
    private Command addPhoneCommand;
    private Command submitCommand;
    private Command clearCommand;
    private Command backMenuCommand;
    private int errorLineNumber = -1;
    private int maxRow;
    private String buyMethod;
    private Vector text;
    private boolean special;
    private StringBuffer invalidRowBuf = null;
    private int cursorRow = 0;
    private int cursorPos = 0;
    private int firstDisplayRow = 0;
    private int firstCharToDisplay = 0;
    private long keyPressTime = -1L;
    private long keyReleaseTime = -1L;

    public BuyInputCanvas(UIController uiController) {
        this.KEY_CLEAR = -8;
        this.setTitle(uiController.getString(0));
        this.uiController = uiController;
        this.text = new Vector(7);
        this.text.addElement("");
        this.invalidRowBuf = new StringBuffer();
        this.submitCommand = new Command(uiController.getString(25), 1, 6);
        this.backMenuCommand = new Command(uiController.getString(129), 1, 7);
        this.addPhoneCommand = new Command(uiController.getString(125), 1, 8);
        this.clearCommand = new Command(uiController.getString(28), 3, 9);
        this.agentCommand = new Command(uiController.getString(147), 1, 10);
        this.currencyCodeCommand = new Command(uiController.getString(149), 1, 11);
        this.addCommand(this.submitCommand);
        this.addCommand(this.currencyCodeCommand);
        this.addCommand(this.agentCommand);
        this.addCommand(this.addPhoneCommand);
        this.addCommand(this.clearCommand);
        this.addCommand(this.backMenuCommand);
        this.setCommandListener(this);
    }

    public void init(Display display, String userId, String buyMethod, int maxRow, boolean special) {
        this.display = display;
        this.buyMethod = buyMethod;
        this.maxRow = maxRow;
        this.special = special;
        this.invalidRowBuf = new StringBuffer();
        this.text.removeAllElements();
        this.text.addElement(userId);
        this.text.addElement("MYR");
        this.text.addElement(DATE_PREFIX);
        this.text.addElement(SYMBOL_PLUS);
        this.cursorRow = 3;
        this.cursorPos = 1;
        this.firstDisplayRow = 0;
    }

    public void init(Display display, String userId, String buyMethod, int maxRow, String txt, boolean special) {
        this.display = display;
        this.buyMethod = buyMethod;
        this.maxRow = maxRow;
        this.special = special;
        this.invalidRowBuf = new StringBuffer();
        this.text.removeAllElements();
        this.cursorRow = 3;
        this.cursorPos = 1;
        this.firstDisplayRow = 0;
        this.text.addElement(userId);
        this.text.addElement("MYR");
        int idx = -1;
        String txtTmp = new String(txt);
        String s = null;
        while ((idx = txtTmp.indexOf("\n")) != -1) {
            s = txtTmp.substring(0, idx);
            this.text.addElement(s);
            txtTmp = txtTmp.substring(idx + 1);
        }
        this.text.addElement(txtTmp.substring(idx + 1));
    }

    protected void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(0);
        this.drawText(g);
        this.drawCursor(g);
    }

    public void commandAction(Command command, Displayable displayable) {
        StandbyMonitor.reset();
        if (command == this.backMenuCommand) {
            this.uiController.handleEvent(9, null);
        } else if (command == this.submitCommand) {
            if (!this.validateLines()) {
                System.out.println("Validate line failed");
                this.uiController.handleEvent(60, new Object[]{this.getTransaction(), new Integer(this.errorLineNumber)});
                this.repaint();
                return;
            }
            this.uiController.handleEvent(10, new Object[]{this.getTransaction(), new Boolean(this.special)});
            this.uiController.setCurrent((Displayable)this.confirmationUI);
        } else if (command == this.currencyCodeCommand) {
            this.uiController.handleEvent(81, new Object[]{this});
        } else if (command == this.agentCommand) {
            this.uiController.handleEvent(51, new Object[]{this});
        } else if (command == this.addPhoneCommand) {
            this.uiController.handleEvent(61, new Object[]{this});
        } else if (command == this.clearCommand) {
            this.deleteChar();
            this.repaint();
        }
    }

    protected void keyPressed(int keyCode) {
        StandbyMonitor.reset();
        switch (keyCode) {
            case 48: {
                this.addChar('0');
                this.repaint();
                break;
            }
            case 49: {
                this.addChar('1');
                this.repaint();
                break;
            }
            case 50: {
                this.addChar('2');
                this.repaint();
                break;
            }
            case 51: {
                this.addChar('3');
                this.repaint();
                break;
            }
            case 52: {
                this.addChar('4');
                this.repaint();
                break;
            }
            case 53: {
                this.addChar('5');
                this.repaint();
                break;
            }
            case 54: {
                this.addChar('6');
                this.repaint();
                break;
            }
            case 55: {
                this.addChar('7');
                this.repaint();
                break;
            }
            case 56: {
                this.addChar('8');
                this.repaint();
                break;
            }
            case 57: {
                this.addChar('9');
                this.repaint();
                break;
            }
            case 42: {
                System.out.println("Key Press : " + new Date().getTime());
                this.keyPressTime = new Date().getTime();
                break;
            }
            case 35: {
                this.addChar('#');
                this.repaint();
                break;
            }
            default: {
                int gameKeyCode = this.getGameAction(keyCode);
                if (gameKeyCode == 1) {
                    this.cursorMoveUp();
                } else if (gameKeyCode == 6) {
                    this.cursorMoveDown();
                } else if (gameKeyCode == 2) {
                    this.cursorMoveLeft();
                } else if (gameKeyCode == 5) {
                    this.cursorMoveRight();
                } else if (keyCode == -8) {
                    this.deleteChar();
                }
                this.repaint();
            }
        }
    }

    protected void keyReleased(int keyCode) {
        if (keyCode == 42) {
            this.keyReleaseTime = new Date().getTime();
            if (this.keyReleaseTime - this.keyPressTime > 500L) {
                this.addChar('+');
            } else {
                this.addChar('*');
            }
            this.repaint();
        }
    }

    public Vector getTransaction() {
        return this.text;
    }

    public void changeAgent(String agent) {
        if (agent == null || agent.trim().length() == 0) {
            return;
        }
        this.text.setElementAt(agent, 0);
        this.repaint();
    }

    public void changeCurrencyCode(String currencyCode) {
        if (currencyCode == null || currencyCode.trim().length() == 0) {
            return;
        }
        this.text.setElementAt(currencyCode, 1);
        this.repaint();
    }

    public void addContact(String phoneNum, int inputMethod) {
        if (phoneNum == null || phoneNum.trim().length() == 0) {
            return;
        }
        if (this.text.size() > 0) {
            String lastRow = (String)this.text.elementAt(this.text.size() - 1);
            if (1 == inputMethod) {
                if (lastRow.startsWith(SYMBOL_DOUBLE_ASTERISK) || lastRow.trim().length() == 0) {
                    this.text.setElementAt(SYMBOL_DOUBLE_ASTERISK + phoneNum, this.text.size() - 1);
                } else {
                    this.text.addElement(SYMBOL_DOUBLE_ASTERISK + phoneNum);
                }
            } else if (3 == inputMethod) {
                if (lastRow.startsWith(SYMBOL_HASH_ASTERISK_HASH) || lastRow.trim().length() == 0) {
                    this.text.setElementAt(SYMBOL_HASH_ASTERISK_HASH + phoneNum, this.text.size() - 1);
                } else {
                    this.text.addElement(SYMBOL_HASH_ASTERISK_HASH + phoneNum);
                }
            } else if ((lastRow.startsWith("010") || lastRow.startsWith("011") || lastRow.startsWith("012") || lastRow.startsWith("013") || lastRow.startsWith("014") || lastRow.startsWith("015") || lastRow.startsWith("016") || lastRow.startsWith("017") || lastRow.startsWith("018") || lastRow.startsWith("019")) && (lastRow.trim().length() == 10 || lastRow.trim().length() == 11) && lastRow.indexOf(SYMBOL_HASH) == -1 || lastRow.trim().length() == 0) {
                this.text.setElementAt(phoneNum, this.text.size() - 1);
            } else {
                this.text.addElement(phoneNum);
            }
        }
        this.repaint();
    }

    private void drawText(Graphics g) {
        int currHeight = 0;
        int start = this.firstDisplayRow;
        int end = this.firstDisplayRow + this.MAX_DISPLAY_ROWS - 1 < this.text.size() ? this.firstDisplayRow + this.MAX_DISPLAY_ROWS : this.text.size();
        this.firstCharToDisplay = 0;
        if (this.cursorPos > this.MAX_DISPLAY_COLS) {
            this.firstCharToDisplay = this.cursorPos - this.MAX_DISPLAY_COLS;
        }
        String invalidRow = this.invalidRowBuf.toString();
        g.setFont(INPUT_FONT);
        String s = null;
        int tmpHeight = 0;
        int rows = this.getHeight() / INPUT_FONT_HEIGHT;
        int i = 0;
        while (i < rows) {
            g.setColor(0);
            tmpHeight = tmpHeight + INPUT_FONT_HEIGHT + 1;
            g.drawLine(0, tmpHeight, this.getWidth(), tmpHeight);
            ++i;
        }
        i = start;
        while (i < end) {
            if (invalidRow.indexOf(String.valueOf(i) + SYMBOL_PIPE) != -1) {
                g.setColor(255, 0, 0);
            }
            if ((s = (String)this.text.elementAt(i)).length() < this.firstCharToDisplay) {
                s = "";
            } else if (this.firstCharToDisplay != 0) {
                s = s.substring(this.firstCharToDisplay);
            }
            g.drawString(s, 1, currHeight, 20);
            currHeight += INPUT_FONT_HEIGHT + 1;
            g.setColor(0);
            ++i;
        }
    }

    private void drawCursor(Graphics g) {
        String s = (String)this.text.elementAt(this.cursorRow);
        s = s.substring(0, this.cursorPos);
        if (this.cursorPos > this.MAX_DISPLAY_COLS) {
            s = s.substring(0, this.MAX_DISPLAY_COLS);
        }
        int x = INPUT_FONT.stringWidth(s) + 1;
        int y = -1;
        y = (INPUT_FONT_HEIGHT + 1) * (this.cursorRow - this.firstDisplayRow);
        g.drawLine(x, y, x, y + INPUT_FONT_HEIGHT);
    }

    private void cursorMoveUp() {
        System.out.println("v--- cursorMoveUp Before : cursorRow : " + this.cursorRow + ", cursorPos : " + this.cursorPos + ", firstDisplayRow : " + this.firstDisplayRow);
        if (this.cursorRow > 1) {
            --this.cursorRow;
        }
        if (this.firstDisplayRow > this.cursorRow) {
            this.firstDisplayRow = this.cursorRow;
        } else if (this.cursorRow == 1) {
            this.firstDisplayRow = 0;
        }
        int length = ((String)this.text.elementAt(this.cursorRow)).length();
        if (length - 1 < this.cursorPos) {
            this.cursorPos = length;
        }
        System.out.println("v--- cursorMoveUp : cursorRow : " + this.cursorRow + ", cursorPos : " + this.cursorPos + ", firstDisplayRow : " + this.firstDisplayRow);
    }

    private void cursorMoveDown() {
        int length;
        String s = (String)this.text.elementAt(this.cursorRow);
        if (s == null || s.trim().length() == 0 || this.cursorRow == this.maxRow - 1) {
            return;
        }
        if (this.cursorRow == this.text.size() - 1) {
            this.text.addElement("");
            ++this.cursorRow;
        } else if (this.cursorRow < this.text.size() - 1) {
            ++this.cursorRow;
        }
        if (this.firstDisplayRow + this.MAX_DISPLAY_ROWS <= this.cursorRow) {
            this.firstDisplayRow = this.cursorRow - this.MAX_DISPLAY_ROWS + 1;
        }
        if ((length = ((String)this.text.elementAt(this.cursorRow)).length()) - 1 < this.cursorPos) {
            this.cursorPos = length;
        }
        System.out.println("v--- cursorMoveDown : cursorRow : " + this.cursorRow + ", cursorPos : " + this.cursorPos + ", firstDisplayRow : " + this.firstDisplayRow);
    }

    private void cursorMoveLeft() {
        if (this.cursorPos > 0) {
            --this.cursorPos;
        }
    }

    private void cursorMoveRight() {
        String s = (String)this.text.elementAt(this.cursorRow);
        if (this.cursorPos < s.length()) {
            ++this.cursorPos;
        }
    }

    private void addChar(char c) {
        System.out.println("v--- addChar : c : " + c + ", cursorRow : " + this.cursorRow + ", cursorPos : " + this.cursorPos);
        StringBuffer sb = new StringBuffer((String)this.text.elementAt(this.cursorRow));
        sb.insert(this.cursorPos, c);
        this.text.setElementAt(sb.toString(), this.cursorRow);
        this.cursorMoveRight();
    }

    private void deleteChar() {
        System.out.println("v--- deleteChar : cursorRow : " + this.cursorRow + ", cursorPos : " + this.cursorPos);
        if (this.cursorPos > 0) {
            if (this.cursorRow == 1 && this.cursorPos <= 2) {
                return;
            }
            StringBuffer sb = new StringBuffer((String)this.text.elementAt(this.cursorRow));
            sb.deleteCharAt(this.cursorPos - 1);
            this.text.setElementAt(sb.toString(), this.cursorRow);
            this.cursorMoveLeft();
        } else if (this.cursorPos == 0 && this.cursorRow != 1) {
            int tmp = ((String)this.text.elementAt(this.cursorRow - 1)).length();
            this.text.removeElementAt(this.cursorRow);
            this.cursorRow = this.cursorRow == 0 ? 0 : this.cursorRow - 1;
            this.cursorPos = tmp;
        }
    }

    private boolean validateLines() {
        boolean result = true;
        boolean isEmptyForm = true;
        boolean hasNumberLine = false;
        this.invalidRowBuf = new StringBuffer();
        int rowSize = this.text.size();
        if (rowSize == 0) {
            return false;
        }
        boolean prevLineHasValue = false;
        int lastRowType = 32;
        StringBuffer currentLotteryType = new StringBuffer();
        StringBuffer lotteryLength = new StringBuffer();
        this.errorLineNumber = -1;
        int i = 1;
        while (i < rowSize) {
            String line = ((String)this.text.elementAt(i)).trim();
            if (line != null && line.length() != 0) {
                isEmptyForm = false;
                if (lastRowType == 32) {
                    lastRowType = 68;
                } else if (lastRowType == 68) {
                    lastRowType = 76;
                } else if (lastRowType == 76) {
                    hasNumberLine = true;
                    lastRowType = 78;
                } else if (lastRowType == 78) {
                    if (line.startsWith(SYMBOL_PLUS)) {
                        lastRowType = 76;
                    } else if (i == rowSize - 1 && line.startsWith(SYMBOL_DOUBLE_ASTERISK)) {
                        lastRowType = 80;
                    }
                }
                if (lastRowType == 68) {
                    if (!this.validateDateRow(line)) {
                        this.invalidRowBuf.append(String.valueOf(i) + SYMBOL_PIPE);
                        result = false;
                    }
                } else if (lastRowType == 76) {
                    prevLineHasValue = false;
                    if (!this.validateLotteryRow(line, currentLotteryType, lotteryLength)) {
                        this.invalidRowBuf.append(String.valueOf(i) + SYMBOL_PIPE);
                        result = false;
                    }
                } else if (lastRowType == 78) {
                    if (!this.validateNumberRow(line, currentLotteryType.toString(), lotteryLength.toString(), prevLineHasValue)) {
                        this.invalidRowBuf.append(String.valueOf(i) + SYMBOL_PIPE);
                        result = false;
                    } else {
                        prevLineHasValue = true;
                    }
                } else if (lastRowType == 80 && !this.validatePhoneNo(line)) {
                    this.invalidRowBuf.append(String.valueOf(i) + SYMBOL_PIPE);
                    result = false;
                }
            }
            if (!result && this.errorLineNumber == -1) {
                this.errorLineNumber = i + 1;
            }
            ++i;
        }
        if (isEmptyForm) {
            return false;
        }
        if (!hasNumberLine) {
            return false;
        }
        return result;
    }

    private boolean validateDateRow(String line) {
        int index = -1;
        if (!line.startsWith(DATE_PREFIX)) {
            return false;
        }
        if (DATE_PREFIX.equals(line)) {
            return true;
        }
        index = line.indexOf(SYMBOL_ASTERISK, 2);
        if (index == -1) {
            String numOfDays = line.substring(2);
            try {
                int numOfDaysInt = Integer.parseInt(numOfDays);
                return numOfDaysInt >= 2 && numOfDaysInt <= 6;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if ("D#*".equals(line)) {
            return true;
        }
        if (index == 2) {
            String days = line.substring(3);
            if (days != null && days.length() > 6) {
                return false;
            }
            int i = 0;
            while (i < days.length()) {
                try {
                    int n = Integer.parseInt(days.substring(i, i + 1));
                    if (n < 1 || n > 7) {
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (index == 3 && line.startsWith("D#1*")) {
            int nextIdx = line.indexOf(SYMBOL_ASTERISK, 4);
            String transNo = null;
            transNo = nextIdx == -1 ? line.substring(4) : line.substring(4, nextIdx);
            try {
                Integer.parseInt(transNo);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (nextIdx != -1) {
                String numOfDays = line.substring(nextIdx + 1);
                try {
                    int n = Integer.parseInt(numOfDays);
                    if (n < 2 || n > 6) {
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean validateLotteryRow(String line, StringBuffer currentLotteryType, StringBuffer lotteryLength) {
        if (!line.startsWith(SYMBOL_PLUS) || SYMBOL_PLUS.equals(line)) {
            return false;
        }
        int idx = line.indexOf(SYMBOL_ASTERISK, 1);
        String lottery = null;
        int lotteryType = -1;
        currentLotteryType.delete(0, currentLotteryType.length());
        lotteryLength.delete(0, lotteryLength.length());
        if (idx == -1) {
            currentLotteryType.append("1");
            lottery = line.substring(1);
            lotteryLength.append(Integer.toString(lottery.length()));
        } else {
            block35: {
                block34: {
                    if (idx == 1) {
                        currentLotteryType.append("1");
                        try {
                            lottery = line.substring(idx + 1);
                            Integer.parseInt(lottery);
                        }
                        catch (NumberFormatException e) {
                            return false;
                        }
                    }
                    lottery = line.substring(1, idx);
                    lotteryLength.append(Integer.toString(lottery.length()));
                    try {
                        lotteryType = Integer.parseInt(line.substring(idx + 1));
                        if (lotteryType >= 2 && (lotteryType <= 7 || lotteryType == 31 || lotteryType == 32)) break block34;
                        return false;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                if (lotteryType != 5 && lotteryType != 6 || "3".equals(lottery)) break block35;
                return false;
            }
            currentLotteryType.append(line.substring(idx + 1));
        }
        if (lottery.length() < 1 || lottery.length() > 7) {
            return false;
        }
        if (this.special && !lottery.equals("8")) {
            return false;
        }
        boolean oneExist = false;
        boolean twoExist = false;
        boolean threeExist = false;
        boolean fourExist = false;
        boolean fiveExist = false;
        boolean sixExist = false;
        boolean sevenExist = false;
        int i = 0;
        while (i < lottery.length()) {
            char c = lottery.charAt(i);
            if (c == '1') {
                if (oneExist) {
                    System.out.println("repeated : " + c);
                    return false;
                }
                oneExist = true;
            } else if (c == '2') {
                if (twoExist) {
                    System.out.println("repeated : " + c);
                    return false;
                }
                twoExist = true;
            } else if (c == '3') {
                if (threeExist) {
                    System.out.println("repeated : " + c);
                    return false;
                }
                threeExist = true;
            } else if (c == '4') {
                if (fourExist) {
                    System.out.println("repeated : " + c);
                    return false;
                }
                fourExist = true;
            } else if (c == '5') {
                if (fiveExist) {
                    System.out.println("repeated : " + c);
                    return false;
                }
                fiveExist = true;
            } else if (c == '6') {
                if (sixExist) {
                    System.out.println("repeated : " + c);
                    return false;
                }
                sixExist = true;
            } else if (c == '7') {
                if (sevenExist) {
                    System.out.println("repeated : " + c);
                    return false;
                }
                sevenExist = true;
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean validateNumberRow(String line, String lotteryType, String lotteryLength, boolean prevLineHasValue) {
        boolean isShortcut = false;
        boolean isRange = false;
        boolean isStar = false;
        String num = null;
        if (line.startsWith(SYMBOL_HASH)) {
            return false;
        }
        int idx = line.indexOf(SYMBOL_HASH);
        if (idx == -1) {
            return false;
        }
        num = line.substring(0, idx);
        int rangeIdx = num.indexOf("***");
        int numType = -1;
        if (rangeIdx != -1) {
            int secondNumInt;
            if (num.endsWith("***")) {
                return false;
            }
            isRange = true;
            if (num.endsWith(SYMBOL_ASTERISK)) {
                isShortcut = true;
            }
            if (isShortcut) {
                try {
                    int shortcutNum = Integer.parseInt(line.substring(idx + 1));
                    if (shortcutNum < 1) {
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            String firstNum = null;
            String secondNum = null;
            firstNum = num.substring(0, rangeIdx);
            secondNum = isShortcut ? num.substring(rangeIdx + 3, num.length() - 1) : num.substring(rangeIdx + 3);
            num = firstNum;
            try {
                Integer.parseInt(firstNum);
                Integer.parseInt(secondNum);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (firstNum.length() != secondNum.length()) {
                return false;
            }
            if (firstNum.length() != 3 && firstNum.length() != 4) {
                return false;
            }
            if ("2".equals(lotteryType) && firstNum.length() == 3) {
                return false;
            }
            if ("5".equals(lotteryType) || "6".equals(lotteryType) || "7".equals(lotteryType)) {
                return false;
            }
            int firstNumInt = Integer.parseInt(firstNum);
            if (firstNumInt >= (secondNumInt = Integer.parseInt(secondNum))) {
                return false;
            }
            if (secondNumInt - firstNumInt >= 50) {
                return false;
            }
        } else {
            int idx2 = num.indexOf(SYMBOL_ASTERISK);
            if (idx2 != -1 && idx2 != 1 && idx2 != num.length() - 1) {
                return false;
            }
            if (idx2 == -1) {
                numType = 0;
            }
            if (idx2 == 1) {
                isStar = true;
                numType = Integer.parseInt(num.substring(0, 1));
                if (numType < 1 || numType > 5) {
                    return false;
                }
                int idx3 = num.indexOf(SYMBOL_ASTERISK, idx2 + 1);
                if (idx3 == -1) {
                    try {
                        num = num.substring(2);
                        Integer.parseInt(num);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                try {
                    isShortcut = true;
                    num = num.substring(idx2 + 1, idx3);
                    Integer.parseInt(num);
                    int shortcutNum = Integer.parseInt(line.substring(idx + 1));
                    if (shortcutNum < 1) {
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (idx2 == num.length() - 1) {
                try {
                    isShortcut = true;
                    num = num.substring(0, num.length() - 1);
                    Integer.parseInt(num);
                    int shortcutNum = Integer.parseInt(line.substring(idx + 1));
                    if (shortcutNum < 1) {
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        if (num.length() < 2 || num.length() > 6) {
            return false;
        }
        try {
            Integer.parseInt(num);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (isShortcut && num.length() != 4) {
            return false;
        }
        if ("1".equals(lotteryType)) {
            if (num.length() != 4 && num.length() != 3) {
                return false;
            }
            if (!this.validateLotteryType1Amount(line, prevLineHasValue, isShortcut)) {
                return false;
            }
        } else if ("2".equals(lotteryType)) {
            if (isShortcut) {
                return false;
            }
            if (num.length() != 4) {
                return false;
            }
            if (!this.validateLotteryType2And31Amount(line, prevLineHasValue)) {
                return false;
            }
        } else if ("3".equals(lotteryType)) {
            if (isStar || isRange) {
                return false;
            }
            if (num.length() != 4 && num.length() != 3) {
                return false;
            }
            if (!this.validateLotteryType3Amount(line, lotteryLength, prevLineHasValue, isShortcut)) {
                return false;
            }
        } else if ("31".equals(lotteryType)) {
            if (isShortcut || isStar || isRange) {
                return false;
            }
            if (num.length() != 4) {
                return false;
            }
            if (!this.validateLotteryType2And31Amount(line, prevLineHasValue)) {
                return false;
            }
        } else if ("32".equals(lotteryType)) {
            if (isShortcut || isStar || isRange) {
                return false;
            }
            if (num.length() != 4 && num.length() != 3) {
                return false;
            }
            if (!this.validateLotteryType32And4Amount(line, prevLineHasValue)) {
                return false;
            }
        } else if ("4".equals(lotteryType)) {
            if (isShortcut) {
                return false;
            }
            if (num.length() != 4 && num.length() != 3) {
                return false;
            }
            if (!this.validateLotteryType32And4Amount(line, prevLineHasValue)) {
                return false;
            }
        } else if ("5".equals(lotteryType)) {
            if (isShortcut || isStar || isRange) {
                return false;
            }
            if (num.length() != 5) {
                return false;
            }
            if (!this.validateLotteryType5Amount(line, prevLineHasValue)) {
                return false;
            }
        } else if ("6".equals(lotteryType)) {
            if (isShortcut || isStar || isRange) {
                return false;
            }
            if (num.length() != 6) {
                return false;
            }
            if (!this.validateLotteryType6Amount(line, prevLineHasValue)) {
                return false;
            }
        } else if ("7".equals(lotteryType)) {
            if (isShortcut || isStar || isRange) {
                return false;
            }
            if (num.length() != 2) {
                return false;
            }
            if (!this.validateLotteryType7Amount(line, prevLineHasValue)) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean validatePhoneNo(String line) {
        String phone;
        block3: {
            try {
                phone = line.substring(2);
                Integer.parseInt(phone);
                if (phone.startsWith("01") || phone.startsWith("601") || phone.startsWith("+601")) break block3;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return phone.length() >= 10;
    }

    private boolean validateLotteryType1Amount(String line, boolean prevLineHasValue, boolean isShortcut) {
        String t;
        int index = line.indexOf(SYMBOL_HASH);
        if (index == line.length() - 1 && prevLineHasValue) {
            return true;
        }
        if (index == line.length() - 1) {
            return false;
        }
        String tmp = line.substring(index + 1);
        if (isShortcut) {
            try {
                Integer.parseInt(tmp);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        boolean hasBAmount = false;
        boolean hasSAmount = false;
        boolean hasCAmount = false;
        boolean hasAAmount = false;
        boolean has4AAmount = false;
        index = tmp.indexOf(SYMBOL_HASH);
        if (index != -1) {
            t = tmp.substring(0, index);
            if (!this.validateAmount(t)) {
                return false;
            }
            if (t.length() > 0) {
                hasBAmount = true;
            }
        } else {
            if (!this.validateAmount(tmp)) {
                return false;
            }
            if (tmp.length() > 0) {
                hasBAmount = true;
            }
            return hasBAmount;
        }
        System.out.println("After B hasAmount : " + hasBAmount);
        tmp = tmp.substring(index + 1);
        index = tmp.indexOf(SYMBOL_HASH);
        if (index != -1) {
            t = tmp.substring(0, index);
            if (!this.validateAmount(t)) {
                return false;
            }
            if (t.length() > 0) {
                hasSAmount = true;
            }
        } else {
            if (!this.validateAmount(tmp)) {
                return false;
            }
            if (tmp.length() > 0) {
                hasSAmount = true;
            }
            return hasBAmount || hasSAmount;
        }
        System.out.println("After S hasAmount : " + hasSAmount);
        tmp = tmp.substring(index + 1);
        index = tmp.indexOf(SYMBOL_HASH);
        if (index != -1) {
            t = tmp.substring(0, index);
            if (!this.validateAmount(t)) {
                return false;
            }
            if (t.length() > 0) {
                hasCAmount = true;
            }
        } else {
            if (!this.validateAmount(tmp)) {
                return false;
            }
            if (tmp.length() > 0) {
                hasCAmount = true;
            }
            return hasBAmount || hasSAmount || hasCAmount;
        }
        System.out.println("After C hasAmount : " + hasCAmount);
        tmp = tmp.substring(index + 1);
        index = tmp.indexOf(SYMBOL_HASH);
        if (index != -1) {
            t = tmp.substring(0, index);
            if (!this.validateAmount(t)) {
                return false;
            }
            if (t.length() > 0) {
                hasAAmount = true;
            }
        } else {
            if (!this.validateAmount(tmp)) {
                return false;
            }
            if (tmp.length() > 0) {
                hasAAmount = true;
            }
            return hasBAmount || hasSAmount || hasCAmount || hasAAmount;
        }
        if ((index = (tmp = tmp.substring(index + 1)).indexOf(SYMBOL_HASH)) != -1) {
            return false;
        }
        if (!this.validateAmount(tmp)) {
            return false;
        }
        if (tmp.length() > 0) {
            has4AAmount = true;
        }
        return hasBAmount || hasSAmount || hasCAmount || hasAAmount || has4AAmount;
    }

    private boolean validateLotteryType2And31Amount(String line, boolean prevLineHasValue) {
        String t;
        int index = line.indexOf(SYMBOL_HASH);
        if (index == line.length() - 1 && prevLineHasValue) {
            return true;
        }
        if (index == line.length() - 1) {
            return false;
        }
        boolean hasA1Amount = false;
        boolean hasA2Amount = false;
        boolean hasA3Amount = false;
        boolean hasD4Amount = false;
        boolean hasE4Amount = false;
        boolean hasA1CAmount = false;
        String tmp = line.substring(index + 1);
        if ((index = tmp.indexOf(SYMBOL_HASH)) != -1) {
            t = tmp.substring(0, index);
            if (!this.validateAmount(t)) {
                return false;
            }
            if (t.length() > 0) {
                hasA1Amount = true;
            }
        } else {
            if (!this.validateAmount(tmp)) {
                return false;
            }
            if (tmp.length() > 0) {
                hasA1Amount = true;
            }
            return hasA1Amount;
        }
        if ((index = (tmp = tmp.substring(index + 1)).indexOf(SYMBOL_HASH)) != -1) {
            t = tmp.substring(0, index);
            if (!this.validateAmount(t)) {
                return false;
            }
            if (t.length() > 0) {
                hasA2Amount = true;
            }
        } else {
            if (!this.validateAmount(tmp)) {
                return false;
            }
            if (tmp.length() > 0) {
                hasA2Amount = true;
            }
            return hasA1Amount || hasA2Amount;
        }
        if ((index = (tmp = tmp.substring(index + 1)).indexOf(SYMBOL_HASH)) != -1) {
            t = tmp.substring(0, index);
            if (!this.validateAmount(t)) {
                return false;
            }
            if (t.length() > 0) {
                hasA3Amount = true;
            }
        } else {
            if (!this.validateAmount(tmp)) {
                return false;
            }
            if (tmp.length() > 0) {
                hasA3Amount = true;
            }
            return hasA1Amount || hasA2Amount || hasA3Amount;
        }
        if ((index = (tmp = tmp.substring(index + 1)).indexOf(SYMBOL_HASH)) != -1) {
            t = tmp.substring(0, index);
            if (!this.validateAmount(t)) {
                return false;
            }
            if (t.length() > 0) {
                hasD4Amount = true;
            }
        } else {
            if (!this.validateAmount(tmp)) {
                return false;
            }
            if (tmp.length() > 0) {
                hasD4Amount = true;
            }
            return hasA1Amount || hasA2Amount || hasA3Amount || hasD4Amount;
        }
        if ((index = (tmp = tmp.substring(index + 1)).indexOf(SYMBOL_HASH)) != -1) {
            t = tmp.substring(0, index);
            if (!this.validateAmount(t)) {
                return false;
            }
            if (t.length() > 0) {
                hasE4Amount = true;
            }
        } else {
            if (!this.validateAmount(tmp)) {
                return false;
            }
            if (tmp.length() > 0) {
                hasE4Amount = true;
            }
            return hasA1Amount || hasA2Amount || hasA3Amount || hasD4Amount || hasE4Amount;
        }
        if ((index = (tmp = tmp.substring(index + 1)).indexOf(SYMBOL_HASH)) != -1) {
            return false;
        }
        if (!this.validateAmount(tmp)) {
            return false;
        }
        if (tmp.length() > 0) {
            hasA1CAmount = true;
        }
        return hasA1Amount || hasA2Amount || hasA3Amount || hasD4Amount || hasE4Amount || hasA1CAmount;
    }

    private boolean validateLotteryType3Amount(String line, String lotteryLength, boolean prevLineHasValue, boolean isShortcut) {
        String t;
        int index = line.indexOf(SYMBOL_HASH);
        if (index == line.length() - 1 && prevLineHasValue) {
            return true;
        }
        if (index == line.length() - 1) {
            return false;
        }
        String tmp = line.substring(index + 1);
        if (isShortcut) {
            try {
                Integer.parseInt(tmp);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        boolean hasBAmount = false;
        boolean hasSAmount = false;
        boolean hasCAmount = false;
        boolean hasAAmount = false;
        boolean has4AAmount = false;
        index = tmp.indexOf(SYMBOL_HASH);
        if (index != -1) {
            t = tmp.substring(0, index);
            if (!this.validateAmount(t)) {
                return false;
            }
            if (!this.validateIBoxAmount(t, lotteryLength)) {
                return false;
            }
            if (t.length() > 0) {
                hasBAmount = true;
            }
        } else {
            if (!this.validateAmount(tmp)) {
                return false;
            }
            if (!this.validateIBoxAmount(tmp, lotteryLength)) {
                return false;
            }
            if (tmp.length() > 0) {
                hasBAmount = true;
            }
            return hasBAmount;
        }
        System.out.println("After B hasAmount : " + hasBAmount);
        tmp = tmp.substring(index + 1);
        index = tmp.indexOf(SYMBOL_HASH);
        if (index != -1) {
            t = tmp.substring(0, index);
            if (!this.validateAmount(t)) {
                return false;
            }
            if (!this.validateIBoxAmount(t, lotteryLength)) {
                return false;
            }
            if (t.length() > 0) {
                hasSAmount = true;
            }
        } else {
            if (!this.validateAmount(tmp)) {
                return false;
            }
            if (!this.validateIBoxAmount(tmp, lotteryLength)) {
                return false;
            }
            if (tmp.length() > 0) {
                hasSAmount = true;
            }
            return hasBAmount || hasSAmount;
        }
        System.out.println("After S hasAmount : " + hasSAmount);
        tmp = tmp.substring(index + 1);
        index = tmp.indexOf(SYMBOL_HASH);
        if (index != -1) {
            t = tmp.substring(0, index);
            if (!this.validateAmount(t)) {
                return false;
            }
            if (!this.validateIBoxAmount(t, lotteryLength)) {
                return false;
            }
            if (t.length() > 0) {
                hasCAmount = true;
            }
        } else {
            if (!this.validateAmount(tmp)) {
                return false;
            }
            if (!this.validateIBoxAmount(tmp, lotteryLength)) {
                return false;
            }
            if (tmp.length() > 0) {
                hasCAmount = true;
            }
            return hasBAmount || hasSAmount || hasCAmount;
        }
        System.out.println("After C hasAmount : " + hasCAmount);
        tmp = tmp.substring(index + 1);
        index = tmp.indexOf(SYMBOL_HASH);
        if (index != -1) {
            t = tmp.substring(0, index);
            if (!this.validateAmount(t)) {
                return false;
            }
            if (!this.validateIBoxAmount(t, lotteryLength)) {
                return false;
            }
            if (t.length() > 0) {
                hasAAmount = true;
            }
        } else {
            if (!this.validateAmount(tmp)) {
                return false;
            }
            if (!this.validateIBoxAmount(tmp, lotteryLength)) {
                return false;
            }
            if (tmp.length() > 0) {
                hasAAmount = true;
            }
            return hasBAmount || hasSAmount || hasCAmount || hasAAmount;
        }
        if ((index = (tmp = tmp.substring(index + 1)).indexOf(SYMBOL_HASH)) != -1) {
            return false;
        }
        if (!this.validateAmount(tmp)) {
            return false;
        }
        if (!this.validateIBoxAmount(tmp, lotteryLength)) {
            return false;
        }
        if (tmp.length() > 0) {
            has4AAmount = true;
        }
        return hasBAmount || hasSAmount || hasCAmount || hasAAmount || has4AAmount;
    }

    private boolean validateLotteryType32And4Amount(String line, boolean prevLineHasValue) {
        int index = line.indexOf(SYMBOL_HASH);
        if (index == line.length() - 1 && prevLineHasValue) {
            return true;
        }
        if (index == line.length() - 1) {
            return false;
        }
        boolean has4FAmount = false;
        boolean has3FAmount = false;
        String tmp = line.substring(index + 1);
        if ((index = tmp.indexOf(SYMBOL_HASH)) != -1) {
            String t = tmp.substring(0, index);
            if (!this.validateAmount(t)) {
                return false;
            }
            if (t.length() > 0) {
                has4FAmount = true;
            }
        } else {
            if (!this.validateAmount(tmp)) {
                return false;
            }
            if (tmp.length() > 0) {
                has4FAmount = true;
            }
            return has4FAmount;
        }
        if ((index = (tmp = tmp.substring(index + 1)).indexOf(SYMBOL_HASH)) != -1) {
            return false;
        }
        if (!this.validateAmount(tmp)) {
            return false;
        }
        if (tmp.length() > 0) {
            has3FAmount = true;
        }
        return has4FAmount || has3FAmount;
    }

    private boolean validateLotteryType5Amount(String line, boolean prevLineHasValue) {
        int index = line.indexOf(SYMBOL_HASH);
        if (index == line.length() - 1 && prevLineHasValue) {
            return true;
        }
        if (index == line.length() - 1) {
            return false;
        }
        String tmp = line.substring(index + 1);
        if (tmp.indexOf(SYMBOL_HASH) != -1) {
            return false;
        }
        if (line.substring(0, index).length() != 5) {
            return false;
        }
        return this.validateAmount(tmp);
    }

    private boolean validateLotteryType6Amount(String line, boolean prevLineHasValue) {
        int index = line.indexOf(SYMBOL_HASH);
        if (index == line.length() - 1 && prevLineHasValue) {
            return true;
        }
        if (index == line.length() - 1) {
            return false;
        }
        String tmp = line.substring(index + 1);
        if (tmp.indexOf(SYMBOL_HASH) != -1) {
            return false;
        }
        if (line.substring(0, index).length() != 6) {
            return false;
        }
        return this.validateAmount(tmp);
    }

    private boolean validateLotteryType7Amount(String line, boolean prevLineHasValue) {
        String t;
        int index = line.indexOf(SYMBOL_HASH);
        if (index == line.length() - 1 && prevLineHasValue) {
            return true;
        }
        if (index == line.length() - 1) {
            return false;
        }
        boolean has2AAmount = false;
        boolean has2CAmount = false;
        boolean has2FAmount = false;
        if (line.substring(0, index).length() != 2) {
            return false;
        }
        String tmp = line.substring(index + 1);
        if ((index = tmp.indexOf(SYMBOL_HASH)) != -1) {
            t = tmp.substring(0, index);
            if (!this.validateAmount(t)) {
                return false;
            }
            if (t.length() > 0) {
                has2AAmount = true;
            }
        } else {
            if (!this.validateAmount(tmp)) {
                return false;
            }
            if (tmp.length() > 0) {
                has2AAmount = true;
            }
            return has2AAmount;
        }
        if ((index = (tmp = tmp.substring(index + 1)).indexOf(SYMBOL_HASH)) != -1) {
            t = tmp.substring(0, index);
            if (!this.validateAmount(t)) {
                return false;
            }
            if (t.length() > 0) {
                has2CAmount = true;
            }
        } else {
            if (!this.validateAmount(tmp)) {
                return false;
            }
            if (tmp.length() > 0) {
                has2CAmount = true;
            }
            return has2AAmount || has2CAmount;
        }
        if ((index = (tmp = tmp.substring(index + 1)).indexOf(SYMBOL_HASH)) != -1) {
            return false;
        }
        if (!this.validateAmount(tmp)) {
            return false;
        }
        if (tmp.length() > 0) {
            has2FAmount = true;
        }
        return has2AAmount || has2CAmount || has2FAmount;
    }

    private boolean validateAmount(String amount) {
        System.out.println("***Validate amount : amount : " + amount);
        if (amount != null && amount.trim().length() == 0) {
            return true;
        }
        int index = amount.indexOf(SYMBOL_ASTERISK);
        if (index == 0) {
            return this.validateCents(amount.substring(1));
        }
        if (index == -1) {
            return this.validateDollar(amount, false);
        }
        String dollar = amount.substring(0, index);
        if (!this.validateDollar(dollar, true)) {
            return false;
        }
        String cents = amount.substring(index + 1);
        if (cents != null && cents.trim().length() == 0) {
            return true;
        }
        return this.validateCents(cents);
    }

    private boolean validateIBoxAmount(String amount, String lotteryLength) {
        if (amount != null && amount.trim().length() == 0) {
            return true;
        }
        int index = amount.indexOf(SYMBOL_ASTERISK);
        if (index == 0) {
            return false;
        }
        int amountInt = 0;
        int idx = amount.indexOf(SYMBOL_ASTERISK);
        amountInt = idx != -1 ? Integer.parseInt(amount.substring(0, idx)) : Integer.parseInt(amount);
        if ("/".equals(this.buyMethod) && amountInt / Integer.parseInt(lotteryLength) < 1) {
            return false;
        }
        return !"X".equals(this.buyMethod) || amountInt >= 1;
    }

    private boolean validateDollar(String dollar, boolean allowZero) {
        int amt;
        block5: {
            amt = 0;
            try {
                amt = Integer.parseInt(dollar);
                if (!allowZero) break block5;
                if (amt < 0 || amt > 999) {
                    System.out.println("Dollar amount out of range: " + amt);
                    return false;
                }
            }
            catch (NumberFormatException nfe) {
                System.out.println("Dollar amount not digits : " + dollar);
                return false;
            }
        }
        if (amt <= 0 || amt > 999) {
            System.out.println("Dollar amount out of range: " + amt);
            return false;
        }
        return true;
    }

    private boolean validateCents(String cents) {
        int amt = 0;
        try {
            amt = Integer.parseInt(cents);
            if (amt < 0 || amt > 999) {
                System.out.println("Cent amount out of range: " + amt);
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            System.out.println("Cent amount not digits : " + cents);
            return false;
        }
        return true;
    }
}

