/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.ui;

import com.cloudy.client.midp.ui.UIController;
import com.cloudy.client.midp.util.StandbyMonitor;
import java.util.Date;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;

public class BalanceUI
extends Form
implements CommandListener,
ItemStateListener {
    private UIController uiController;
    private DateField startDateDF;
    private DateField endDateDF;
    private ChoiceGroup drawTypeCG;
    private Command sendCommand;
    private Command backCommand;

    public BalanceUI(UIController uiController) {
        super(uiController.getString(3));
        this.uiController = uiController;
        this.startDateDF = new DateField(uiController.getString(69), 1);
        this.endDateDF = new DateField(uiController.getString(70), 1);
        this.drawTypeCG = new ChoiceGroup(uiController.getString(44), 1);
        this.drawTypeCG.append("1=All", null);
        this.drawTypeCG.append("2=MPTSBKW", null);
        this.drawTypeCG.append("3=GD LOTTO", null);
        this.drawTypeCG.append("4=9Lotto", null);
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        this.drawTypeCG.setSelectedFlags(blArray);
        this.sendCommand = new Command(uiController.getString(25), 1, 5);
        this.backCommand = new Command(uiController.getString(26), 2, 10);
        this.append((Item)this.startDateDF);
        this.append((Item)this.endDateDF);
        this.append((Item)this.drawTypeCG);
        this.addCommand(this.sendCommand);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
        this.setItemStateListener(this);
    }

    public void init(Date serverTime) {
        if (this.startDateDF != null) {
            this.startDateDF.setDate(serverTime);
        }
        if (this.endDateDF != null) {
            this.endDateDF.setDate(serverTime);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        StandbyMonitor.reset();
        if (command == this.backCommand) {
            this.uiController.handleEvent(15);
        } else if (command == this.sendCommand) {
            int index = this.drawTypeCG.getSelectedIndex();
            String drawType = null;
            if (index == 0) {
                drawType = "A";
            } else if (index == 1) {
                drawType = "M";
            } else if (index == 2) {
                drawType = "H";
            } else if (index == 3) {
                drawType = "E";
            }
            if (drawType == null || drawType.length() == 0) {
                this.uiController.showErrorAlert(this.uiController.getString(52), (Displayable)this);
                return;
            }
            this.uiController.handleEvent(16, new Object[]{this.startDateDF.getDate(), this.endDateDF.getDate(), drawType});
        }
    }

    public void itemStateChanged(Item item) {
        StandbyMonitor.reset();
    }
}

