/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.model;

import com.cloudy.client.midp.ApplicationException;
import com.cloudy.client.midp.IndexedResourceBundle;
import com.cloudy.client.midp.model.AccountInfo;
import com.cloudy.client.midp.model.DateObject;
import com.cloudy.client.midp.model.IndexEntry;
import com.cloudy.client.midp.model.IndexEntryFilter;
import com.cloudy.client.midp.model.PrintDevice;
import com.cloudy.client.midp.model.Settings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class RMSAdapter {
    public static final String RECORD_STORE_INDEX = "INDEX";
    public static final String RECORD_STORE_REMOTE_DATA = "REMOTE_DATA";
    public static final String RECORD_STORE_LOCAL_DATA = "LOCAL_DATA";
    private RecordStore indexRecordStore;
    private RecordStore remoteDataRecordStore;
    private RecordStore localDataRecordStore;

    public RMSAdapter() throws ApplicationException {
        try {
            this.indexRecordStore = RecordStore.openRecordStore((String)RECORD_STORE_INDEX, (boolean)true);
            this.remoteDataRecordStore = RecordStore.openRecordStore((String)RECORD_STORE_REMOTE_DATA, (boolean)true);
            this.localDataRecordStore = RecordStore.openRecordStore((String)RECORD_STORE_LOCAL_DATA, (boolean)true);
            return;
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public void closeRecordStores() throws ApplicationException {
        try {
            this.indexRecordStore.closeRecordStore();
            this.remoteDataRecordStore.closeRecordStore();
            this.localDataRecordStore.closeRecordStore();
            return;
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public void addIndexEntry(IndexEntry indexEntry) throws ApplicationException {
        try {
            byte[] data = indexEntry.serialize();
            if (this.indexRecordStore.getNumRecords() > 0) {
                RecordEnumeration records = this.indexRecordStore.enumerateRecords((RecordFilter)new IndexEntryFilter(indexEntry.getKey(), indexEntry.getType()), null, false);
                if (records.hasNextElement()) {
                    this.indexRecordStore.setRecord(records.nextRecordId(), data, 0, data.length);
                } else {
                    this.indexRecordStore.addRecord(data, 0, data.length);
                }
            } else {
                this.indexRecordStore.addRecord(data, 0, data.length);
            }
            return;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public IndexEntry[] getIndexEntries(int type) throws ApplicationException {
        try {
            if (this.indexRecordStore.getNumRecords() > 0) {
                RecordEnumeration records = this.indexRecordStore.enumerateRecords((RecordFilter)new IndexEntryFilter(null, type), null, false);
                IndexEntry[] indexEntries = new IndexEntry[records.numRecords()];
                int i = 0;
                while (i < indexEntries.length) {
                    byte[] data = this.indexRecordStore.getRecord(records.nextRecordId());
                    indexEntries[i] = IndexEntry.deserialize(data);
                    ++i;
                }
                return indexEntries;
            }
            return new IndexEntry[0];
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public IndexEntry getIndexEntry(String key, int type) throws ApplicationException {
        try {
            RecordEnumeration records;
            if (this.indexRecordStore.getNumRecords() > 0 && (records = this.indexRecordStore.enumerateRecords((RecordFilter)new IndexEntryFilter(key, type), null, false)).hasNextElement()) {
                byte[] data = this.indexRecordStore.getRecord(records.nextRecordId());
                return IndexEntry.deserialize(data);
            }
            return null;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public void deleteIndexEntry(String key, int type) throws ApplicationException {
        try {
            if (this.indexRecordStore.getNumRecords() > 0) {
                RecordEnumeration records = this.indexRecordStore.enumerateRecords((RecordFilter)new IndexEntryFilter(key, type), null, false);
                while (records.hasNextElement()) {
                    this.indexRecordStore.deleteRecord(records.nextRecordId());
                }
            }
            return;
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    private void delete(RecordStore recordStore, int recordId) throws ApplicationException {
        try {
            recordStore.deleteRecord(recordId);
            return;
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public IndexedResourceBundle loadResourceBundle(int recordId) throws ApplicationException {
        try {
            byte[] data = this.localDataRecordStore.getRecord(recordId);
            return IndexedResourceBundle.deserialize(new DataInputStream(new ByteArrayInputStream(data)));
        }
        catch (RecordStoreException rse) {
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int storeResourceBundle(IndexedResourceBundle bundle, int recordId) throws ApplicationException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            bundle.serialize(dataStream);
            dataStream.flush();
            if (recordId > 0) {
                this.localDataRecordStore.setRecord(recordId, stream.toByteArray(), 0, stream.size());
            } else {
                recordId = this.localDataRecordStore.addRecord(stream.toByteArray(), 0, stream.size());
            }
            return recordId;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public PrintDevice loadPrintDevice() throws ApplicationException {
        byte[] data;
        block6: {
            IndexEntry indexEntry;
            block5: {
                indexEntry = this.getIndexEntry(null, 16);
                if (indexEntry != null) break block5;
                return null;
            }
            data = this.localDataRecordStore.getRecord(indexEntry.getRecordId());
            if (data != null) break block6;
            return null;
        }
        try {
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
            PrintDevice device = new PrintDevice();
            device.setDeviceAddr(dataStream.readUTF());
            device.setDeviceName(dataStream.readUTF());
            device.setConnectionURL(dataStream.readUTF());
            return device;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int storePrintDevice(PrintDevice device, int recordId) throws ApplicationException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            dataStream.writeUTF(device.getDeviceAddr());
            dataStream.writeUTF(device.getDeviceName());
            dataStream.writeUTF(device.getConnectionURL());
            dataStream.flush();
            if (recordId > 0) {
                this.localDataRecordStore.setRecord(recordId, stream.toByteArray(), 0, stream.size());
            } else {
                recordId = this.localDataRecordStore.addRecord(stream.toByteArray(), 0, stream.size());
            }
            return recordId;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public String loadServiceURL() throws ApplicationException {
        byte[] data;
        block6: {
            IndexEntry indexEntry;
            block5: {
                indexEntry = this.getIndexEntry(null, 3);
                if (indexEntry != null) break block5;
                return null;
            }
            data = this.localDataRecordStore.getRecord(indexEntry.getRecordId());
            if (data != null) break block6;
            return null;
        }
        try {
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
            return dataStream.readUTF();
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int storeServiceURL(String url, int recordId) throws ApplicationException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            dataStream.writeUTF(url);
            dataStream.flush();
            if (recordId > 0) {
                this.localDataRecordStore.setRecord(recordId, stream.toByteArray(), 0, stream.size());
            } else {
                recordId = this.localDataRecordStore.addRecord(stream.toByteArray(), 0, stream.size());
            }
            return recordId;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public String loadServiceHideURL() throws ApplicationException {
        byte[] data;
        block6: {
            IndexEntry indexEntry;
            block5: {
                indexEntry = this.getIndexEntry(null, 25);
                if (indexEntry != null) break block5;
                return null;
            }
            data = this.localDataRecordStore.getRecord(indexEntry.getRecordId());
            if (data != null) break block6;
            return null;
        }
        try {
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
            return dataStream.readUTF();
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int storeServiceHideURL(String url, int recordId) throws ApplicationException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            dataStream.writeUTF(url);
            dataStream.flush();
            if (recordId > 0) {
                this.localDataRecordStore.setRecord(recordId, stream.toByteArray(), 0, stream.size());
            } else {
                recordId = this.localDataRecordStore.addRecord(stream.toByteArray(), 0, stream.size());
            }
            return recordId;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public String loadUserURL() throws ApplicationException {
        byte[] data;
        block6: {
            IndexEntry indexEntry;
            block5: {
                indexEntry = this.getIndexEntry(null, 24);
                if (indexEntry != null) break block5;
                return null;
            }
            data = this.localDataRecordStore.getRecord(indexEntry.getRecordId());
            if (data != null) break block6;
            return null;
        }
        try {
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
            return dataStream.readUTF();
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int storeUserURL(String url, int recordId) throws ApplicationException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            dataStream.writeUTF(url);
            dataStream.flush();
            if (recordId > 0) {
                this.localDataRecordStore.setRecord(recordId, stream.toByteArray(), 0, stream.size());
            } else {
                recordId = this.localDataRecordStore.addRecord(stream.toByteArray(), 0, stream.size());
            }
            return recordId;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int loadURL_Type() throws ApplicationException {
        byte[] data;
        block6: {
            IndexEntry indexEntry;
            block5: {
                indexEntry = this.getIndexEntry(null, 26);
                if (indexEntry != null) break block5;
                return 0;
            }
            data = this.localDataRecordStore.getRecord(indexEntry.getRecordId());
            if (data != null) break block6;
            return 0;
        }
        try {
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
            return dataStream.readInt();
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int storeURL_Type(int type, int recordId) throws ApplicationException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            dataStream.writeInt(type);
            dataStream.flush();
            if (recordId > 0) {
                this.localDataRecordStore.setRecord(recordId, stream.toByteArray(), 0, stream.size());
            } else {
                recordId = this.localDataRecordStore.addRecord(stream.toByteArray(), 0, stream.size());
            }
            return recordId;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public String loadStandbyPassword() throws ApplicationException {
        byte[] data;
        block6: {
            IndexEntry indexEntry;
            block5: {
                indexEntry = this.getIndexEntry(null, 14);
                if (indexEntry != null) break block5;
                return null;
            }
            data = this.localDataRecordStore.getRecord(indexEntry.getRecordId());
            if (data != null) break block6;
            return null;
        }
        try {
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
            return dataStream.readUTF();
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int storeStandbyPassword(String newPassword, int recordId) throws ApplicationException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            dataStream.writeUTF(newPassword);
            dataStream.flush();
            if (recordId > 0) {
                this.localDataRecordStore.setRecord(recordId, stream.toByteArray(), 0, stream.size());
            } else {
                recordId = this.localDataRecordStore.addRecord(stream.toByteArray(), 0, stream.size());
            }
            return recordId;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public Settings loadSettings() throws ApplicationException {
        byte[] data;
        block6: {
            IndexEntry indexEntry;
            block5: {
                indexEntry = this.getIndexEntry(null, 15);
                if (indexEntry != null) break block5;
                return null;
            }
            data = this.localDataRecordStore.getRecord(indexEntry.getRecordId());
            if (data != null) break block6;
            return null;
        }
        try {
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
            Settings settings = Settings.deserialize(dataStream);
            return settings;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int storeSettings(Settings settings, int recordId) throws ApplicationException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            settings.serialize(dataStream);
            if (recordId > 0) {
                this.localDataRecordStore.setRecord(recordId, stream.toByteArray(), 0, stream.size());
            } else {
                recordId = this.localDataRecordStore.addRecord(stream.toByteArray(), 0, stream.size());
            }
            return recordId;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public String loadUpdateURL() throws ApplicationException {
        byte[] data;
        block6: {
            IndexEntry indexEntry;
            block5: {
                indexEntry = this.getIndexEntry(null, 19);
                if (indexEntry != null) break block5;
                return null;
            }
            data = this.localDataRecordStore.getRecord(indexEntry.getRecordId());
            if (data != null) break block6;
            return null;
        }
        try {
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
            return dataStream.readUTF();
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int storeUpdateURL(String updateURL, int recordId) throws ApplicationException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            dataStream.writeUTF(updateURL);
            dataStream.flush();
            if (recordId > 0) {
                this.localDataRecordStore.setRecord(recordId, stream.toByteArray(), 0, stream.size());
            } else {
                recordId = this.localDataRecordStore.addRecord(stream.toByteArray(), 0, stream.size());
            }
            return recordId;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public String loadUserId() throws ApplicationException {
        byte[] data;
        block6: {
            IndexEntry indexEntry;
            block5: {
                indexEntry = this.getIndexEntry(null, 13);
                if (indexEntry != null) break block5;
                return null;
            }
            data = this.localDataRecordStore.getRecord(indexEntry.getRecordId());
            if (data != null) break block6;
            return null;
        }
        try {
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
            return dataStream.readUTF();
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int storeUserId(String userId, int recordId) throws ApplicationException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            dataStream.writeUTF(userId);
            dataStream.flush();
            if (recordId > 0) {
                this.localDataRecordStore.setRecord(recordId, stream.toByteArray(), 0, stream.size());
            } else {
                recordId = this.localDataRecordStore.addRecord(stream.toByteArray(), 0, stream.size());
            }
            return recordId;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public String loadVersion() throws ApplicationException {
        byte[] data;
        block6: {
            IndexEntry indexEntry;
            block5: {
                indexEntry = this.getIndexEntry(null, 2);
                if (indexEntry != null) break block5;
                return null;
            }
            data = this.localDataRecordStore.getRecord(indexEntry.getRecordId());
            if (data != null) break block6;
            return null;
        }
        try {
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
            return dataStream.readUTF();
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int storeVersion(String version, int recordId) throws ApplicationException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            dataStream.writeUTF(version);
            dataStream.flush();
            if (recordId > 0) {
                this.localDataRecordStore.setRecord(recordId, stream.toByteArray(), 0, stream.size());
            } else {
                recordId = this.localDataRecordStore.addRecord(stream.toByteArray(), 0, stream.size());
            }
            return recordId;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public String loadAgentId() throws ApplicationException {
        byte[] data;
        block6: {
            IndexEntry indexEntry;
            block5: {
                indexEntry = this.getIndexEntry(null, 4);
                if (indexEntry != null) break block5;
                return null;
            }
            data = this.localDataRecordStore.getRecord(indexEntry.getRecordId());
            if (data != null) break block6;
            return null;
        }
        try {
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
            return dataStream.readUTF();
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int storeAgentId(String agentId, int recordId) throws ApplicationException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            dataStream.writeUTF(agentId);
            dataStream.flush();
            if (recordId > 0) {
                this.localDataRecordStore.setRecord(recordId, stream.toByteArray(), 0, stream.size());
            } else {
                recordId = this.localDataRecordStore.addRecord(stream.toByteArray(), 0, stream.size());
            }
            return recordId;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public String loadBuyMethod() throws ApplicationException {
        byte[] data;
        block6: {
            IndexEntry indexEntry;
            block5: {
                indexEntry = this.getIndexEntry(null, 12);
                if (indexEntry != null) break block5;
                return null;
            }
            data = this.localDataRecordStore.getRecord(indexEntry.getRecordId());
            if (data != null) break block6;
            return null;
        }
        try {
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
            return dataStream.readUTF();
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int storeBuyMethod(String buyMethod, int recordId) throws ApplicationException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            dataStream.writeUTF(buyMethod);
            dataStream.flush();
            if (recordId > 0) {
                this.localDataRecordStore.setRecord(recordId, stream.toByteArray(), 0, stream.size());
            } else {
                recordId = this.localDataRecordStore.addRecord(stream.toByteArray(), 0, stream.size());
            }
            return recordId;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public String loadLoginSequence() throws ApplicationException {
        byte[] data;
        block6: {
            IndexEntry indexEntry;
            block5: {
                indexEntry = this.getIndexEntry(null, 18);
                if (indexEntry != null) break block5;
                return null;
            }
            data = this.localDataRecordStore.getRecord(indexEntry.getRecordId());
            if (data != null) break block6;
            return null;
        }
        try {
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
            return dataStream.readUTF();
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int storeLoginSequence(String loginSequence, int recordId) throws ApplicationException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            dataStream.writeUTF(loginSequence);
            dataStream.flush();
            if (recordId > 0) {
                this.localDataRecordStore.setRecord(recordId, stream.toByteArray(), 0, stream.size());
            } else {
                recordId = this.localDataRecordStore.addRecord(stream.toByteArray(), 0, stream.size());
            }
            return recordId;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public String loadBetScreenLine2() throws ApplicationException {
        byte[] data;
        block6: {
            IndexEntry indexEntry;
            block5: {
                indexEntry = this.getIndexEntry(null, 21);
                if (indexEntry != null) break block5;
                return null;
            }
            data = this.localDataRecordStore.getRecord(indexEntry.getRecordId());
            if (data != null) break block6;
            return null;
        }
        try {
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
            return dataStream.readUTF();
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int storeBetScreenLine2(String betScreenLine2, int recordId) throws ApplicationException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            dataStream.writeUTF(betScreenLine2);
            dataStream.flush();
            if (recordId > 0) {
                this.localDataRecordStore.setRecord(recordId, stream.toByteArray(), 0, stream.size());
            } else {
                recordId = this.localDataRecordStore.addRecord(stream.toByteArray(), 0, stream.size());
            }
            return recordId;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public String loadBetScreenLine3() throws ApplicationException {
        byte[] data;
        block6: {
            IndexEntry indexEntry;
            block5: {
                indexEntry = this.getIndexEntry(null, 22);
                if (indexEntry != null) break block5;
                return null;
            }
            data = this.localDataRecordStore.getRecord(indexEntry.getRecordId());
            if (data != null) break block6;
            return null;
        }
        try {
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
            return dataStream.readUTF();
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int storeBetScreenLine3(String betScreenLine3, int recordId) throws ApplicationException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            dataStream.writeUTF(betScreenLine3);
            dataStream.flush();
            if (recordId > 0) {
                this.localDataRecordStore.setRecord(recordId, stream.toByteArray(), 0, stream.size());
            } else {
                recordId = this.localDataRecordStore.addRecord(stream.toByteArray(), 0, stream.size());
            }
            return recordId;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int storeAccountInfo(AccountInfo accInfo, int recordId) throws ApplicationException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            accInfo.serialize(dataStream);
            dataStream.flush();
            if (recordId > 0) {
                this.localDataRecordStore.setRecord(recordId, stream.toByteArray(), 0, stream.size());
            } else {
                recordId = this.localDataRecordStore.addRecord(stream.toByteArray(), 0, stream.size());
            }
            return recordId;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public AccountInfo loadLoginInfo() throws ApplicationException {
        IndexEntry indexEntry;
        block3: {
            try {
                indexEntry = this.getIndexEntry(null, 5);
                if (indexEntry != null) break block3;
                return null;
            }
            catch (RecordStoreException rse) {
                rse.printStackTrace();
                throw new ApplicationException((Exception)((Object)rse));
            }
        }
        byte[] data = this.localDataRecordStore.getRecord(indexEntry.getRecordId());
        return AccountInfo.deserialize(new DataInputStream(new ByteArrayInputStream(data)));
    }

    public DateObject[] loadSubmittedDates() throws ApplicationException {
        IndexEntry indexEntry;
        block5: {
            indexEntry = this.getIndexEntry("*", 9);
            if (indexEntry != null) break block5;
            return null;
        }
        try {
            byte[] data = this.remoteDataRecordStore.getRecord(indexEntry.getRecordId());
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
            int count = dataStream.readInt();
            DateObject[] submittedDates = new DateObject[count];
            int i = 0;
            while (i < count) {
                submittedDates[i] = DateObject.deserialize(dataStream);
                ++i;
            }
            return submittedDates;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int storeSubmittedDates(DateObject[] dates, int recordId) throws ApplicationException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            dataStream.writeInt(dates.length);
            int i = 0;
            while (i < dates.length) {
                dates[i].serialize(dataStream);
                ++i;
            }
            dataStream.flush();
            if (recordId > 0) {
                this.remoteDataRecordStore.setRecord(recordId, stream.toByteArray(), 0, stream.size());
            } else {
                recordId = this.remoteDataRecordStore.addRecord(stream.toByteArray(), 0, stream.size());
            }
            return recordId;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public DateObject[] loadPastDrawDates() throws ApplicationException {
        IndexEntry indexEntry;
        block5: {
            indexEntry = this.getIndexEntry("*", 10);
            if (indexEntry != null) break block5;
            return null;
        }
        try {
            byte[] data = this.remoteDataRecordStore.getRecord(indexEntry.getRecordId());
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
            int count = dataStream.readInt();
            DateObject[] drawDates = new DateObject[count];
            int i = 0;
            while (i < count) {
                drawDates[i] = DateObject.deserialize(dataStream);
                ++i;
            }
            return drawDates;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int storePastDrawDates(DateObject[] dates, int recordId) throws ApplicationException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            dataStream.writeInt(dates.length);
            int i = 0;
            while (i < dates.length) {
                dates[i].serialize(dataStream);
                ++i;
            }
            dataStream.flush();
            if (recordId > 0) {
                this.remoteDataRecordStore.setRecord(recordId, stream.toByteArray(), 0, stream.size());
            } else {
                recordId = this.remoteDataRecordStore.addRecord(stream.toByteArray(), 0, stream.size());
            }
            return recordId;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int getCurrentRunningNumber() throws ApplicationException {
        try {
            int currBatchNo = -1;
            IndexEntry indexEntry = this.getIndexEntry("*", 11);
            if (indexEntry != null) {
                byte[] data = this.localDataRecordStore.getRecord(indexEntry.getRecordId());
                DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
                currBatchNo = dataStream.readInt();
            }
            return currBatchNo;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int getNextRunningNumber() throws ApplicationException {
        try {
            int nextBatchNo = -1;
            IndexEntry indexEntry = this.getIndexEntry("*", 11);
            if (indexEntry != null) {
                byte[] data = this.localDataRecordStore.getRecord(indexEntry.getRecordId());
                DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
                nextBatchNo = dataStream.readInt() + 1;
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                DataOutputStream outDataStream = new DataOutputStream(outStream);
                outDataStream.writeInt(nextBatchNo);
                outDataStream.flush();
                this.localDataRecordStore.setRecord(indexEntry.getRecordId(), outStream.toByteArray(), 0, outStream.size());
            }
            return nextBatchNo;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public void deductRunningNumberByOne() throws ApplicationException {
        try {
            IndexEntry indexEntry = this.getIndexEntry("*", 11);
            if (indexEntry != null) {
                byte[] data = this.localDataRecordStore.getRecord(indexEntry.getRecordId());
                DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
                int batchNo = dataStream.readInt() - 1;
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                DataOutputStream outDataStream = new DataOutputStream(outStream);
                outDataStream.writeInt(batchNo);
                outDataStream.flush();
                this.localDataRecordStore.setRecord(indexEntry.getRecordId(), outStream.toByteArray(), 0, outStream.size());
            }
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int storeLastRunningNumber(int lastRunningNumber) throws ApplicationException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            dataStream.writeInt(lastRunningNumber);
            dataStream.flush();
            IndexEntry indexEntry = this.getIndexEntry("*", 11);
            if (indexEntry == null) {
                int recordId = this.localDataRecordStore.addRecord(stream.toByteArray(), 0, stream.size());
                indexEntry = new IndexEntry(recordId, 11, "*");
                this.addIndexEntry(indexEntry);
                return recordId;
            }
            this.localDataRecordStore.setRecord(indexEntry.getRecordId(), stream.toByteArray(), 0, stream.size());
            return indexEntry.getRecordId();
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public boolean loadTerminatedFlag() throws ApplicationException {
        IndexEntry indexEntry;
        block4: {
            indexEntry = this.getIndexEntry("*", 20);
            if (indexEntry != null) break block4;
            return false;
        }
        try {
            byte[] data = this.remoteDataRecordStore.getRecord(indexEntry.getRecordId());
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
            return dataStream.readBoolean();
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int storeTerminatedFlag(boolean isTerminated, int recordId) throws ApplicationException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            dataStream.writeBoolean(isTerminated);
            dataStream.flush();
            if (recordId > 0) {
                this.remoteDataRecordStore.setRecord(recordId, stream.toByteArray(), 0, stream.size());
            } else {
                recordId = this.remoteDataRecordStore.addRecord(stream.toByteArray(), 0, stream.size());
            }
            return recordId;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public String loadBluetoothAddress() throws ApplicationException {
        byte[] data;
        block6: {
            IndexEntry indexEntry;
            block5: {
                indexEntry = this.getIndexEntry(null, 23);
                if (indexEntry != null) break block5;
                return null;
            }
            data = this.localDataRecordStore.getRecord(indexEntry.getRecordId());
            if (data != null) break block6;
            return null;
        }
        try {
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
            return dataStream.readUTF();
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }

    public int storeBluetoothAddress(String address, int recordId) throws ApplicationException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            dataStream.writeUTF(address);
            dataStream.flush();
            if (recordId > 0) {
                this.localDataRecordStore.setRecord(recordId, stream.toByteArray(), 0, stream.size());
            } else {
                recordId = this.localDataRecordStore.addRecord(stream.toByteArray(), 0, stream.size());
            }
            return recordId;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            throw new ApplicationException((Exception)((Object)rse));
        }
    }
}

