/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.model;

import com.cloudy.client.midp.ApplicationException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateObject {
    public static final String FORWARD_SLASH = "/";
    public static final String ZERO = "0";
    public static final String WEEK_DAY_MON = "Mon";
    public static final String WEEK_DAY_TUE = "Tue";
    public static final String WEEK_DAY_WED = "Wed";
    public static final String WEEK_DAY_THU = "Thu";
    public static final String WEEK_DAY_FRI = "Fri";
    public static final String WEEK_DAY_SAT = "Sat";
    public static final String WEEK_DAY_SUN = "Sun";
    private Date date;

    public DateObject(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getString() {
        System.out.println("Date : " + this.date);
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        c.setTime(this.date);
        System.out.println("Calendar : " + c);
        StringBuffer sb = new StringBuffer();
        int day = c.get(5);
        if (day < 10) {
            sb.append(ZERO).append(day).append(FORWARD_SLASH);
        } else {
            sb.append(day).append(FORWARD_SLASH);
        }
        int month = c.get(2) + 1;
        if (month < 10) {
            sb.append(ZERO).append(month).append(FORWARD_SLASH);
        } else {
            sb.append(month).append(FORWARD_SLASH);
        }
        sb.append(c.get(1)).append(" (");
        int weekDay = c.get(7);
        switch (weekDay) {
            case 2: {
                sb.append(WEEK_DAY_MON);
                break;
            }
            case 3: {
                sb.append(WEEK_DAY_TUE);
                break;
            }
            case 4: {
                sb.append(WEEK_DAY_WED);
                break;
            }
            case 5: {
                sb.append(WEEK_DAY_THU);
                break;
            }
            case 6: {
                sb.append(WEEK_DAY_FRI);
                break;
            }
            case 7: {
                sb.append(WEEK_DAY_SAT);
                break;
            }
            case 1: {
                sb.append(WEEK_DAY_SUN);
                break;
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public String getShortString() {
        Calendar c = Calendar.getInstance();
        c.setTime(this.date);
        StringBuffer sb = new StringBuffer();
        int day = c.get(5);
        if (day < 10) {
            sb.append(ZERO).append(day).append(FORWARD_SLASH);
        } else {
            sb.append(day).append(FORWARD_SLASH);
        }
        int month = c.get(2) + 1;
        if (month < 10) {
            sb.append(ZERO).append(month).append(FORWARD_SLASH);
        } else {
            sb.append(month).append(FORWARD_SLASH);
        }
        sb.append(c.get(1));
        return sb.toString();
    }

    public int getDayOfWeek() {
        Calendar c = Calendar.getInstance();
        c.setTime(this.date);
        return c.get(7);
    }

    public int getDayOfMonth() {
        Calendar c = Calendar.getInstance();
        c.setTime(this.date);
        return c.get(5);
    }

    public int getMonth() {
        Calendar c = Calendar.getInstance();
        c.setTime(this.date);
        return c.get(2);
    }

    public int getYear() {
        Calendar c = Calendar.getInstance();
        c.setTime(this.date);
        return c.get(1);
    }

    public void serialize(DataOutputStream dataStream) throws ApplicationException {
        try {
            dataStream.writeLong(this.date.getTime());
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
    }

    public static DateObject deserialize(DataInputStream dataStream) throws ApplicationException {
        try {
            long time = dataStream.readLong();
            return new DateObject(new Date(time));
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
    }
}

