/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.message;

import com.cloudy.client.midp.ApplicationException;
import com.cloudy.client.midp.message.Message;
import com.cloudy.client.midp.message.ResponseMessage;

public class LoginResponseMessage
extends ResponseMessage {
    private String agentId = null;
    private byte[] agentKey = null;
    private int currentRunningNumber = -1;
    private String buyMethod = null;
    private String loginSequence = null;
    private int inputMethod = 1;
    private String betScreenLine2 = null;
    private String betScreenLine3 = null;
    private String serverDateTime = null;

    public LoginResponseMessage(Message context, String rawResponse) throws ApplicationException {
        super(context);
        this.parseResponse(rawResponse);
    }

    protected void parseResponse(String rawResponse) throws ApplicationException {
        char secondChar;
        if (rawResponse == null || rawResponse.trim().length() == 0) {
            throw new ApplicationException(1003);
        }
        char firstChar = rawResponse.charAt(0);
        if (firstChar == 'S') {
            this.status = 1;
        } else if (firstChar == 'F') {
            this.status = 2;
        } else {
            throw new ApplicationException(1003);
        }
        if (rawResponse.length() > 1 && '~' != (secondChar = rawResponse.charAt(1))) {
            throw new ApplicationException(1003);
        }
        if (this.status == 1) {
            String plaintext = null;
            if (rawResponse.length() > 1) {
                try {
                    plaintext = new String(rawResponse.substring(2));
                }
                catch (Exception e) {
                    throw new ApplicationException(1003, "Unable to decrypt response");
                }
            }
            this.parseSuccessResponse(plaintext);
        } else if (this.status == 2) {
            this.parseErrorResponse(rawResponse);
        }
    }

    protected void parseSuccessResponse(String plaintext) throws ApplicationException {
        try {
            int idx = plaintext.indexOf(126);
            if (idx == -1) {
                throw new ApplicationException(1003, "Delimiter not found");
            }
            this.agentId = plaintext.substring(0, idx);
            int idx1 = plaintext.indexOf(126, idx + 1);
            if (idx1 == -1) {
                throw new ApplicationException(1003, "Delimiter not found");
            }
            try {
                this.currentRunningNumber = Integer.parseInt(plaintext.substring(idx + 1, idx1));
            }
            catch (NumberFormatException e) {
                throw new ApplicationException(1003, "Invalid running number");
            }
            this.buyMethod = plaintext.substring(idx1 + 1, idx1 + 2);
            int idx2 = plaintext.indexOf(126, idx1 + 3);
            if (idx2 == -1) {
                throw new ApplicationException(1003, "Delimiter not found");
            }
            String s = plaintext.substring(idx1 + 3, idx2);
            s = s.replace('\r', ' ');
            s = s.replace('\n', ' ');
            this.loginSequence = s = s.trim();
            int idx3 = plaintext.indexOf(126, idx2 + 1);
            if (idx3 == -1) {
                throw new ApplicationException(1003, "Delimiter not found");
            }
            this.inputMethod = Integer.parseInt(plaintext.substring(idx2 + 1, idx3).trim());
            int idx4 = plaintext.indexOf(126, idx3 + 1);
            if (idx4 == -1) {
                throw new ApplicationException(1003, "Delimiter not found");
            }
            this.betScreenLine2 = plaintext.substring(idx3 + 1, idx4);
            this.betScreenLine3 = plaintext.substring(idx4 + 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApplicationException(1003);
        }
    }

    public String getAgentId() {
        return this.agentId;
    }

    public byte[] getAgentKey() {
        return this.agentKey;
    }

    public int getCurrentRunningNumber() {
        return this.currentRunningNumber;
    }

    public String getBuyMethod() {
        return this.buyMethod;
    }

    public String getLoginSequence() {
        return this.loginSequence;
    }

    public int getInputMethod() {
        return this.inputMethod;
    }

    public String getBetScreenLine2() {
        return this.betScreenLine2;
    }

    public String getBetScreenLine3() {
        return this.betScreenLine3;
    }

    public String getServerDateTime() {
        return this.serverDateTime;
    }
}

