/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.game;

import com.cloudy.client.midp.game.Grid;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class MazeCanvas
extends Canvas {
    public static final int BLACK = 0;
    public static final int WHITE = 0xFFFFFF;
    private Display myDisplay;
    private Grid myGrid;
    private boolean myGameOver = false;
    private int mySquareSize;
    private int myMaxSquareSize;
    private int myMinSquareSize;
    private int myStartX = 0;
    private int myStartY = 0;
    private int myGridHeight;
    private int myGridWidth;
    private int myMaxGridWidth;
    private int myMinGridWidth;
    private int myOldX = 1;
    private int myOldY = 1;
    private int myPlayerX = 1;
    private int myPlayerY = 1;

    int setColWidth(int colWidth) {
        this.mySquareSize = colWidth < 2 ? 2 : colWidth;
        this.myGridWidth = this.getWidth() / this.mySquareSize;
        if (this.myGridWidth % 2 == 0) {
            --this.myGridWidth;
        }
        this.myGridHeight = this.getHeight() / this.mySquareSize;
        if (this.myGridHeight % 2 == 0) {
            --this.myGridHeight;
        }
        this.myGrid = null;
        return this.myGridWidth;
    }

    int getMinColWidth() {
        return this.myMinSquareSize;
    }

    int getMaxColWidth() {
        return this.myMaxSquareSize;
    }

    int getMaxNumCols() {
        return this.myMaxGridWidth;
    }

    int getColWidth() {
        return this.mySquareSize;
    }

    int getNumCols() {
        return this.myGridWidth;
    }

    public MazeCanvas(Display d) throws Exception {
        this.myDisplay = d;
        int width = this.getWidth();
        int height = this.getHeight();
        this.mySquareSize = 5;
        this.myMinSquareSize = 3;
        this.myMaxGridWidth = width / this.myMinSquareSize;
        if (this.myMaxGridWidth % 2 == 0) {
            --this.myMaxGridWidth;
        }
        this.myGridWidth = width / this.mySquareSize;
        if (this.myGridWidth % 2 == 0) {
            --this.myGridWidth;
        }
        this.myGridHeight = height / this.mySquareSize;
        if (this.myGridHeight % 2 == 0) {
            --this.myGridHeight;
        }
        this.myMinGridWidth = 15;
        this.myMaxSquareSize = width / this.myMinGridWidth;
        if (this.myMaxSquareSize > height / this.myMinGridWidth) {
            this.myMaxSquareSize = height / this.myMinGridWidth;
        }
        if (this.myMaxSquareSize < this.mySquareSize) {
            throw new Exception("Display too small");
        }
    }

    void start() {
        this.myDisplay.setCurrent((Displayable)this);
        this.repaint();
    }

    void newMaze() {
        this.myGameOver = false;
        this.myGrid = null;
        this.myPlayerX = 1;
        this.myPlayerY = 1;
        this.myOldX = 1;
        this.myOldY = 1;
        this.myDisplay.setCurrent((Displayable)this);
        this.repaint();
    }

    protected void paint(Graphics g) {
        int height;
        int width;
        if (this.myGrid == null) {
            width = this.getWidth();
            height = this.getHeight();
            this.myGrid = new Grid(this.myGridWidth, this.myGridHeight);
            int i = 0;
            while (i < this.myGridWidth) {
                int j = 0;
                while (j < this.myGridHeight) {
                    if (this.myGrid.mySquares[i][j] == 0) {
                        g.setColor(0);
                    } else {
                        g.setColor(0xFFFFFF);
                    }
                    g.fillRect(this.myStartX + i * this.mySquareSize, this.myStartY + j * this.mySquareSize, this.mySquareSize, this.mySquareSize);
                    ++j;
                }
                ++i;
            }
            g.setColor(0);
            g.fillRect(this.myStartX + (this.myGridWidth - 1) * this.mySquareSize, this.myStartY, width, height);
            g.setColor(0xFFFFFF);
            g.fillRect(this.myStartX + (this.myGridWidth - 1) * this.mySquareSize, this.myStartY + (this.myGridHeight - 2) * this.mySquareSize, width, height);
            g.setColor(0);
            g.fillRect(this.myStartX, this.myStartY + (this.myGridHeight - 1) * this.mySquareSize, width, height);
        }
        g.setColor(255, 0, 0);
        g.fillRoundRect(this.myStartX + this.mySquareSize * this.myPlayerX, this.myStartY + this.mySquareSize * this.myPlayerY, this.mySquareSize, this.mySquareSize, this.mySquareSize, this.mySquareSize);
        if (this.myOldX != this.myPlayerX || this.myOldY != this.myPlayerY) {
            g.setColor(0xFFFFFF);
            g.fillRect(this.myStartX + this.mySquareSize * this.myOldX, this.myStartY + this.mySquareSize * this.myOldY, this.mySquareSize, this.mySquareSize);
        }
        if (this.myGameOver) {
            width = this.getWidth();
            height = this.getHeight();
            Font font = g.getFont();
            int fontHeight = font.getHeight();
            int fontWidth = font.stringWidth("Maze Completed");
            g.setColor(0xFFFFFF);
            g.fillRect((width - fontWidth) / 2, (height - fontHeight) / 2, fontWidth + 2, fontHeight);
            g.setColor(255, 0, 0);
            g.setFont(font);
            g.drawString("Maze Completed", (width - fontWidth) / 2, (height - fontHeight) / 2, 0x10 | 4);
        }
    }

    public void keyPressed(int keyCode) {
        if (!this.myGameOver) {
            int action = this.getGameAction(keyCode);
            switch (action) {
                case 2: {
                    if (this.myGrid.mySquares[this.myPlayerX - 1][this.myPlayerY] != 1 || this.myPlayerX == 1) break;
                    this.myOldX = this.myPlayerX;
                    this.myOldY = this.myPlayerY;
                    this.myPlayerX -= 2;
                    this.repaint();
                    break;
                }
                case 5: {
                    if (this.myGrid.mySquares[this.myPlayerX + 1][this.myPlayerY] == 1) {
                        this.myOldX = this.myPlayerX;
                        this.myOldY = this.myPlayerY;
                        this.myPlayerX += 2;
                        this.repaint();
                        break;
                    }
                    if (this.myPlayerX != this.myGrid.mySquares.length - 2 || this.myPlayerY != this.myGrid.mySquares[0].length - 2) break;
                    this.myOldX = this.myPlayerX;
                    this.myOldY = this.myPlayerY;
                    this.myPlayerX += 2;
                    this.myGameOver = true;
                    this.repaint();
                    break;
                }
                case 1: {
                    if (this.myGrid.mySquares[this.myPlayerX][this.myPlayerY - 1] != 1) break;
                    this.myOldX = this.myPlayerX;
                    this.myOldY = this.myPlayerY;
                    this.myPlayerY -= 2;
                    this.repaint();
                    break;
                }
                case 6: {
                    if (this.myGrid.mySquares[this.myPlayerX][this.myPlayerY + 1] != 1) break;
                    this.myOldX = this.myPlayerX;
                    this.myOldY = this.myPlayerY;
                    this.myPlayerY += 2;
                    this.repaint();
                }
            }
        }
    }
}

