/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.util;

import com.cloudy.client.midp.model.PrintDevice;
import com.cloudy.client.midp.ui.SetupPrinterUI;
import com.cloudy.client.midp.ui.UIController;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.microedition.lcdui.Displayable;

public class BTPrintClientSetup
implements DiscoveryListener {
    private UIController uiController;
    private SetupPrinterUI setupPrinterUI;
    private Vector remoteDevices;
    private LocalDevice localDevice;
    private DiscoveryAgent discoveryAgent;
    private ServiceRecord globalServiceRecord;
    private String connURL;
    private static final int READY = 0;
    private static final int DEVICE_SEARCH = 1;
    private static final int SERVICE_SEARCH = 2;
    private int state = 0;
    private int searchId = -1;
    final Object inquiryCompletedEvent = new Object();

    public BTPrintClientSetup(SetupPrinterUI setupPrinterUI, UIController uiController) {
        this.setupPrinterUI = setupPrinterUI;
        this.uiController = uiController;
        this.remoteDevices = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeviceSearch() {
        this.state = 1;
        this.remoteDevices.removeAllElements();
        try {
            Object object = this.inquiryCompletedEvent;
            synchronized (object) {
                this.localDevice = LocalDevice.getLocalDevice();
                this.discoveryAgent = this.localDevice.getDiscoveryAgent();
                boolean started = this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
                if (started) {
                    this.inquiryCompletedEvent.wait();
                } else {
                    this.uiController.showErrorAlert(this.uiController.getString(88), (Displayable)this.setupPrinterUI);
                }
            }
        }
        catch (BluetoothStateException e) {
            this.uiController.showErrorAlert(String.valueOf(this.uiController.getString(87)) + " : " + e.getMessage(), (Displayable)this.setupPrinterUI);
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            this.uiController.showErrorAlert(String.valueOf(this.uiController.getString(87)) + " : " + e.getMessage(), (Displayable)this.setupPrinterUI);
            e.printStackTrace();
        }
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        PrintDevice pd = null;
        try {
            String oDevName = "";
            String oUrl = "";
            String oConnUrl = "";
            oDevName = remoteDevice.getFriendlyName(false);
            oUrl = remoteDevice.getBluetoothAddress();
            this.remoteDevices.addElement(String.valueOf(oDevName) + "@" + "btspp://" + oUrl + ":1;authenticate=false;encrypt=false;master=false");
            oConnUrl = "btspp://" + oUrl + ":1;authenticate=false;encrypt=false;master=false";
            pd = new PrintDevice(oUrl, oDevName, remoteDevice, oConnUrl);
        }
        catch (Exception e) {
            pd = new PrintDevice(remoteDevice.getBluetoothAddress(), remoteDevice.getBluetoothAddress(), remoteDevice);
        }
        this.setupPrinterUI.appendDevice(pd, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inquiryCompleted(int discType) {
        if (discType == 0) {
            if (this.remoteDevices.size() == 0) {
                this.uiController.showInfoAlert(this.uiController.getString(90), (Displayable)this.setupPrinterUI);
            }
            this.setupPrinterUI.deviceSearchCompleted();
        } else if (discType == 5) {
            this.uiController.showInfoAlert(this.uiController.getString(91), (Displayable)this.setupPrinterUI);
            this.setupPrinterUI.deviceSearchCompleted();
        } else if (discType == 7) {
            this.uiController.showErrorAlert(this.uiController.getString(88), (Displayable)this.setupPrinterUI);
            this.setupPrinterUI.deviceSearchCompleted();
        }
        this.state = 0;
        Object object = this.inquiryCompletedEvent;
        synchronized (object) {
            this.inquiryCompletedEvent.notifyAll();
        }
    }

    public void doServiceSearch(RemoteDevice remoteDevice) {
        this.state = 2;
        this.searchId = 0;
        this.state = 0;
        this.setupPrinterUI.serviceSearchCompleted(this.connURL);
    }

    public void serviceSearchCompleted(int transID, int respCode) {
        this.state = 0;
        switch (respCode) {
            case 1: {
                this.setupPrinterUI.serviceSearchCompleted(this.connURL);
                break;
            }
            case 6: {
                this.uiController.showErrorAlert(this.uiController.getString(93), (Displayable)this.setupPrinterUI);
                break;
            }
            case 3: {
                this.uiController.showErrorAlert(this.uiController.getString(89), (Displayable)this.setupPrinterUI);
                break;
            }
            case 4: {
                this.uiController.showInfoAlert(this.uiController.getString(94), (Displayable)this.setupPrinterUI);
                break;
            }
            case 2: {
                this.uiController.showInfoAlert(this.uiController.getString(92), (Displayable)this.setupPrinterUI);
            }
        }
    }

    public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
        this.globalServiceRecord = servRecord[0];
        this.connURL = this.globalServiceRecord.getConnectionURL(0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSearch() {
        BTPrintClientSetup bTPrintClientSetup = this;
        synchronized (bTPrintClientSetup) {
            if (this.state == 1) {
                this.discoveryAgent.cancelInquiry((DiscoveryListener)this);
            } else if (this.state == 2) {
                this.discoveryAgent.cancelServiceSearch(this.searchId);
            }
        }
    }

    public final void a() {
        this.discoveryAgent.cancelInquiry((DiscoveryListener)this);
    }

    private int c() {
        try {
            this.localDevice = LocalDevice.getLocalDevice();
            this.localDevice.getBluetoothAddress();
        }
        catch (BluetoothStateException bluetoothStateException) {
            this.a();
            return -1;
        }
        return 0;
    }

    private int d() {
        this.discoveryAgent = this.localDevice.getDiscoveryAgent();
        try {
            this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
        }
        catch (Exception exception) {
            this.a();
            return -1;
        }
        return 0;
    }
}

