/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.util;

import com.cloudy.client.midp.ApplicationException;
import com.cloudy.client.midp.model.PrintDevice;
import com.cloudy.client.midp.model.Settings;
import com.cloudy.client.midp.ui.UIController;
import com.cloudy.client.midp.util.ProgressObserver;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Displayable;

public class BTPrintClient {
    protected static ProgressObserver progressObserver;
    private UIController uiController;
    private PrintDevice device;
    private Settings settings;
    private Displayable backUI;

    public BTPrintClient(UIController uiController, Displayable backUI, PrintDevice device, Settings settings) {
        this.backUI = backUI;
        this.uiController = uiController;
        this.device = device;
        this.settings = settings;
    }

    /*
     * Loose catch block
     */
    public void doPrint(String printData, boolean surpressSuccessMsg, int titleCode) {
        this.uiController.displayProgress(this.uiController.getString(19), true);
        StreamConnection conn = null;
        OutputStream outStream = null;
        try {
            try {
                BTPrintClient.updateProgress();
                conn = (StreamConnection)Connector.open((String)this.device.getConnectionURL());
                BTPrintClient.updateProgress();
                outStream = conn.openOutputStream();
                BTPrintClient.updateProgress();
                outStream.write(27);
                outStream.write(64);
                outStream.write(29);
                outStream.write(33);
                if (titleCode == 6) {
                    outStream.write(1);
                } else if (this.settings.getPrintfontSize() == 0) {
                    outStream.write(0);
                } else if (1 == this.settings.getPrintfontSize()) {
                    outStream.write(1);
                } else if (2 == this.settings.getPrintfontSize()) {
                    outStream.write(17);
                }
                outStream.write(printData.getBytes());
                outStream.write("\r\n".getBytes());
                outStream.flush();
                BTPrintClient.updateProgress();
                if (!surpressSuccessMsg) {
                    this.uiController.showInfoAlert(this.uiController.getString(95), this.backUI);
                } else {
                    this.uiController.setCurrent(this.backUI);
                }
            }
            catch (IOException ioe) {
                this.uiController.showInfoAlert(this.uiController.getString(93), this.backUI);
                ioe.printStackTrace();
                try {
                    if (outStream != null) {
                        outStream.close();
                        outStream = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (IOException iOException) {}
            }
            catch (ApplicationException ae) {
                this.uiController.setCurrent(this.backUI);
                try {
                    if (outStream != null) {
                        outStream.close();
                        outStream = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (IOException iOException) {}
            }
            catch (Exception ae) {
                this.uiController.showErrorAlert(this.uiController.getString(89), this.backUI);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (outStream != null) {
                        outStream.close();
                        outStream = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                    outStream = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void setProgressObserver(ProgressObserver progressObserver) {
        BTPrintClient.progressObserver = progressObserver;
    }

    protected static void updateProgress() throws ApplicationException {
        if (progressObserver != null) {
            if (!progressObserver.isStopped()) {
                progressObserver.updateProgress();
                return;
            }
            throw new ApplicationException(1000);
        }
    }
}

