/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.ui;

import com.cloudy.client.midp.ui.UIController;
import com.cloudy.client.midp.util.StandbyMonitor;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.TextField;

public class SearchContactUI
extends Form
implements CommandListener,
ItemStateListener {
    private static final String PREFIX_PLUS601 = "+601";
    private static final String PREFIX_601 = "601";
    private static final String PREFIX_01 = "01";
    private UIController uiController;
    private TextField mobileNoTextField;
    private Command addCommand;
    private Command backCommand;

    public SearchContactUI(UIController uiController) {
        super(uiController.getString(21));
        this.uiController = uiController;
        this.mobileNoTextField = new TextField(uiController.getString(23), null, 12, 3);
        this.addCommand = new Command(uiController.getString(125), 1, 5);
        this.backCommand = new Command(uiController.getString(26), 2, 10);
        this.append((Item)this.mobileNoTextField);
        this.addCommand(this.addCommand);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
        this.setItemStateListener(this);
        if (this.mobileNoTextField != null) {
            this.mobileNoTextField.setString(null);
        }
    }

    public void init() {
        if (this.mobileNoTextField != null) {
            this.mobileNoTextField.setString(null);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        StandbyMonitor.reset();
        if (command == this.backCommand) {
            this.uiController.handleEvent(62);
        } else if (command == this.addCommand) {
            String errMsg = this.validateForm();
            if (errMsg != null) {
                this.uiController.showErrorAlert(errMsg, (Displayable)this);
                return;
            }
            String mobileNo = this.mobileNoTextField.getString();
            if (mobileNo.startsWith(PREFIX_PLUS601)) {
                mobileNo = mobileNo.substring(2);
            } else if (mobileNo.startsWith(PREFIX_601)) {
                mobileNo = mobileNo.substring(1);
            }
            this.uiController.handleEvent(63, new Object[]{mobileNo});
        }
    }

    private String validateForm() {
        if (this.mobileNoTextField.getString() != null && this.mobileNoTextField.getString().trim().length() == 0 || !this.mobileNoTextField.getString().startsWith(PREFIX_01) && !this.mobileNoTextField.getString().startsWith(PREFIX_601) && !this.mobileNoTextField.getString().startsWith(PREFIX_PLUS601)) {
            return this.uiController.getString(24);
        }
        return null;
    }

    public void itemStateChanged(Item item) {
        StandbyMonitor.reset();
    }
}

