/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.ui;

import com.cloudy.client.midp.ui.ConfirmationCallback;
import com.cloudy.client.midp.ui.ConfirmationUI;
import com.cloudy.client.midp.ui.UIController;
import com.cloudy.client.midp.util.StandbyMonitor;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import net.mypapit.java.StringTokenizer1;

public class LTTicketListUI
extends List
implements CommandListener {
    public static final String ACTION_CODE_GET_TICKET = "1";
    public static final String ACTION_CODE_DEL_TICKET = "2";
    private UIController uiController;
    private Command backCommand;
    private Command deleteCommand;
    private Vector transactions;
    private int delIndex = -1;
    private String delItemStr = null;
    private ConfirmationUI confirmationUI;

    public LTTicketListUI(UIController uiController) {
        super(uiController.getString(0), 3);
        this.uiController = uiController;
        this.setFitPolicy(1);
        this.deleteCommand = new Command(uiController.getString(139), 1, 5);
        this.backCommand = new Command(uiController.getString(26), 2, 10);
        this.addCommand(this.backCommand);
    }

    public void init() {
        this.uiController.handleEvent(76);
        this.setCommandListener(this);
    }

    public void updateItems(String txt) {
        this.transactions = new Vector();
        StringTokenizer1 st = new StringTokenizer1(txt.trim(), "~");
        while (st.hasMoreElements()) {
            this.transactions.addElement(st.nextElement());
        }
        if (this.transactions.size() == 0) {
            return;
        }
        this.addCommand(this.deleteCommand);
        this.deleteAll();
        int i = 0;
        while (i < this.transactions.size()) {
            this.append(this.getTransactionDisplayString(i), null);
            ++i;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        StandbyMonitor.reset();
        if (command != List.SELECT_COMMAND) {
            if (command == this.deleteCommand) {
                this.delIndex = this.getSelectedIndex();
                this.delItemStr = this.getTransactionSelectID(this.delIndex);
                if (this.confirmationUI == null) {
                    this.confirmationUI = new ConfirmationUI(this.uiController, this.uiController.getString(142), new ConfirmationCallback(){

                        public void confirmNo() {
                            LTTicketListUI.this.uiController.setCurrent((Displayable)LTTicketListUI.this);
                        }

                        public void confirmYes() {
                            LTTicketListUI.this.uiController.handleEvent(77, new Object[]{LTTicketListUI.this.delItemStr, Integer.toString(LTTicketListUI.this.delIndex)});
                        }
                    });
                }
                this.uiController.setCurrent((Displayable)this.confirmationUI);
            } else if (command == this.backCommand) {
                this.uiController.handleEvent(78);
            }
        }
    }

    private String getTransactionDisplayString(int index) {
        String transaction = (String)this.transactions.elementAt(index);
        StringBuffer displayStr = new StringBuffer();
        String row = null;
        int running = 1;
        StringTokenizer1 st = new StringTokenizer1(transaction.trim(), "|");
        while (st.hasMoreElements()) {
            row = (String)st.nextElement();
            if (running <= 3) {
                displayStr.append(row).append("\n");
            }
            ++running;
        }
        String str = displayStr.toString();
        return str;
    }

    private String getTransactionSelectID(int index) {
        String item = (String)this.transactions.elementAt(index);
        StringTokenizer1 st = new StringTokenizer1(item.trim(), "|");
        String row = null;
        if (st.hasMoreElements()) {
            row = (String)st.nextElement();
        }
        return row;
    }

    public void delTicketResp(boolean success, String index) {
        if (success) {
            this.transactions.removeElementAt(Integer.parseInt(index));
            this.delete(Integer.parseInt(index));
            if (this.transactions.size() == 0) {
                this.removeCommand(this.deleteCommand);
            }
        }
    }
}

