/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class IndexEntry {
    public static final int TYPE_ANY = -1;
    public static final int TYPE_RESOURCE_BUNDLE = 0;
    public static final int TYPE_ACTIVATION = 1;
    public static final int TYPE_VERSION = 2;
    public static final int TYPE_SERVICE_URL = 3;
    public static final int TYPE_AGENT_ID = 4;
    public static final int TYPE_ACCOUNT_INFO = 5;
    public static final int TYPE_INIT_PARAM = 6;
    public static final int TYPE_INIT_PARAM_EXPIRY_DAY = 7;
    public static final int TYPE_ALLOWED_DRAW_DATES_STR = 8;
    public static final int TYPE_SUBMITTED_DRAW_DATES = 9;
    public static final int TYPE_PAST_DRAW_DATES = 10;
    public static final int TYPE_RUNNING_NO = 11;
    public static final int TYPE_BUY_METHOD = 12;
    public static final int TYPE_USER_ID = 13;
    public static final int TYPE_STANDBY_PWD = 14;
    public static final int TYPE_SETTINGS = 15;
    public static final int TYPE_PRINT_DEVICE = 16;
    public static final int TYPE_INPUT_METHOD = 17;
    public static final int TYPE_LOGIN_SEQUENCE = 18;
    public static final int TYPE_UPDATE_URL = 19;
    public static final int TYPE_TERMINATED_FLAG = 20;
    public static final int TYPE_BET_SCREEN_LINE_2 = 21;
    public static final int TYPE_BET_SCREEN_LINE_3 = 22;
    public static final int TYPE_BLUETOOTH_ADDRESS = 23;
    public static final int TYPE_USER_URL = 24;
    public static final int TYPE_SERVICE_HIDEURL = 25;
    public static final int TYPE_URL_TYPE = 26;
    private int type;
    private String key;
    private int recordId;
    private long expirationDate;

    public IndexEntry(int recordId, int type, String key) {
        this.recordId = recordId;
        this.type = type;
        this.key = key;
    }

    private IndexEntry() {
    }

    public int getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(long expirationDate) {
        this.expirationDate = expirationDate;
    }

    public int getRecordId() {
        return this.recordId;
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        dataStream.writeInt(this.type);
        dataStream.writeUTF(this.key);
        dataStream.writeInt(this.recordId);
        dataStream.writeLong(this.expirationDate);
        return byteStream.toByteArray();
    }

    public static IndexEntry deserialize(byte[] data) throws IOException {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
        DataInputStream dataStream = new DataInputStream(byteStream);
        IndexEntry indexEntry = new IndexEntry();
        indexEntry.type = dataStream.readInt();
        indexEntry.key = dataStream.readUTF();
        indexEntry.recordId = dataStream.readInt();
        indexEntry.expirationDate = dataStream.readLong();
        return indexEntry;
    }

    public static boolean matches(byte[] data, String key, int type) throws IOException {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
        DataInputStream dataStream = new DataInputStream(byteStream);
        return !(type != dataStream.readInt() && type != -1 || !dataStream.readUTF().equals(key) && key != null);
    }
}

