/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.model;

import com.cloudy.client.midp.ApplicationException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class Batch {
    private String agentId;
    private int batchNo;
    private String mobileNo;
    private Vector transaction;

    public Batch() {
    }

    public Batch(String agentId, int batchNo, String mobileNo, Vector transaction) {
        this.agentId = agentId;
        this.batchNo = batchNo;
        this.mobileNo = mobileNo;
        this.transaction = transaction;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public int getBatchNo() {
        return this.batchNo;
    }

    public void setBatchNo(int batchNo) {
        this.batchNo = batchNo;
    }

    public Vector getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Vector transaction) {
        this.transaction = transaction;
    }

    public String getMobileNo() {
        return this.mobileNo;
    }

    public void setMobileNo(String mobileNo) {
        this.mobileNo = mobileNo;
    }

    public void serialize(DataOutputStream dataStream) throws ApplicationException {
        try {
            dataStream.writeUTF(this.agentId);
            dataStream.writeInt(this.batchNo);
            dataStream.writeUTF(this.mobileNo);
            dataStream.writeInt(this.transaction.size());
            int i = 0;
            while (i < this.transaction.size()) {
                dataStream.writeUTF((String)this.transaction.elementAt(i));
                ++i;
            }
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
    }

    public static Batch deserialize(DataInputStream dataStream) throws ApplicationException {
        try {
            Batch batch = new Batch();
            batch.setAgentId(dataStream.readUTF());
            batch.setBatchNo(dataStream.readInt());
            batch.setMobileNo(dataStream.readUTF());
            int size = dataStream.readInt();
            Vector<String> transaction = new Vector<String>(size);
            int i = 0;
            while (i < size) {
                transaction.addElement(dataStream.readUTF());
                ++i;
            }
            batch.setTransaction(transaction);
            return batch;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
    }
}

