/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.message;

import com.cloudy.client.midp.ApplicationException;
import com.cloudy.client.midp.message.Message;
import com.cloudy.client.midp.util.URLEncoder;
import java.io.IOException;

public abstract class RequestMessage
extends Message {
    public static final String CONST_EQUAL = "=";
    public static final String CONST_AMPERSAND = "&";
    public static final String CONST_DELIMITER = "~";
    public static final String PARAM_DATA = "e";
    protected String agentId = null;
    protected String version = null;

    public RequestMessage(String version, String agentId) {
        this.version = version;
        this.agentId = agentId;
    }

    public String getPostData() throws ApplicationException {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(PARAM_DATA).append(CONST_EQUAL).append(URLEncoder.encode(this.getEncodedData()));
        }
        catch (IOException e) {
            throw new ApplicationException("Problem perform url encoding");
        }
        return sb.toString();
    }

    protected abstract String getRawDataFields();

    protected String getEncodedData() throws ApplicationException {
        String result = null;
        try {
            result = new String(this.getRawDataFields().getBytes());
        }
        catch (Exception e) {
            throw new ApplicationException("Problem encrypting data");
        }
        return result;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getVersion() {
        return this.version;
    }
}

