/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.message;

import com.cloudy.client.midp.ApplicationException;
import com.cloudy.client.midp.message.Message;
import com.cloudy.client.midp.message.ResponseMessage;

public class GetServerSettingsResponseMessage
extends ResponseMessage {
    private String inputMethodList;
    private String currentInputMethodValue;
    private String betTypeList;
    private String currentBetType;

    public GetServerSettingsResponseMessage(Message context, String rawResponse) throws ApplicationException {
        super(context);
        this.parseResponse(rawResponse);
    }

    protected void parseSuccessResponse(String plaintext) throws ApplicationException {
        try {
            int idx = plaintext.indexOf(126);
            if (idx == -1) {
                throw new ApplicationException(1003, "Delimiter not found");
            }
            this.inputMethodList = plaintext.substring(0, idx);
            int idx2 = plaintext.indexOf(126, idx + 1);
            if (idx2 == -1) {
                throw new ApplicationException(1003, "Delimiter not found");
            }
            this.currentInputMethodValue = plaintext.substring(idx + 1, idx2);
            int idx3 = plaintext.indexOf(126, idx2 + 1);
            if (idx3 == -1) {
                throw new ApplicationException(1003, "Delimiter not found");
            }
            this.betTypeList = plaintext.substring(idx2 + 1, idx3);
            this.currentBetType = plaintext.substring(idx3 + 1);
        }
        catch (NumberFormatException e) {
            throw new ApplicationException(1003, "Invalid transaction number");
        }
        catch (Exception e) {
            throw new ApplicationException(1003);
        }
    }

    public String getInputMethodList() {
        return this.inputMethodList;
    }

    public String getCurrentInputMethodValue() {
        return this.currentInputMethodValue;
    }

    public String getBetTypeList() {
        return this.betTypeList;
    }

    public String getCurrentBetType() {
        return this.currentBetType;
    }
}

