/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.game;

import com.cloudy.client.midp.Cloudy;
import com.cloudy.client.midp.game.MazeCanvas;
import com.cloudy.client.midp.game.SelectScreen;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDletStateChangeException;

public class Maze
implements CommandListener {
    private MazeCanvas myCanvas;
    private SelectScreen mySelectScreen;
    private Command myExitCommand = new Command("Exit", 7, 99);
    private Command myNewCommand = new Command("New Maze", 1, 1);
    private Command myAlertDoneCommand = new Command("Done", 7, 1);
    private Command myPrefsCommand = new Command("Size Preferences", 1, 1);
    private Cloudy midlet;
    private Display display;

    public Maze(Cloudy midlet, Display display) {
        try {
            this.midlet = midlet;
            this.display = display;
            this.myCanvas = new MazeCanvas(display);
            this.myCanvas.addCommand(this.myExitCommand);
            this.myCanvas.addCommand(this.myNewCommand);
            this.myCanvas.addCommand(this.myPrefsCommand);
            this.myCanvas.setCommandListener(this);
        }
        catch (Exception e) {
            Alert errorAlert = new Alert("error", e.getMessage(), null, AlertType.ERROR);
            errorAlert.setCommandListener((CommandListener)this);
            errorAlert.setTimeout(-2);
            errorAlert.addCommand(this.myAlertDoneCommand);
            display.setCurrent((Displayable)errorAlert);
        }
    }

    public void startApp() throws MIDletStateChangeException {
        if (this.myCanvas != null) {
            this.myCanvas.start();
        }
    }

    public void destroyApp(boolean unconditional) throws MIDletStateChangeException {
        this.myCanvas = null;
        System.gc();
    }

    public void pauseApp() {
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.myNewCommand) {
            this.myCanvas.newMaze();
        } else if (c == this.myAlertDoneCommand) {
            try {
                this.destroyApp(false);
                this.midlet.exit();
            }
            catch (MIDletStateChangeException mIDletStateChangeException) {}
        } else if (c == this.myPrefsCommand) {
            if (this.mySelectScreen == null) {
                this.mySelectScreen = new SelectScreen(this.myCanvas);
            }
            this.display.setCurrent((Displayable)this.mySelectScreen);
        } else if (c == this.myExitCommand) {
            try {
                this.destroyApp(false);
                this.midlet.exit();
            }
            catch (MIDletStateChangeException mIDletStateChangeException) {
                // empty catch block
            }
        }
    }
}

