/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.game;

import java.util.Random;
import java.util.Vector;

public class Grid {
    private Random myRandom = new Random();
    int[][] mySquares;

    public Grid(int width, int height) {
        this.mySquares = new int[width][height];
        int i = 1;
        while (i < width - 1) {
            int j = 1;
            while (j < height - 1) {
                if (i % 2 == 1 || j % 2 == 1) {
                    this.mySquares[i][j] = 1;
                }
                ++j;
            }
            ++i;
        }
        this.mySquares[0][1] = 1;
        this.createMaze();
    }

    private void createMaze() {
        int j;
        int i = 1;
        while (i < this.mySquares.length - 1) {
            j = 1;
            while (j < this.mySquares[i].length - 1) {
                if ((i + j) % 2 == 1) {
                    this.mySquares[i][j] = 0;
                }
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i < this.mySquares.length - 1) {
            j = 1;
            while (j < this.mySquares[i].length - 1) {
                this.mySquares[i][j] = 3;
                j += 2;
            }
            i += 2;
        }
        Vector<int[]> possibleSquares = new Vector<int[]>(this.mySquares.length * this.mySquares[0].length);
        int[] startSquare = new int[]{this.getRandomInt(this.mySquares.length / 2) * 2 + 1, this.getRandomInt(this.mySquares[0].length / 2) * 2 + 1};
        this.mySquares[startSquare[0]][startSquare[1]] = 2;
        possibleSquares.addElement(startSquare);
        while (possibleSquares.size() > 0) {
            int chosenIndex = this.getRandomInt(possibleSquares.size());
            int[] chosenSquare = (int[])possibleSquares.elementAt(chosenIndex);
            this.mySquares[chosenSquare[0]][chosenSquare[1]] = 1;
            possibleSquares.removeElementAt(chosenIndex);
            this.link(chosenSquare, possibleSquares);
        }
        possibleSquares = null;
        System.gc();
    }

    private void link(int[] chosenSquare, Vector possibleSquares) {
        int[] newSquare;
        int linkCount = 0;
        int i = chosenSquare[0];
        int j = chosenSquare[1];
        int[] links = new int[8];
        if (i >= 3) {
            if (this.mySquares[i - 2][j] == 1) {
                links[2 * linkCount] = i - 1;
                links[2 * linkCount + 1] = j;
                ++linkCount;
            } else if (this.mySquares[i - 2][j] == 3) {
                this.mySquares[i - 2][j] = 2;
                newSquare = new int[]{i - 2, j};
                possibleSquares.addElement(newSquare);
            }
        }
        if (j + 3 <= this.mySquares[i].length) {
            if (this.mySquares[i][j + 2] == 3) {
                this.mySquares[i][j + 2] = 2;
                newSquare = new int[]{i, j + 2};
                possibleSquares.addElement(newSquare);
            } else if (this.mySquares[i][j + 2] == 1) {
                links[2 * linkCount] = i;
                links[2 * linkCount + 1] = j + 1;
                ++linkCount;
            }
        }
        if (j >= 3) {
            if (this.mySquares[i][j - 2] == 3) {
                this.mySquares[i][j - 2] = 2;
                newSquare = new int[]{i, j - 2};
                possibleSquares.addElement(newSquare);
            } else if (this.mySquares[i][j - 2] == 1) {
                links[2 * linkCount] = i;
                links[2 * linkCount + 1] = j - 1;
                ++linkCount;
            }
        }
        if (i + 3 <= this.mySquares.length) {
            if (this.mySquares[i + 2][j] == 3) {
                this.mySquares[i + 2][j] = 2;
                newSquare = new int[]{i + 2, j};
                possibleSquares.addElement(newSquare);
            } else if (this.mySquares[i + 2][j] == 1) {
                links[2 * linkCount] = i + 1;
                links[2 * linkCount + 1] = j;
                ++linkCount;
            }
        }
        if (linkCount > 0) {
            int linkChoice = this.getRandomInt(linkCount);
            int linkX = links[2 * linkChoice];
            int linkY = links[2 * linkChoice + 1];
            this.mySquares[linkX][linkY] = 1;
            int[] removeSquare = new int[]{linkX, linkY};
            possibleSquares.removeElement(removeSquare);
        }
    }

    public int getRandomInt(int upper) {
        int retVal = this.myRandom.nextInt() % upper;
        if (retVal < 0) {
            retVal += upper;
        }
        return retVal;
    }
}

