/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp;

import com.cloudy.client.midp.ApplicationException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class IndexedResourceBundle {
    private String locale;
    private Hashtable resourcesHT;

    public IndexedResourceBundle() {
    }

    public IndexedResourceBundle(String locale, Hashtable resourcesHT) {
        this.locale = locale;
        this.resourcesHT = resourcesHT;
    }

    public String getString(String resourceId) {
        return (String)this.resourcesHT.get(resourceId);
    }

    public String getLocale() {
        return this.locale;
    }

    public int size() {
        return this.resourcesHT.size();
    }

    public void serialize(DataOutputStream out) throws ApplicationException {
        try {
            out.writeUTF(this.locale);
            out.writeInt(this.resourcesHT.size());
            Enumeration enum1 = this.resourcesHT.keys();
            String key = null;
            while (enum1.hasMoreElements()) {
                key = (String)enum1.nextElement();
                out.writeUTF(key);
                out.writeUTF((String)this.resourcesHT.get(key));
            }
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
    }

    public static IndexedResourceBundle deserialize(DataInputStream in) throws ApplicationException {
        try {
            String locale = in.readUTF();
            int size = in.readInt();
            Hashtable<String, String> resourceHT = new Hashtable<String, String>(size);
            int i = 0;
            while (i < size) {
                resourceHT.put(in.readUTF(), in.readUTF());
                ++i;
            }
            return new IndexedResourceBundle(locale, resourceHT);
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
    }

    public static IndexedResourceBundle getBundleFromPropertyFile(String locale, InputStream in) throws IOException {
        return IndexedResourceBundle.getBundleFromPropertyFile(locale, in, "");
    }

    public static IndexedResourceBundle getBundleFromPropertyFile(String locale, InputStream in, String base) throws IOException {
        Hashtable<String, String> resourcesHT = new Hashtable<String, String>();
        ByteArrayOutputStream out = null;
        try {
            int c;
            out = new ByteArrayOutputStream();
            int index = 0;
            while ((c = in.read()) != -1) {
                if (c == 10 || c == 13) {
                    String s = new String(out.toByteArray(), "UTF-8");
                    int i = s.indexOf(61);
                    if (i != -1) {
                        String key = s.substring(0, i);
                        String value = s.substring(i + 1).trim();
                        resourcesHT.put(key, value);
                        ++index;
                    }
                    out.reset();
                    continue;
                }
                out.write(c);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
        return new IndexedResourceBundle(locale, resourcesHT);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Contents of resource bundle: " + this.locale + "\n");
        Enumeration enum1 = this.resourcesHT.keys();
        String key = null;
        while (enum1.hasMoreElements()) {
            key = (String)enum1.nextElement();
            buffer.append(key);
            buffer.append('=');
            buffer.append((String)this.resourcesHT.get(key));
            buffer.append('\n');
        }
        return buffer.toString();
    }
}

