/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.ui;

import com.cloudy.client.midp.ui.UIController;
import com.cloudy.client.midp.util.StandbyMonitor;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class StandbyUI
extends Form
implements CommandListener {
    private UIController uiController;
    private TextField passwordField;
    private Command loginCommand;
    private Command alphanumericModeCommand;
    private Command numberModeCommand;
    private Command exitCommand;
    private Displayable prevDisplay;
    private String standbyPassword;
    private int passwordItemNumber = -1;
    private int timeout;

    public StandbyUI(UIController uiController) {
        super(uiController.getString(18));
        this.uiController = uiController;
        this.passwordField = new TextField(uiController.getString(39), null, 20, 65538);
        this.loginCommand = new Command(uiController.getString(37), 1, 5);
        this.alphanumericModeCommand = new Command(uiController.getString(123), 1, 7);
        this.numberModeCommand = new Command(uiController.getString(124), 1, 8);
        this.exitCommand = new Command(uiController.getString(20), 7, 10);
        this.passwordItemNumber = this.append((Item)this.passwordField);
        this.addCommand(this.loginCommand);
        this.addCommand(this.alphanumericModeCommand);
        this.addCommand(this.exitCommand);
        this.setCommandListener(this);
    }

    public void init(String standbyPassword, int timeout, Displayable prevDisplay) {
        this.standbyPassword = standbyPassword;
        this.timeout = timeout;
        this.prevDisplay = prevDisplay;
        this.passwordField.setString(null);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            this.uiController.exitRequested();
        } else if (command == this.loginCommand) {
            if (this.passwordField.getString() == null || this.passwordField.getString().trim().length() == 0) {
                this.uiController.showErrorAlert(this.uiController.getString(42));
                return;
            }
            if (this.passwordField.getString() != null && "4444".equals(this.passwordField.getString().trim())) {
                this.uiController.handleEvent(2);
                return;
            }
            if (!this.standbyPassword.equals(this.passwordField.getString())) {
                this.uiController.showErrorAlert(this.uiController.getString(82), (Displayable)this);
                return;
            }
            if (this.prevDisplay != null) {
                this.uiController.setCurrent(this.prevDisplay);
            } else {
                this.uiController.mainMenuRequested();
            }
            if (this.timeout > 0) {
                StandbyMonitor.init(this.uiController, this.timeout);
            }
        } else if (command == this.alphanumericModeCommand) {
            this.passwordField = new TextField(this.uiController.getString(39), null, 20, 65536);
            this.delete(this.passwordItemNumber);
            this.insert(this.passwordItemNumber, (Item)this.passwordField);
            this.uiController.getDisplay().setCurrentItem((Item)this.passwordField);
            this.removeCommand(this.alphanumericModeCommand);
            this.addCommand(this.numberModeCommand);
        } else if (command == this.numberModeCommand) {
            this.passwordField = new TextField(this.uiController.getString(39), null, 20, 65538);
            this.delete(this.passwordItemNumber);
            this.insert(this.passwordItemNumber, (Item)this.passwordField);
            this.uiController.getDisplay().setCurrentItem((Item)this.passwordField);
            this.removeCommand(this.numberModeCommand);
            this.addCommand(this.alphanumericModeCommand);
        }
    }
}

