/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.ui;

import com.cloudy.client.midp.ApplicationException;
import com.cloudy.client.midp.model.PrintDevice;
import com.cloudy.client.midp.ui.UIController;
import com.cloudy.client.midp.util.BTPrintClientSetup;
import com.cloudy.client.midp.util.ProgressObserver;
import com.cloudy.client.midp.util.StandbyMonitor;
import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.RemoteDevice;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

public class SetupPrinterUI
extends List
implements CommandListener {
    protected static ProgressObserver progressObserver;
    private UIController uiController;
    private Vector remoteDevices;
    private Vector printDevices;
    private BTPrintClientSetup btPrintClientSetup;
    private PrintDevice selectedDevice = null;
    private Command searchCommand;
    private Command stopCommand;
    private Command backCommand;

    public SetupPrinterUI(UIController uiController) {
        super(uiController.getString(85), 3);
        this.uiController = uiController;
        this.remoteDevices = new Vector();
        this.printDevices = new Vector();
        this.searchCommand = new Command(uiController.getString(30), 1, 5);
        this.stopCommand = new Command(uiController.getString(31), 1, 6);
        this.backCommand = new Command(uiController.getString(26), 2, 5);
        this.addCommand(this.searchCommand);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
    }

    public void startClient(ProgressObserver progressObserver) {
        this.deleteAll();
        SetupPrinterUI.progressObserver = progressObserver;
        this.btPrintClientSetup = new BTPrintClientSetup(this, this.uiController);
    }

    public void refresh(Vector printDevices, boolean done) {
        this.printDevices = printDevices;
        try {
            if (done) {
                this.removeCommand(this.stopCommand);
                this.addCommand(this.searchCommand);
                this.setTitle(this.uiController.getString(85));
            } else {
                this.removeCommand(this.searchCommand);
                this.addCommand(this.stopCommand);
                this.setTitle(this.uiController.getString(84));
            }
            String name = null;
            int i = 0;
            while (i < this.remoteDevices.size()) {
                RemoteDevice device = (RemoteDevice)this.remoteDevices.elementAt(i);
                try {
                    name = device.getFriendlyName(true);
                }
                catch (IOException ioe) {
                    name = device.getBluetoothAddress();
                }
                if (name == null || name.trim().length() == 0) {
                    name = device.getBluetoothAddress();
                }
                printDevices.addElement(new PrintDevice(device.getBluetoothAddress(), device.getFriendlyName(false)));
                this.append(name, null);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void appendDevice(PrintDevice printDevice, boolean done) {
        StandbyMonitor.reset();
        if (done) {
            this.removeCommand(this.stopCommand);
            this.addCommand(this.searchCommand);
            this.setTitle(this.uiController.getString(85));
        } else {
            this.removeCommand(this.searchCommand);
            this.addCommand(this.stopCommand);
            this.setTitle(this.uiController.getString(84));
        }
        if (printDevice != null) {
            this.printDevices.addElement(printDevice);
            this.append(printDevice.getDeviceName(), null);
        }
    }

    public void deviceSearchCompleted() {
        this.setTitle(this.uiController.getString(85));
        this.removeCommand(this.stopCommand);
        this.addCommand(this.searchCommand);
    }

    public void serviceSearchCompleted(String connURL) {
        connURL = this.selectedDevice.getConnectionURL();
        this.selectedDevice.setConnectionURL(connURL);
        this.uiController.handleEvent(47, new Object[]{this.selectedDevice});
    }

    public void commandAction(Command command, Displayable displayable) {
        StandbyMonitor.reset();
        if (command == List.SELECT_COMMAND) {
            this.uiController.displayProgress(this.uiController.getString(19), false);
            String deviceName = null;
            try {
                SetupPrinterUI.updateProgress();
                deviceName = this.getString(this.getSelectedIndex());
                int i = 0;
                while (i < this.printDevices.size()) {
                    if (deviceName.equals(((PrintDevice)this.printDevices.elementAt(i)).getDeviceName())) {
                        this.selectedDevice = (PrintDevice)this.printDevices.elementAt(i);
                        SetupPrinterUI.updateProgress();
                    }
                    ++i;
                }
                if (this.selectedDevice == null) {
                    this.uiController.showErrorAlert(String.valueOf(this.uiController.getString(86)) + " '" + deviceName + "'.");
                }
                SetupPrinterUI.updateProgress();
                this.btPrintClientSetup.doServiceSearch(this.selectedDevice.getRemoteDevice());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.uiController.showErrorAlert(String.valueOf(this.uiController.getString(86)) + " '" + deviceName + "'.");
            }
        } else if (command == this.searchCommand) {
            this.deleteAll();
            this.removeCommand(this.searchCommand);
            this.addCommand(this.stopCommand);
            this.setTitle(this.uiController.getString(84));
            this.btPrintClientSetup.doDeviceSearch();
        } else if (command == this.stopCommand) {
            this.btPrintClientSetup.cancelSearch();
        } else if (command == this.backCommand) {
            this.uiController.handleEvent(46);
        }
    }

    public static void setProgressObserver(ProgressObserver progressObserver) {
        SetupPrinterUI.progressObserver = progressObserver;
    }

    protected static void updateProgress() throws ApplicationException {
        if (progressObserver != null) {
            if (!progressObserver.isStopped()) {
                progressObserver.updateProgress();
                return;
            }
            throw new ApplicationException(1000);
        }
    }
}

