/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.ui;

import com.cloudy.client.midp.ui.UIController;
import com.cloudy.client.midp.util.StandbyMonitor;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.TextField;

public class SMSSetupUI
extends Form
implements CommandListener,
ItemStateListener {
    private UIController uiController;
    private TextField mobileNoTextField;
    private Command sendCommand;
    private Command backCommand;
    private Displayable backUI;
    private String transactionText;

    public SMSSetupUI(UIController uiController) {
        super(uiController.getString(21));
        this.uiController = uiController;
        this.mobileNoTextField = new TextField(uiController.getString(23), null, 12, 3);
        this.sendCommand = new Command(uiController.getString(22), 1, 5);
        this.backCommand = new Command(uiController.getString(26), 2, 10);
        this.append((Item)this.mobileNoTextField);
        this.addCommand(this.sendCommand);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
        this.setItemStateListener(this);
    }

    public void init(Displayable backUI, String transactionText, String mobileNo) {
        this.backUI = backUI;
        this.transactionText = transactionText;
        if (mobileNo != null) {
            this.mobileNoTextField.setString(mobileNo);
        } else {
            this.mobileNoTextField.setString(null);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        StandbyMonitor.reset();
        if (command == this.backCommand) {
            this.uiController.handleEvent(4, new Object[]{this.backUI});
        } else if (command == this.sendCommand) {
            String errMsg = this.validateForm();
            if (errMsg != null) {
                this.uiController.showErrorAlert(errMsg, (Displayable)this);
                return;
            }
            this.uiController.handleEvent(5, new Object[]{this.backUI, this.mobileNoTextField.getString(), this.transactionText});
        }
    }

    private String validateForm() {
        if (this.mobileNoTextField.getString() != null && this.mobileNoTextField.getString().trim().length() == 0) {
            return this.uiController.getString(24);
        }
        return null;
    }

    public void itemStateChanged(Item item) {
        StandbyMonitor.reset();
    }
}

