/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.ui;

import com.cloudy.client.midp.ui.UIController;
import com.cloudy.client.midp.util.StandbyMonitor;
import java.util.Date;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class BuyInputNoValidationCanvas
extends Canvas
implements CommandListener {
    private static final String SYMBOL_PIPE = "|";
    private static final String SYMBOL_DOUBLE_ASTERISK = "**";
    private static final String SYMBOL_HASH_ASTERISK_HASH = "#*#";
    private static final int COLOR_FOREGROUND = 0;
    private static final int COLOR_BACKGROUND = 0xFFFFFF;
    private final int KEY_CLEAR;
    public static Font INPUT_FONT = Font.getFont((int)0, (int)1, (int)16);
    public static int INPUT_FONT_HEIGHT = INPUT_FONT.getHeight();
    public static int INPUT_FONT_WIDTH = INPUT_FONT.stringWidth("#");
    public int MAX_DISPLAY_COLS = this.getWidth() / INPUT_FONT_WIDTH;
    public int MAX_DISPLAY_ROWS = this.getHeight() / (INPUT_FONT_HEIGHT + 1);
    private UIController uiController;
    private Display display;
    private Command agentCommand;
    private Command currencyCodeCommand;
    private Command addPhoneCommand;
    private Command submitCommand;
    private Command clearCommand;
    private Command backMenuCommand;
    private int maxRow;
    private Vector text;
    private boolean special;
    private String MycurrencyCode = "MYR";
    private StringBuffer invalidRowBuf = null;
    private int cursorRow = 0;
    private int cursorPos = 0;
    private int firstDisplayRow = 0;
    private int firstCharToDisplay = 0;
    private long keyPressTime = -1L;
    private long keyReleaseTime = -1L;

    public BuyInputNoValidationCanvas(UIController uiController) {
        this.KEY_CLEAR = -8;
        this.setTitle(uiController.getString(0));
        this.uiController = uiController;
        this.text = new Vector(7);
        this.text.addElement("");
        this.invalidRowBuf = new StringBuffer();
        this.submitCommand = new Command(uiController.getString(25), 1, 6);
        this.backMenuCommand = new Command(uiController.getString(129), 1, 7);
        this.addPhoneCommand = new Command(uiController.getString(125), 1, 8);
        this.clearCommand = new Command(uiController.getString(28), 3, 9);
        this.agentCommand = new Command(uiController.getString(147), 1, 10);
        this.currencyCodeCommand = new Command(uiController.getString(149), 1, 11);
        this.addCommand(this.submitCommand);
        this.addCommand(this.agentCommand);
        this.addCommand(this.currencyCodeCommand);
        this.addCommand(this.addPhoneCommand);
        this.addCommand(this.clearCommand);
        this.addCommand(this.backMenuCommand);
        this.setCommandListener(this);
    }

    public void init(Display display, String userId, String betScreenLine2, String betScreenLine3, int maxRow, boolean special) {
        this.display = display;
        this.maxRow = maxRow;
        this.special = special;
        this.invalidRowBuf = new StringBuffer();
        this.text.removeAllElements();
        this.text.addElement(userId);
        this.text.addElement(this.MycurrencyCode);
        this.text.addElement(betScreenLine2.trim());
        this.text.addElement(betScreenLine3 == null ? "" : betScreenLine3.trim());
        this.cursorRow = 3;
        this.cursorPos = betScreenLine3 == null || betScreenLine3.trim().length() == 0 ? 0 : betScreenLine3.trim().length();
        this.firstDisplayRow = 0;
    }

    public void init(Display display, String userId, int maxRow, String txt, boolean special) {
        this.maxRow = maxRow;
        this.special = special;
        this.invalidRowBuf = new StringBuffer();
        this.text.removeAllElements();
        this.cursorRow = 3;
        this.cursorPos = 0;
        this.firstDisplayRow = 0;
        this.text.addElement(userId);
        this.text.addElement(this.MycurrencyCode);
        int idx = -1;
        String txtTmp = new String(txt);
        String s = null;
        while ((idx = txtTmp.indexOf("\n")) != -1) {
            s = txtTmp.substring(0, idx);
            this.text.addElement(s);
            txtTmp = txtTmp.substring(idx + 1);
        }
        this.text.addElement(txtTmp.substring(idx + 1));
    }

    protected void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(0);
        this.drawText(g);
        this.drawCursor(g);
    }

    public void commandAction(Command command, Displayable displayable) {
        StandbyMonitor.reset();
        if (command == this.backMenuCommand) {
            this.uiController.handleEvent(9, null);
        } else if (command == this.submitCommand) {
            this.uiController.handleEvent(10, new Object[]{this.getTransaction(), new Boolean(this.special), this.MycurrencyCode});
        } else if (command == this.currencyCodeCommand) {
            this.uiController.handleEvent(81, new Object[]{this});
        } else if (command == this.agentCommand) {
            this.uiController.handleEvent(51, new Object[]{this});
        } else if (command == this.addPhoneCommand) {
            this.uiController.handleEvent(61, new Object[]{this});
        } else if (command == this.clearCommand) {
            this.deleteChar();
            this.repaint();
        }
    }

    protected void keyPressed(int keyCode) {
        StandbyMonitor.reset();
        switch (keyCode) {
            case 48: {
                this.addChar('0');
                this.repaint();
                break;
            }
            case 49: {
                this.addChar('1');
                this.repaint();
                break;
            }
            case 50: {
                this.addChar('2');
                this.repaint();
                break;
            }
            case 51: {
                this.addChar('3');
                this.repaint();
                break;
            }
            case 52: {
                this.addChar('4');
                this.repaint();
                break;
            }
            case 53: {
                this.addChar('5');
                this.repaint();
                break;
            }
            case 54: {
                this.addChar('6');
                this.repaint();
                break;
            }
            case 55: {
                this.addChar('7');
                this.repaint();
                break;
            }
            case 56: {
                this.addChar('8');
                this.repaint();
                break;
            }
            case 57: {
                this.addChar('9');
                this.repaint();
                break;
            }
            case 42: {
                System.out.println("Key Press : " + new Date().getTime());
                this.keyPressTime = new Date().getTime();
                break;
            }
            case 35: {
                this.addChar('#');
                this.repaint();
                break;
            }
            default: {
                int gameKeyCode = this.getGameAction(keyCode);
                if (gameKeyCode == 1) {
                    this.cursorMoveUp();
                } else if (gameKeyCode == 6) {
                    this.cursorMoveDown();
                } else if (gameKeyCode == 2) {
                    this.cursorMoveLeft();
                } else if (gameKeyCode == 5) {
                    this.cursorMoveRight();
                } else if (keyCode == -8) {
                    this.deleteChar();
                }
                this.repaint();
            }
        }
    }

    protected void keyReleased(int keyCode) {
        if (keyCode == 42) {
            this.keyReleaseTime = new Date().getTime();
            if (this.keyReleaseTime - this.keyPressTime > 500L) {
                this.addChar('+');
            } else {
                this.addChar('*');
            }
            this.repaint();
        }
    }

    public Vector getTransaction() {
        Vector<Object> tText = new Vector<Object>(7);
        tText.removeAllElements();
        int rowSize = this.text.size();
        Object[] array = new Object[rowSize];
        this.text.copyInto(array);
        int i = 0;
        while (i < rowSize) {
            if (i != 1) {
                tText.addElement(array[i]);
            }
            ++i;
        }
        return tText;
    }

    public void changeAgent(String agent) {
        if (agent == null || agent.trim().length() == 0) {
            return;
        }
        this.text.setElementAt(agent, 0);
        this.repaint();
    }

    public void changeCurrencyCode(String currencyCode) {
        if (currencyCode == null || currencyCode.trim().length() == 0) {
            return;
        }
        this.MycurrencyCode = currencyCode;
        this.text.setElementAt(currencyCode, 1);
        this.repaint();
    }

    public void addContact(String phoneNum, int inputMethod) {
        if (phoneNum == null || phoneNum.trim().length() == 0) {
            return;
        }
        if (this.text.size() > 0) {
            String lastRow = (String)this.text.elementAt(this.text.size() - 1);
            if (1 == inputMethod) {
                if (lastRow.startsWith(SYMBOL_DOUBLE_ASTERISK) || lastRow.trim().length() == 0) {
                    this.text.setElementAt(SYMBOL_DOUBLE_ASTERISK + phoneNum, this.text.size() - 1);
                } else {
                    this.text.addElement(SYMBOL_DOUBLE_ASTERISK + phoneNum);
                }
            } else if (3 == inputMethod) {
                if (lastRow.startsWith(SYMBOL_HASH_ASTERISK_HASH) || lastRow.trim().length() == 0) {
                    this.text.setElementAt(SYMBOL_HASH_ASTERISK_HASH + phoneNum, this.text.size() - 1);
                } else {
                    this.text.addElement(SYMBOL_HASH_ASTERISK_HASH + phoneNum);
                }
            } else if ((lastRow.startsWith("010") || lastRow.startsWith("011") || lastRow.startsWith("012") || lastRow.startsWith("013") || lastRow.startsWith("014") || lastRow.startsWith("015") || lastRow.startsWith("016") || lastRow.startsWith("017") || lastRow.startsWith("018") || lastRow.startsWith("019")) && (lastRow.trim().length() == 10 || lastRow.trim().length() == 11) && lastRow.indexOf("#") == -1 || lastRow.trim().length() == 0) {
                this.text.setElementAt(phoneNum, this.text.size() - 1);
            } else {
                this.text.addElement(phoneNum);
            }
        }
        this.repaint();
    }

    private void drawText(Graphics g) {
        int currHeight = 0;
        int start = this.firstDisplayRow;
        int end = this.firstDisplayRow + this.MAX_DISPLAY_ROWS - 1 < this.text.size() ? this.firstDisplayRow + this.MAX_DISPLAY_ROWS : this.text.size();
        this.firstCharToDisplay = 0;
        if (this.cursorPos > this.MAX_DISPLAY_COLS) {
            this.firstCharToDisplay = this.cursorPos - this.MAX_DISPLAY_COLS;
        }
        String invalidRow = this.invalidRowBuf.toString();
        g.setFont(INPUT_FONT);
        String s = null;
        int tmpHeight = 0;
        int rows = this.getHeight() / INPUT_FONT_HEIGHT;
        int i = 0;
        while (i < rows) {
            g.setColor(0);
            tmpHeight = tmpHeight + INPUT_FONT_HEIGHT + 1;
            g.drawLine(0, tmpHeight, this.getWidth(), tmpHeight);
            ++i;
        }
        i = start;
        while (i < end) {
            if (invalidRow.indexOf(String.valueOf(i) + SYMBOL_PIPE) != -1) {
                g.setColor(255, 0, 0);
            }
            if ((s = (String)this.text.elementAt(i)).length() < this.firstCharToDisplay) {
                s = "";
            } else if (this.firstCharToDisplay != 0) {
                s = s.substring(this.firstCharToDisplay);
            }
            g.drawString(s, 1, currHeight, 20);
            currHeight += INPUT_FONT_HEIGHT + 1;
            g.setColor(0);
            ++i;
        }
    }

    private void drawCursor(Graphics g) {
        String s = (String)this.text.elementAt(this.cursorRow);
        s = s.substring(0, this.cursorPos);
        if (this.cursorPos > this.MAX_DISPLAY_COLS) {
            s = s.substring(0, this.MAX_DISPLAY_COLS);
        }
        int x = INPUT_FONT.stringWidth(s) + 1;
        int y = -1;
        y = (INPUT_FONT_HEIGHT + 1) * (this.cursorRow - this.firstDisplayRow);
        g.drawLine(x, y, x, y + INPUT_FONT_HEIGHT);
    }

    private void cursorMoveUp() {
        System.out.println("v--- cursorMoveUp Before : cursorRow : " + this.cursorRow + ", cursorPos : " + this.cursorPos + ", firstDisplayRow : " + this.firstDisplayRow);
        if (this.cursorRow > 1) {
            --this.cursorRow;
        }
        if (this.firstDisplayRow > this.cursorRow) {
            this.firstDisplayRow = this.cursorRow;
        } else if (this.cursorRow == 1) {
            this.firstDisplayRow = 0;
        }
        int length = ((String)this.text.elementAt(this.cursorRow)).length();
        if (length - 1 < this.cursorPos) {
            this.cursorPos = length;
        }
        System.out.println("v--- cursorMoveUp : cursorRow : " + this.cursorRow + ", cursorPos : " + this.cursorPos + ", firstDisplayRow : " + this.firstDisplayRow);
    }

    private void cursorMoveDown() {
        int length;
        String s = (String)this.text.elementAt(this.cursorRow);
        if (s == null || s.trim().length() == 0 || this.cursorRow == this.maxRow - 1) {
            return;
        }
        if (this.cursorRow == this.text.size() - 1) {
            this.text.addElement("");
            ++this.cursorRow;
        } else if (this.cursorRow < this.text.size() - 1) {
            ++this.cursorRow;
        }
        if (this.firstDisplayRow + this.MAX_DISPLAY_ROWS <= this.cursorRow) {
            this.firstDisplayRow = this.cursorRow - this.MAX_DISPLAY_ROWS + 1;
        }
        if ((length = ((String)this.text.elementAt(this.cursorRow)).length()) - 1 < this.cursorPos) {
            this.cursorPos = length;
        }
        System.out.println("v--- cursorMoveDown : cursorRow : " + this.cursorRow + ", cursorPos : " + this.cursorPos + ", firstDisplayRow : " + this.firstDisplayRow);
    }

    private void cursorMoveLeft() {
        if (this.cursorPos > 0) {
            --this.cursorPos;
        }
    }

    private void cursorMoveRight() {
        String s = (String)this.text.elementAt(this.cursorRow);
        if (this.cursorPos < s.length()) {
            ++this.cursorPos;
        }
    }

    private void addChar(char c) {
        System.out.println("v--- addChar : c : " + c + ", cursorRow : " + this.cursorRow + ", cursorPos : " + this.cursorPos);
        StringBuffer sb = new StringBuffer((String)this.text.elementAt(this.cursorRow));
        sb.insert(this.cursorPos, c);
        this.text.setElementAt(sb.toString(), this.cursorRow);
        this.cursorMoveRight();
    }

    private void deleteChar() {
        System.out.println("v--- deleteChar : cursorRow : " + this.cursorRow + ", cursorPos : " + this.cursorPos);
        if (this.cursorPos > 0) {
            StringBuffer sb = new StringBuffer((String)this.text.elementAt(this.cursorRow));
            sb.deleteCharAt(this.cursorPos - 1);
            this.text.setElementAt(sb.toString(), this.cursorRow);
            this.cursorMoveLeft();
        } else if (this.cursorPos == 0 && this.cursorRow != 1) {
            int tmp = ((String)this.text.elementAt(this.cursorRow - 1)).length();
            this.text.removeElementAt(this.cursorRow);
            this.cursorRow = this.cursorRow == 0 ? 0 : this.cursorRow - 1;
            this.cursorPos = tmp;
        }
    }
}

