/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.model;

import com.cloudy.client.midp.ApplicationException;
import com.cloudy.client.midp.IndexedResourceBundle;
import com.cloudy.client.midp.message.AccountStatisticRequestMessage;
import com.cloudy.client.midp.message.AccountStatisticResponseMessage;
import com.cloudy.client.midp.message.AnnouncementRequestMessage;
import com.cloudy.client.midp.message.AnnouncementResponseMessage;
import com.cloudy.client.midp.message.BalanceRequestMessage;
import com.cloudy.client.midp.message.BalanceResponseMessage;
import com.cloudy.client.midp.message.BetManualRequestMessage;
import com.cloudy.client.midp.message.BetManualResponseMessage;
import com.cloudy.client.midp.message.BetRecordsRequestMessage;
import com.cloudy.client.midp.message.BetRecordsResponseMessage;
import com.cloudy.client.midp.message.Buy2RequestMessage;
import com.cloudy.client.midp.message.Buy2ResponseMessage;
import com.cloudy.client.midp.message.BuyRequestMessage;
import com.cloudy.client.midp.message.BuyResponseMessage;
import com.cloudy.client.midp.message.BuySpecial2RequestMessage;
import com.cloudy.client.midp.message.BuySpecial2ResponseMessage;
import com.cloudy.client.midp.message.BuySpecialRequestMessage;
import com.cloudy.client.midp.message.BuySpecialResponseMessage;
import com.cloudy.client.midp.message.ChangePasswordRequestMessage;
import com.cloudy.client.midp.message.ChangePasswordResponseMessage;
import com.cloudy.client.midp.message.CheckNewVersionRequestMessage;
import com.cloudy.client.midp.message.CheckNewVersionResponseMessage;
import com.cloudy.client.midp.message.CurrencyCodeRequestMessage;
import com.cloudy.client.midp.message.CurrencyCodeResponseMessage;
import com.cloudy.client.midp.message.FightNumWinningRequestMessage;
import com.cloudy.client.midp.message.FightNumWinningResponseMessage;
import com.cloudy.client.midp.message.GetCommonHeadRequestMessage;
import com.cloudy.client.midp.message.GetCommonHeadResponseMessage;
import com.cloudy.client.midp.message.GetServerSettingsRequestMessage;
import com.cloudy.client.midp.message.GetServerSettingsResponseMessage;
import com.cloudy.client.midp.message.GetServerTimeRequestMessage;
import com.cloudy.client.midp.message.GetServerTimeResponseMessage;
import com.cloudy.client.midp.message.LTTicketRequestMessage;
import com.cloudy.client.midp.message.LTTicketResponseMessage;
import com.cloudy.client.midp.message.LoginRequestMessage;
import com.cloudy.client.midp.message.LoginResponseMessage;
import com.cloudy.client.midp.message.MeaningRequestMessage;
import com.cloudy.client.midp.message.MeaningResponseMessage;
import com.cloudy.client.midp.message.OutstandingTicketRequestMessage;
import com.cloudy.client.midp.message.OutstandingTicketResponseMessage;
import com.cloudy.client.midp.message.ReprintRequestMessage;
import com.cloudy.client.midp.message.ReprintResponseMessage;
import com.cloudy.client.midp.message.ResultsRequestMessage;
import com.cloudy.client.midp.message.ResultsResponseMessage;
import com.cloudy.client.midp.message.SaveServerSettingsRequestMessage;
import com.cloudy.client.midp.message.SaveServerSettingsResponseMessage;
import com.cloudy.client.midp.message.SendInvalidBuyReqRequestMessage;
import com.cloudy.client.midp.message.SendInvalidBuyReqResponseMessage;
import com.cloudy.client.midp.message.SubAgentsRequestMessage;
import com.cloudy.client.midp.message.SubAgentsResponseMessage;
import com.cloudy.client.midp.message.TotalStakeRequestMessage;
import com.cloudy.client.midp.message.TotalStakeResponseMessage;
import com.cloudy.client.midp.message.WinningRequestMessage;
import com.cloudy.client.midp.message.WinningResponseMessage;
import com.cloudy.client.midp.model.LocalModel;
import com.cloudy.client.midp.model.PrintDevice;
import com.cloudy.client.midp.model.RemoteModel;
import com.cloudy.client.midp.model.ServerSettings;
import com.cloudy.client.midp.model.Settings;
import com.cloudy.client.midp.util.DateUtil;
import com.cloudy.client.midp.util.ProgressObserver;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Vector;

public class ModelFacade {
    private static final String BASE_NAME_ERROR_RESOURCES = "ErrorResources";
    private static final String L10N_ROOT_DIR = "/rsrc/l10n/";
    public static final String LOCALE_CODE_ENGLISH = "1";
    public static final String LOCALE_CODE_CHINESE = "2";
    public static final String TERMINATION_PASSWORD = "4444";
    private static String DOT = ".";
    private RemoteModel remoteModel;
    private LocalModel localModel = new LocalModel();
    private String locale;
    private String version;
    private String hideURL1 = null;
    private String hideURL2 = null;
    private String hideURL3 = null;
    private boolean isLoggedIn = false;

    public ModelFacade(String serviceURL, String locale, String version, String hideURL1, String hideURL2, String hideURL3) throws ApplicationException {
        String savedServiceURL = this.localModel.getServiceURL();
        if (savedServiceURL == null && serviceURL == null) {
            throw new ApplicationException("Missing service url");
        }
        if (savedServiceURL == null && serviceURL != null && serviceURL.trim().length() > 0) {
            if (!serviceURL.startsWith("http://")) {
                serviceURL = "http://" + serviceURL;
            }
            if (serviceURL.endsWith("/")) {
                serviceURL = serviceURL.substring(0, serviceURL.length() - 1);
            }
            this.localModel.setServiceURL(serviceURL);
            savedServiceURL = new String(serviceURL);
        }
        this.remoteModel = new RemoteModel(savedServiceURL);
        this.setLocale(locale, false);
        this.localModel.setVersion(version);
        this.version = version;
        this.hideURL1 = hideURL1;
        this.hideURL2 = hideURL2;
        this.hideURL3 = hideURL3;
    }

    public void setProgressObserver(ProgressObserver progressObserver) {
        LocalModel.setProgressObserver(progressObserver);
        this.remoteModel.setProgressObserver(progressObserver);
    }

    public void init() throws ApplicationException {
        this.localModel.init();
    }

    public void destroy() throws ApplicationException {
        this.localModel.destroy();
    }

    public void setLocale(String locale) throws ApplicationException {
        this.setLocale(locale, true);
    }

    public void setLocale(String locale, boolean overwrite) throws ApplicationException {
        IndexedResourceBundle errorBundle;
        this.locale = !overwrite ? ((errorBundle = this.localModel.getResourceBundle(BASE_NAME_ERROR_RESOURCES)) != null ? errorBundle.getLocale() : locale) : locale;
        errorBundle = this.getResourceBundle(BASE_NAME_ERROR_RESOURCES);
        ApplicationException.setResourceBundle(errorBundle);
    }

    public String getLocaleCode() {
        if ("en_US".equals(this.locale)) {
            return LOCALE_CODE_ENGLISH;
        }
        if ("zh_CN".equals(this.locale)) {
            return LOCALE_CODE_CHINESE;
        }
        return null;
    }

    public String getHideURL(int type) {
        String str = null;
        switch (type) {
            case 1: {
                str = this.hideURL1;
                break;
            }
            case 2: {
                str = this.hideURL2;
                break;
            }
            case 3: {
                str = this.hideURL3;
            }
        }
        return str;
    }

    public IndexedResourceBundle getResourceBundle(String baseName) throws ApplicationException {
        IndexedResourceBundle resourceBundle = this.localModel.getResourceBundle(baseName);
        if (resourceBundle == null || !resourceBundle.getLocale().equals(this.locale)) {
            try {
                InputStream stream = this.getClass().getResourceAsStream(this.makeResourceBundleName(baseName, this.locale));
                IndexedResourceBundle indexedResourceBundle = resourceBundle = stream != null ? IndexedResourceBundle.getBundleFromPropertyFile(this.locale, stream) : null;
                if (resourceBundle != null) {
                    return resourceBundle;
                }
            }
            catch (IOException ioe) {
                throw new ApplicationException(ioe);
            }
        }
        return resourceBundle;
    }

    private String makeResourceBundleName(String baseName, String locale) {
        return L10N_ROOT_DIR + baseName + "_" + locale + ".properties";
    }

    public void setServiceURL(String serviceURL) throws ApplicationException {
        this.localModel.setServiceURL(serviceURL);
    }

    public String getServiceURL() throws ApplicationException {
        return this.localModel.getServiceURL();
    }

    public void setServiceHideURL(String serviceHideURL) throws ApplicationException {
        this.localModel.setServiceHideURL(serviceHideURL);
    }

    public String getServiceHideURL() throws ApplicationException {
        return this.localModel.getServiceHideURL();
    }

    public void setURL_Type(int urlType) throws ApplicationException {
        this.localModel.setURL_Type(urlType);
    }

    public int getURL_Type() throws ApplicationException {
        return this.localModel.getURL_Type();
    }

    public void setUserId(String userId) throws ApplicationException {
        this.localModel.setUserId(userId);
    }

    public String getUserId() throws ApplicationException {
        return this.localModel.getUserId();
    }

    public void setUserURL(String userUrl) throws ApplicationException {
        this.localModel.setUserURL(userUrl);
    }

    public String getUserURL() throws ApplicationException {
        return this.localModel.getUserURL();
    }

    public void setPrintDevice(PrintDevice device) throws ApplicationException {
        this.localModel.setPrintDevice(device);
    }

    public PrintDevice getPrintDevice() throws ApplicationException {
        return this.localModel.getPrintDevice();
    }

    public boolean isLoggedIn() {
        return this.isLoggedIn;
    }

    public String getStandbyPassword() throws ApplicationException {
        return this.localModel.getStandbyPassword();
    }

    public void setStandbyPassword(String newPassword) throws ApplicationException {
        this.localModel.setStandbyPassword(newPassword);
    }

    public String getBuyMethod() throws ApplicationException {
        return this.localModel.getBuyMethod();
    }

    public void setBuyMethod(String buyMethod) throws ApplicationException {
        this.localModel.setBuyMethod(buyMethod);
    }

    public String getLoginSequence() throws ApplicationException {
        return this.localModel.getLoginSequence();
    }

    public void setLoginSequence(String loginSequence) throws ApplicationException {
        this.localModel.setLoginSequence(loginSequence);
    }

    public String getBetScreenLine2() throws ApplicationException {
        return this.localModel.getBetScreenLine2();
    }

    public void setBetScreenLine2(String betScreenLine2) throws ApplicationException {
        this.localModel.setBetScreenLine2(betScreenLine2);
    }

    public String getBetScreenLine3() throws ApplicationException {
        return this.localModel.getBetScreenLine3();
    }

    public void setBetScreenLine3(String betScreenLine3) throws ApplicationException {
        this.localModel.setBetScreenLine3(betScreenLine3);
    }

    public Settings getSettings() throws ApplicationException {
        return this.localModel.getSettings();
    }

    public void setSettings(Settings settings) throws ApplicationException {
        this.localModel.setSettings(settings);
    }

    public ServerSettings getServerSettings() throws ApplicationException {
        GetServerSettingsRequestMessage reqMsg = new GetServerSettingsRequestMessage(this.version, this.localModel.getAgentId());
        reqMsg.setLocaleCode(this.getLocaleCode());
        GetServerSettingsResponseMessage ssrm = this.remoteModel.getServerSettings(reqMsg);
        ServerSettings ss = new ServerSettings();
        ss.setInputMethodList(ssrm.getInputMethodList());
        ss.setCurrentInputMethodValue(ssrm.getCurrentInputMethodValue());
        ss.setBetTypeList(ssrm.getBetTypeList());
        ss.setCurrentBetType(ssrm.getCurrentBetType());
        return ss;
    }

    public void setServerSettings(String betType, String inputMethod, String buyMethod) throws ApplicationException {
        SaveServerSettingsRequestMessage req = new SaveServerSettingsRequestMessage(this.version, this.localModel.getAgentId());
        req.setBetType(betType);
        req.setInputMethod(inputMethod);
        req.setBuyMethod(buyMethod);
        SaveServerSettingsResponseMessage resMsg = this.remoteModel.saveServerSettings(req);
        if (!resMsg.isSuccess()) {
            throw new ApplicationException(resMsg.getErrCode());
        }
        this.localModel.setBetScreenLine2(resMsg.getBetScreenLine2());
        this.localModel.setBetScreenLine3(resMsg.getBetScreenLine3());
    }

    public String getUpdateURL() throws ApplicationException {
        return this.localModel.getUpdateURL();
    }

    public void setUpdateURL(String updateURL) throws ApplicationException {
        this.localModel.setUpdateURL(updateURL);
    }

    public String getPassword() throws ApplicationException {
        return this.localModel.getPassword();
    }

    public void setPassword(String newPassword) throws ApplicationException {
        this.localModel.setPassword(newPassword);
    }

    public String getAgentId() throws ApplicationException {
        return this.localModel.getAgentId();
    }

    public int getCurrentRunningNumber() throws ApplicationException {
        return this.localModel.getCurrentRunningNumber();
    }

    public int getNextRunningNumber() throws ApplicationException {
        return this.localModel.getNextRunningNumber();
    }

    public void deductRunningNumberByOne() throws ApplicationException {
        this.localModel.deductRunningNumberByOne();
    }

    public void login(String username, String password, String url) throws ApplicationException {
        String address;
        if (url != null && url.trim().length() > 0) {
            if (!(url = url.trim()).startsWith("http://")) {
                url = "http://" + url;
            }
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            this.remoteModel.setServiceURL(url);
        }
        if ((address = this.getBluetoothAddress()) == null) {
            address = "";
        }
        LoginRequestMessage loginReqMsg = new LoginRequestMessage(this.version);
        loginReqMsg.setUsername(username);
        loginReqMsg.setPassword(password);
        loginReqMsg.setBluetoothAddress(address);
        LoginResponseMessage loginResMsg = this.remoteModel.login(loginReqMsg);
        if (loginResMsg.isSuccess()) {
            this.localModel.setAgentId(loginResMsg.getAgentId());
            this.localModel.setLastRunningNumber(loginResMsg.getCurrentRunningNumber());
            this.localModel.setBuyMethod(loginResMsg.getBuyMethod());
            this.localModel.setLoginSequence(loginResMsg.getLoginSequence());
            this.localModel.setBetScreenLine2(loginResMsg.getBetScreenLine2());
            this.localModel.setBetScreenLine3(loginResMsg.getBetScreenLine3());
            Settings s = this.getSettings();
            if (1 == loginResMsg.getInputMethod()) {
                s.setInputType(1);
            } else if (2 == loginResMsg.getInputMethod()) {
                s.setInputType(2);
            } else if (3 == loginResMsg.getInputMethod()) {
                s.setInputType(3);
            } else {
                s.setInputType(99);
            }
            this.setSettings(s);
        }
        this.isLoggedIn = true;
    }

    public Vector getSubAgents() throws ApplicationException {
        SubAgentsRequestMessage req = new SubAgentsRequestMessage(this.version, this.localModel.getAgentId());
        SubAgentsResponseMessage resMsg = this.remoteModel.getSubAgents(req);
        if (resMsg.isSuccess()) {
            return resMsg.getAgents();
        }
        throw new ApplicationException(resMsg.getErrCode());
    }

    public Vector getCurrencyCode() throws ApplicationException {
        CurrencyCodeRequestMessage req = new CurrencyCodeRequestMessage(this.version, this.localModel.getAgentId());
        CurrencyCodeResponseMessage resMsg = this.remoteModel.getCurrencyCode(req);
        if (resMsg.isSuccess()) {
            return resMsg.getCurrencyCode();
        }
        throw new ApplicationException(resMsg.getErrCode());
    }

    public String[] buy(Vector trans, int nextRunningNumber, String loginSequence, boolean noValidation) throws ApplicationException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < trans.size()) {
            sb.append((String)trans.elementAt(i));
            if (i < trans.size() - 1) {
                sb.append("\n");
            }
            ++i;
        }
        String address = this.getBluetoothAddress();
        if (address == null) {
            address = "";
        }
        BuyRequestMessage req = new BuyRequestMessage(this.version, this.localModel.getAgentId());
        req.setNextTransNum(nextRunningNumber);
        req.setTransactionTxt(sb.toString());
        req.setLoginSequence(loginSequence);
        req.setNoValidation(noValidation);
        req.setBluetoothAddress(address);
        BuyResponseMessage resMsg = this.remoteModel.buy(req);
        this.localModel.setLastRunningNumber(Integer.parseInt(resMsg.getLastPageNum()));
        if (resMsg.isSuccess()) {
            return new String[]{resMsg.getTransactionNum(), resMsg.getTransactionText()};
        }
        throw new ApplicationException(resMsg.getErrCode());
    }

    public String[] buy2(Vector trans, int nextRunningNumber, String loginSequence, String currencyCode, boolean noValidation) throws ApplicationException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < trans.size()) {
            sb.append((String)trans.elementAt(i));
            if (i < trans.size() - 1) {
                sb.append("\n");
            }
            ++i;
        }
        String address = this.getBluetoothAddress();
        if (address == null) {
            address = "";
        }
        Buy2RequestMessage req = new Buy2RequestMessage(this.version, this.localModel.getAgentId());
        req.setNextTransNum(nextRunningNumber);
        req.setTransactionTxt(sb.toString());
        req.setLoginSequence(loginSequence);
        req.setLocaleCode(this.getLocaleCode());
        req.setBluetoothAddress(address);
        req.setCurrencyCode(currencyCode);
        Buy2ResponseMessage resMsg = this.remoteModel.buy2(req);
        this.localModel.setLastRunningNumber(Integer.parseInt(resMsg.getLastPageNum()));
        if (resMsg.isSuccess()) {
            return new String[]{resMsg.getTransactionNum(), resMsg.getTransactionText()};
        }
        throw new ApplicationException(resMsg.getErrCode());
    }

    public String[] buySpecial(Vector trans, int nextRunningNumber, String loginSequence, boolean noValidation) throws ApplicationException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < trans.size()) {
            sb.append((String)trans.elementAt(i));
            if (i < trans.size() - 1) {
                sb.append("\n");
            }
            ++i;
        }
        BuySpecialRequestMessage req = new BuySpecialRequestMessage(this.version, this.localModel.getAgentId());
        req.setNextTransNum(nextRunningNumber);
        req.setTransactionTxt(sb.toString());
        req.setLoginSequence(loginSequence);
        req.setNoValidation(noValidation);
        BuySpecialResponseMessage resMsg = this.remoteModel.buySpecial(req);
        this.localModel.setLastRunningNumber(Integer.parseInt(resMsg.getLastPageNum()));
        if (resMsg.isSuccess()) {
            return new String[]{resMsg.getTransactionNum(), resMsg.getTransactionText()};
        }
        throw new ApplicationException(resMsg.getErrCode());
    }

    public String[] buySpecial2(Vector trans, int nextRunningNumber, String loginSequence, boolean noValidation) throws ApplicationException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < trans.size()) {
            sb.append((String)trans.elementAt(i));
            if (i < trans.size() - 1) {
                sb.append("\n");
            }
            ++i;
        }
        BuySpecial2RequestMessage req = new BuySpecial2RequestMessage(this.version, this.localModel.getAgentId());
        req.setNextTransNum(nextRunningNumber);
        req.setTransactionTxt(sb.toString());
        req.setLoginSequence(loginSequence);
        req.setLocaleCode(this.getLocaleCode());
        BuySpecial2ResponseMessage resMsg = this.remoteModel.buySpecial2(req);
        this.localModel.setLastRunningNumber(Integer.parseInt(resMsg.getLastPageNum()));
        if (resMsg.isSuccess()) {
            return new String[]{resMsg.getTransactionNum(), resMsg.getTransactionText()};
        }
        throw new ApplicationException(resMsg.getErrCode());
    }

    public void sendInvalidBuyRequest(Vector trans, int errorLineNumber) throws ApplicationException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < trans.size()) {
            sb.append((String)trans.elementAt(i));
            if (i < trans.size() - 1) {
                sb.append("\n");
            }
            ++i;
        }
        SendInvalidBuyReqRequestMessage req = new SendInvalidBuyReqRequestMessage(this.version, this.localModel.getAgentId());
        req.setTransactionTxt(sb.toString());
        req.setErrorLineNumber(errorLineNumber);
        SendInvalidBuyReqResponseMessage resMsg = this.remoteModel.sendInvalidBuyRequest(req);
    }

    public String reprint(String action, String drawDate, String fromPageNo, String toPageNo, String pageNum, String mobileNo, String password, String betNo) throws ApplicationException {
        ReprintRequestMessage req = new ReprintRequestMessage(this.version, this.localModel.getAgentId());
        req.setAction(action);
        if (drawDate != null) {
            req.setDrawDate(drawDate);
        }
        req.setFromPageNo(fromPageNo);
        req.setToPageNo(toPageNo);
        req.setPageNum(pageNum);
        req.setMobileNo(mobileNo);
        req.setPassword(password);
        req.setBetNo(betNo);
        ReprintResponseMessage res = this.remoteModel.reprint(req);
        if (res.isSuccess()) {
            if ("4".equals(action) && res.getTransactionText() != null && res.getTransactionText().trim().length() > 0) {
                this.localModel.setLastRunningNumber(Integer.parseInt(res.getTransactionText()));
            } else if ("5".equals(action) && res.getTransactionText() != null && res.getTransactionText().trim().length() > 0) {
                return String.valueOf(res.getTransactionText()) + "~" + (res.isSpecial() ? "T" : "F");
            }
            return res.getTransactionText();
        }
        throw new ApplicationException(res.getErrCode());
    }

    public String voidTransaction(String action, String drawDate, String fromPageNo) throws ApplicationException {
        ReprintRequestMessage req = new ReprintRequestMessage(this.version, this.localModel.getAgentId());
        req.setAction(action);
        req.setDrawDate(drawDate);
        req.setFromPageNo(fromPageNo);
        ReprintResponseMessage res = this.remoteModel.reprint(req);
        if (res.isSuccess()) {
            return res.getTransactionText();
        }
        throw new ApplicationException();
    }

    public String balance(Date startDate, Date endDate, String drawType) throws ApplicationException {
        BalanceRequestMessage req = new BalanceRequestMessage(this.version, this.localModel.getAgentId());
        req.setStartDate(DateUtil.getString(startDate));
        req.setEndDate(DateUtil.getString(endDate));
        req.setDrawType(drawType);
        BalanceResponseMessage res = this.remoteModel.balance(req);
        if (res.isSuccess()) {
            return res.getTransactionText();
        }
        throw new ApplicationException(res.getErrCode());
    }

    public String betRecords(String agentCode, String number, Date drawDate, String action) throws ApplicationException {
        BetRecordsRequestMessage req = new BetRecordsRequestMessage(this.version, this.localModel.getAgentId());
        req.setAgentCode(agentCode);
        req.setNumber(number);
        req.setDrawDate(DateUtil.getString(drawDate));
        req.setAction(action);
        BetRecordsResponseMessage res = this.remoteModel.betRecords(req);
        if (res.isSuccess()) {
            return res.getTransactionText();
        }
        throw new ApplicationException(res.getErrCode());
    }

    public String totalStake(Date drawDate) throws ApplicationException {
        TotalStakeRequestMessage req = new TotalStakeRequestMessage(this.version, this.localModel.getAgentId());
        req.setDrawDate(DateUtil.getString(drawDate));
        TotalStakeResponseMessage res = this.remoteModel.totalStake(req);
        if (res.isSuccess()) {
            return res.getTransactionText();
        }
        throw new ApplicationException(res.getErrCode());
    }

    public String results(Date drawDate, String drawType) throws ApplicationException {
        ResultsRequestMessage req = new ResultsRequestMessage(this.version, this.localModel.getAgentId());
        req.setDrawDate(drawDate);
        req.setDrawType(drawType);
        ResultsResponseMessage res = this.remoteModel.results(req);
        if (res.isSuccess()) {
            return res.getTransactionText();
        }
        throw new ApplicationException(res.getErrCode());
    }

    public String winning(Date winningDate) throws ApplicationException {
        WinningRequestMessage req = new WinningRequestMessage(this.version, this.localModel.getAgentId());
        req.setWinningDate(DateUtil.getString(winningDate));
        WinningResponseMessage res = this.remoteModel.winning(req);
        if (res.isSuccess()) {
            return res.getTransactionText();
        }
        throw new ApplicationException(res.getErrCode());
    }

    public String fightNumWinning(Date winningDate) throws ApplicationException {
        FightNumWinningRequestMessage req = new FightNumWinningRequestMessage(this.version, this.localModel.getAgentId());
        req.setWinningDate(DateUtil.getString(winningDate));
        FightNumWinningResponseMessage res = this.remoteModel.fightNumWinning(req);
        if (res.isSuccess()) {
            return res.getTransactionText();
        }
        throw new ApplicationException(res.getErrCode());
    }

    public String meaning(String type, String field) throws ApplicationException {
        MeaningRequestMessage req = new MeaningRequestMessage(this.version, this.localModel.getAgentId());
        req.setType(type);
        req.setField(field);
        req.setLocaleCode(this.getLocaleCode());
        MeaningResponseMessage res = this.remoteModel.meaning(req);
        if (res.isSuccess()) {
            return res.getTransactionText();
        }
        throw new ApplicationException(res.getErrCode());
    }

    public String announcement() throws ApplicationException {
        AnnouncementRequestMessage req = new AnnouncementRequestMessage(this.version, this.localModel.getAgentId());
        req.setLocaleCode(this.getLocaleCode());
        AnnouncementResponseMessage res = this.remoteModel.announcement(req);
        if (res.isSuccess()) {
            return res.getTransactionText();
        }
        throw new ApplicationException(res.getErrCode());
    }

    public String accountStat() throws ApplicationException {
        AccountStatisticRequestMessage req = new AccountStatisticRequestMessage(this.version, this.localModel.getAgentId());
        req.setLocaleCode(this.getLocaleCode());
        AccountStatisticResponseMessage res = this.remoteModel.accountStat(req);
        if (res.isSuccess()) {
            return res.getTransactionText();
        }
        throw new ApplicationException(res.getErrCode());
    }

    public String outstandingTicket(Date date) throws ApplicationException {
        OutstandingTicketRequestMessage req = new OutstandingTicketRequestMessage(this.version, this.localModel.getAgentId());
        req.setLocaleCode(this.getLocaleCode());
        req.setDate(DateUtil.getString(date));
        OutstandingTicketResponseMessage res = this.remoteModel.outstandingTicket(req);
        if (res.isSuccess()) {
            return res.getTransactionText();
        }
        throw new ApplicationException(res.getErrCode());
    }

    public String betManual() throws ApplicationException {
        BetManualRequestMessage req = new BetManualRequestMessage(this.version, this.localModel.getAgentId());
        req.setLocaleCode(this.getLocaleCode());
        BetManualResponseMessage res = this.remoteModel.betManual(req);
        if (res.isSuccess()) {
            return res.getTransactionText();
        }
        throw new ApplicationException(res.getErrCode());
    }

    public boolean changePassword(String oldPassword, String newPassword) throws ApplicationException {
        ChangePasswordRequestMessage req = new ChangePasswordRequestMessage(this.version, this.localModel.getAgentId());
        req.setOldPassword(oldPassword);
        req.setNewPassword(newPassword);
        ChangePasswordResponseMessage res = this.remoteModel.changePassword(req);
        if (res.isSuccess()) {
            return res.isSuccessResponse();
        }
        throw new ApplicationException(res.getErrCode());
    }

    public boolean checkNewVersion() throws ApplicationException {
        CheckNewVersionRequestMessage req = new CheckNewVersionRequestMessage(this.version, this.localModel.getAgentId());
        CheckNewVersionResponseMessage res = this.remoteModel.checkNewVersion(req);
        if (res.isSuccess()) {
            if (res.isNewVersionAvailable()) {
                this.localModel.setUpdateURL(res.getUpdateURL());
            }
            return res.isNewVersionAvailable();
        }
        throw new ApplicationException(res.getErrCode());
    }

    public String getLongTimeTicket(String action) throws ApplicationException {
        LTTicketRequestMessage req = new LTTicketRequestMessage(this.version, this.localModel.getAgentId());
        req.setAction(action);
        LTTicketResponseMessage res = this.remoteModel.getLongtimeTicket(req);
        if (res.isSuccess()) {
            return res.getTransactionText();
        }
        throw new ApplicationException();
    }

    public boolean delLongTimeTicket(String action, String ticketID, String delIndex) throws ApplicationException {
        LTTicketRequestMessage req = new LTTicketRequestMessage(this.version, this.localModel.getAgentId());
        req.setAction(action);
        req.setDelTickID(ticketID);
        LTTicketResponseMessage res = this.remoteModel.delLongtimeTicket(req);
        if (res.isSuccess()) {
            return true;
        }
        throw new ApplicationException();
    }

    public String getCommonHead() throws ApplicationException {
        GetCommonHeadRequestMessage req = new GetCommonHeadRequestMessage(this.version, this.localModel.getAgentId());
        GetCommonHeadResponseMessage res = this.remoteModel.getCommonHead(req);
        if (res.isSuccess()) {
            return res.getTransactionText();
        }
        throw new ApplicationException();
    }

    public Date getServerTime() throws ApplicationException {
        GetServerTimeRequestMessage req = new GetServerTimeRequestMessage(this.version, this.localModel.getAgentId());
        GetServerTimeResponseMessage res = this.remoteModel.getServerTime(req);
        if (res.isSuccess()) {
            return res.getServerDate();
        }
        throw new ApplicationException(res.getErrCode());
    }

    public boolean isTerminated() throws ApplicationException {
        return this.localModel.isTerminated();
    }

    public void setTerminated(boolean isTerminated) throws ApplicationException {
        this.localModel.setTerminated(isTerminated);
    }

    private String sanitizeServiceURL(String serviceURL) {
        if (serviceURL == null || serviceURL.trim().length() == 0) {
            return serviceURL;
        }
        throw new RuntimeException(serviceURL);
    }

    public void setBluetoothAddress(String address) throws ApplicationException {
        this.localModel.setBluetoothAddress(address);
    }

    public String getBluetoothAddress() throws ApplicationException {
        return this.localModel.getBluetoothAddress();
    }
}

