/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.model;

import com.cloudy.client.midp.ApplicationException;
import com.cloudy.client.midp.model.DateObject;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;

public class InitParam {
    private String dateString;
    private int lastBatchNo;
    private DateObject[] submittedDates;
    private DateObject[] pastDrawDates;

    public InitParam() {
    }

    public InitParam(String dateString, int lastBatchNo) {
        this.dateString = dateString;
        this.lastBatchNo = lastBatchNo;
    }

    public String getDateString() {
        return this.dateString;
    }

    public void setDateString(String dateString) {
        this.dateString = dateString;
    }

    public int getLastBatchNo() {
        return this.lastBatchNo;
    }

    public void setLastBatchNo(int lastBatchNo) {
        this.lastBatchNo = lastBatchNo;
    }

    public DateObject[] getSubmittedDates() {
        return this.submittedDates;
    }

    public void setSubmittedDates(DateObject[] submittedDates) {
        this.submittedDates = submittedDates;
    }

    public DateObject[] getPastDrawDates() {
        return this.pastDrawDates;
    }

    public void setPastDrawDates(DateObject[] pastDrawDates) {
        this.pastDrawDates = pastDrawDates;
    }

    public void serialize(DataOutputStream dataStream) throws ApplicationException {
        try {
            dataStream.writeUTF(this.dateString);
            dataStream.writeInt(this.lastBatchNo);
            int size = this.submittedDates.length;
            dataStream.writeInt(size);
            int i = 0;
            while (i < size) {
                this.submittedDates[i].serialize(dataStream);
                ++i;
            }
            int size1 = this.pastDrawDates.length;
            dataStream.writeInt(size1);
            int i2 = 0;
            while (i2 < size1) {
                this.pastDrawDates[i2].serialize(dataStream);
                ++i2;
            }
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
    }

    public static InitParam deserialize(DataInputStream dataStream) throws ApplicationException {
        try {
            InitParam initParam = new InitParam();
            initParam.setDateString(dataStream.readUTF());
            initParam.setLastBatchNo(dataStream.readInt());
            int size = dataStream.readInt();
            DateObject[] dd = new DateObject[size];
            int i = 0;
            while (i < size) {
                dd[i] = new DateObject(new Date(dataStream.readLong()));
                ++i;
            }
            initParam.setSubmittedDates(dd);
            int size1 = dataStream.readInt();
            DateObject[] dd1 = new DateObject[size1];
            int i2 = 0;
            while (i2 < size1) {
                dd1[i2] = new DateObject(new Date(dataStream.readLong()));
                ++i2;
            }
            initParam.setPastDrawDates(dd1);
            return initParam;
        }
        catch (IOException ioe) {
            throw new ApplicationException(ioe);
        }
    }
}

