/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.message;

import com.cloudy.client.midp.ApplicationException;
import com.cloudy.client.midp.message.Message;

public abstract class ResponseMessage
extends Message {
    protected static final char DELIMITER = '~';
    protected Message context = null;
    protected int status;
    private int errCode;
    private String errMsg = null;

    public ResponseMessage(Message context) {
        this.context = context;
    }

    protected void parseResponse(String rawResponse) throws ApplicationException {
        char secondChar;
        if (rawResponse == null || rawResponse.trim().length() == 0) {
            throw new ApplicationException(1003);
        }
        char firstChar = rawResponse.charAt(0);
        if (firstChar == 'S') {
            this.status = 1;
        } else if (firstChar == 'F') {
            this.status = 2;
        } else {
            throw new ApplicationException(1003);
        }
        if (rawResponse.length() > 1 && '~' != (secondChar = rawResponse.charAt(1))) {
            throw new ApplicationException(1003);
        }
        if (this.status == 1) {
            if (rawResponse.length() > 2) {
                this.parseSuccessResponse(rawResponse.substring(2));
            } else {
                this.parseSuccessResponse("");
            }
        } else if (this.status == 2) {
            this.parseErrorResponse(rawResponse);
        }
    }

    protected abstract void parseSuccessResponse(String var1) throws ApplicationException;

    protected void parseErrorResponse(String rawResponse) throws ApplicationException {
        this.status = 2;
        try {
            int idx = rawResponse.indexOf(126, 2);
            if (idx != -1) {
                this.errCode = Integer.parseInt(rawResponse.substring(2, idx));
                this.errMsg = rawResponse.substring(idx + 1);
            } else {
                this.errCode = Integer.parseInt(rawResponse.substring(2));
            }
        }
        catch (NumberFormatException e) {
            throw new ApplicationException(1003, "Invalid error code");
        }
        catch (Exception e) {
            throw new ApplicationException(1003);
        }
        throw new ApplicationException(this.errCode, this.errMsg);
    }

    public Message getContext() {
        return this.context;
    }

    public void setContext(Message context) {
        this.context = context;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public boolean isSuccess() {
        return this.status == 1;
    }
}

