/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.message;

import com.cloudy.client.midp.ApplicationException;
import com.cloudy.client.midp.message.Message;
import com.cloudy.client.midp.message.ResponseMessage;

public class CheckNewVersionResponseMessage
extends ResponseMessage {
    private static final String YES = "Y";
    private static final String NO = "N";
    private String updateURL;
    private boolean newVersionAvailable = false;

    public CheckNewVersionResponseMessage(Message context, String rawResponse) throws ApplicationException {
        super(context);
        this.parseResponse(rawResponse);
    }

    protected void parseSuccessResponse(String plaintext) throws ApplicationException {
        plaintext = plaintext.replace('\r', ' ');
        plaintext = plaintext.replace('\n', ' ');
        if ((plaintext = plaintext.trim()) == null || plaintext.trim().length() == 0) {
            throw new ApplicationException(1003, "Invalid response");
        }
        if (plaintext.startsWith(YES)) {
            this.newVersionAvailable = true;
        } else if (plaintext.startsWith(NO)) {
            this.newVersionAvailable = false;
        } else {
            throw new ApplicationException(1003, "Invalid response");
        }
        if (this.newVersionAvailable) {
            if (plaintext.charAt(1) != '~') {
                throw new ApplicationException(1003, "Invalid response");
            }
            this.updateURL = !plaintext.substring(2).startsWith("http://") ? "http://" + plaintext.substring(2) : plaintext.substring(2);
        }
    }

    public boolean isNewVersionAvailable() {
        return this.newVersionAvailable;
    }

    public String getUpdateURL() {
        return this.updateURL;
    }

    public void setUpdateURL(String updateURL) {
        this.updateURL = updateURL;
    }
}

