/*
 * Decompiled with CFR 0.152.
 */
package com.cloudy.client.midp.message;

import com.cloudy.client.midp.ApplicationException;
import com.cloudy.client.midp.message.Message;
import com.cloudy.client.midp.message.ResponseMessage;

public class BuyResponseMessage
extends ResponseMessage {
    private String transactionNum = null;
    private String transactionText = null;
    private String lastPageNum = null;

    public BuyResponseMessage(Message context, String rawResponse) throws ApplicationException {
        super(context);
        this.parseResponse(rawResponse);
    }

    protected void parseSuccessResponse(String plaintext) throws ApplicationException {
        try {
            int idx = plaintext.indexOf(126);
            if (idx == -1) {
                throw new ApplicationException(1003, "Delimiter not found");
            }
            this.transactionNum = plaintext.substring(0, idx);
            int idx2 = plaintext.indexOf(126, idx + 1);
            if (idx2 == -1) {
                throw new ApplicationException(1003, "Delimiter not found");
            }
            this.transactionText = plaintext.substring(idx + 1, idx2);
            this.lastPageNum = plaintext.substring(idx2 + 1);
        }
        catch (NumberFormatException e) {
            throw new ApplicationException(1003, "Invalid transaction number");
        }
        catch (Exception e) {
            throw new ApplicationException(1003);
        }
    }

    public String getTransactionNum() {
        return this.transactionNum;
    }

    public String getTransactionText() {
        return this.transactionText;
    }

    public String getLastPageNum() {
        return this.lastPageNum;
    }
}

